/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.vm.ContextStore;
import com.oracle.truffle.api.vm.ContextStoreProfile;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.util.Objects;

final class ExecutionImpl {
    private static final ContextStoreProfile CURRENT_VM = new ContextStoreProfile(null);

    ExecutionImpl() {
    }

    static ContextStoreProfile sharedProfile() {
        return CURRENT_VM;
    }

    public static ContextStore createStore(Object vm) {
        return new ContextStore(vm, 4);
    }

    public static ContextStore executionStarted(ContextStore context) {
        Object vm = context.vm;
        Objects.requireNonNull(vm);
        ContextStore prev = CURRENT_VM.get();
        CURRENT_VM.enter(context);
        return prev;
    }

    public static void executionEnded(ContextStore prev) {
    }

    static <C> C findContext(Object currentVM, Class<? extends TruffleLanguage> type) {
        PolyglotEngine vm = (PolyglotEngine)currentVM;
        TruffleLanguage.Env env = vm.findEnv(type);
        return (C)PolyglotEngine.Access.LANGS.findContext(env);
    }

    public static Object findVM() {
        return ExecutionImpl.currentVM();
    }

    private static Object currentVM() {
        ContextStore current = CURRENT_VM.get();
        return current == null ? null : current.vm;
    }
}

