/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

class ModuleResourceLocator {
    ModuleResourceLocator() {
    }

    static ClassLoader createLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String name : new String[]{"java.class.path", "jdk.module.path"}) {
            String value = System.getProperty(name);
            if (value == null) continue;
            ModuleResourceLocator.addURLsFromPath(urls, value);
        }
        int i = 0;
        while (ModuleResourceLocator.addPatchPaths(urls, i)) {
            ++i;
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    private static void addURLsFromPath(List<URL> urls, String paths) {
        for (String path : paths.split(File.pathSeparator)) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean addPatchPaths(List<URL> urls, int i) {
        String patchPropertyName = "jdk.launcher.patch." + i;
        String patchProperty = System.getProperty(patchPropertyName);
        if (patchProperty != null) {
            int eq = patchProperty.indexOf(61);
            ModuleResourceLocator.addURLsFromPath(urls, patchProperty.substring(eq + 1));
            return true;
        }
        return false;
    }
}

