/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.RetryException;

public class CatchRetryAsErrorNode
extends RubyNode {
    @Node.Child
    private RubyNode body;
    private final BranchProfile retryProfile = BranchProfile.create();

    public CatchRetryAsErrorNode(RubyContext context, SourceSection sourceSection, RubyNode body) {
        super(context, sourceSection);
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (RetryException e) {
            this.retryProfile.enter();
            throw new RaiseException(this.coreExceptions().syntaxErrorInvalidRetry(this));
        }
    }
}

