/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.objects.MetaClassNode;
import org.jruby.truffle.language.objects.ShapeCachingGuards;

@GeneratedBy(value=MetaClassNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class MetaClassNodeGen
extends MetaClassNode
implements SpecializedNode {
    @Node.Child
    private RubyNode object_;
    @CompilerDirectives.CompilationFinal
    private Class<?> objectType_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeMetaClassCached_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeUpdateShapeAndMetaClass_;
    @Node.Child
    private BaseNode_ specialization_;

    private MetaClassNodeGen(RubyNode object) {
        this.object_ = object;
        this.specialization_ = UninitializedNode_.create(this);
    }

    private MetaClassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object) {
        super(context, sourceSection);
        this.object_ = object;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public DynamicObject executeMetaClass(Object objectValue) {
        return this.specialization_.executeDynamicObject1(objectValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
        return this.specialization_.executeDynamicObject0(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static MetaClassNode create(RubyNode object) {
        return new MetaClassNodeGen(object);
    }

    public static MetaClassNode create(RubyContext context, SourceSection sourceSection, RubyNode object) {
        return new MetaClassNodeGen(context, sourceSection, object);
    }

    @GeneratedBy(methodName="metaClassFallback(Object)", value=MetaClassNode.class)
    private static final class FallbackNode_
    extends BaseNode_ {
        FallbackNode_(MetaClassNodeGen root) {
            super(root, 0x7FFFFFFE);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean guardFallback(Object objectValue) {
            return this.createNext((Frame)null, objectValue) == null;
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (this.guardFallback(objectValue)) {
                return this.root.metaClassFallback(objectValue);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new FallbackNode_(root);
        }
    }

    @GeneratedBy(methodName="metaClassUncached(DynamicObject)", value=MetaClassNode.class)
    private static final class MetaClassUncachedNode_
    extends BaseNode_ {
        MetaClassUncachedNode_(MetaClassNodeGen root) {
            super(root, 8);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (objectValue instanceof DynamicObject) {
                DynamicObject objectValue_ = (DynamicObject)objectValue;
                return this.root.metaClassUncached(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new MetaClassUncachedNode_(root);
        }
    }

    @GeneratedBy(methodName="updateShapeAndMetaClass(DynamicObject)", value=MetaClassNode.class)
    private static final class UpdateShapeAndMetaClassNode_
    extends BaseNode_ {
        UpdateShapeAndMetaClassNode_(MetaClassNodeGen root) {
            super(root, 7);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue) {
            if (newNode.getClass() == MetaClassUncachedNode_.class) {
                this.removeSame("Contained by metaClassUncached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, objectValue);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            DynamicObject objectValue_;
            if (objectValue instanceof DynamicObject && ShapeCachingGuards.updateShape(objectValue_ = (DynamicObject)objectValue)) {
                return this.root.updateShapeAndMetaClass(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new UpdateShapeAndMetaClassNode_(root);
        }
    }

    @GeneratedBy(methodName="metaClassCached(DynamicObject, Shape, DynamicObject)", value=MetaClassNode.class)
    private static final class MetaClassCachedNode_
    extends BaseNode_ {
        private final Shape cachedShape;
        private final DynamicObject metaClass;
        @CompilerDirectives.CompilationFinal
        private final Assumption assumption0_;

        MetaClassCachedNode_(MetaClassNodeGen root, Shape cachedShape, DynamicObject metaClass, Assumption assumption0_) {
            super(root, 6);
            this.cachedShape = cachedShape;
            this.metaClass = metaClass;
            this.assumption0_ = assumption0_;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue) {
            if (newNode.getClass() == MetaClassUncachedNode_.class) {
                this.removeSame("Contained by metaClassUncached(DynamicObject)");
            }
            return super.merge(newNode, frameValue, objectValue);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object objectValue) {
            DynamicObject objectValue_;
            return objectValue instanceof DynamicObject && (objectValue_ = (DynamicObject)objectValue).getShape() == this.cachedShape;
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            DynamicObject objectValue_;
            try {
                MetaClassCachedNode_.check(this.assumption0_);
            }
            catch (InvalidAssumptionException ae) {
                return (DynamicObject)this.removeThis((CharSequence)"Assumption [assumption0] invalidated", (Frame)null, objectValue);
            }
            if (objectValue instanceof DynamicObject && (objectValue_ = (DynamicObject)objectValue).getShape() == this.cachedShape) {
                return this.root.metaClassCached(objectValue_, this.cachedShape, this.metaClass);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root, Shape cachedShape, DynamicObject metaClass, Assumption assumption0_) {
            return new MetaClassCachedNode_(root, cachedShape, metaClass, assumption0_);
        }
    }

    @GeneratedBy(methodName="metaClassDouble(double)", value=MetaClassNode.class)
    private static final class MetaClassDoubleNode_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        MetaClassDoubleNode_(MetaClassNodeGen root, Object objectValue) {
            super(root, 5);
            this.objectImplicitType = RubyTypesGen.getImplicitDoubleClass(objectValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((MetaClassDoubleNode_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            double objectValue_;
            try {
                if (this.objectImplicitType == Double.TYPE) {
                    objectValue_ = this.root.object_.executeDouble(frameValue);
                } else {
                    Object objectValue__ = this.executeObject_(frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitDouble(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.metaClassDouble(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (RubyTypesGen.isImplicitDouble(objectValue, this.objectImplicitType)) {
                double objectValue_ = RubyTypesGen.asImplicitDouble(objectValue, this.objectImplicitType);
                return this.root.metaClassDouble(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root, Object objectValue) {
            return new MetaClassDoubleNode_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="metaClassLong(long)", value=MetaClassNode.class)
    private static final class MetaClassLongNode_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        MetaClassLongNode_(MetaClassNodeGen root, Object objectValue) {
            super(root, 4);
            this.objectImplicitType = RubyTypesGen.getImplicitLongClass(objectValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((MetaClassLongNode_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            long objectValue_;
            try {
                if (this.objectImplicitType == Long.TYPE) {
                    objectValue_ = this.root.object_.executeLong(frameValue);
                } else if (this.objectImplicitType == Integer.TYPE) {
                    objectValue_ = RubyTypes.promoteToLong(this.root.object_.executeInteger(frameValue));
                } else {
                    Object objectValue__ = this.executeObject_(frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitLong(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.metaClassLong(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (RubyTypesGen.isImplicitLong(objectValue, this.objectImplicitType)) {
                long objectValue_ = RubyTypesGen.asImplicitLong(objectValue, this.objectImplicitType);
                return this.root.metaClassLong(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root, Object objectValue) {
            return new MetaClassLongNode_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="metaClassInt(int)", value=MetaClassNode.class)
    private static final class MetaClassIntNode_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        MetaClassIntNode_(MetaClassNodeGen root, Object objectValue) {
            super(root, 3);
            this.objectImplicitType = RubyTypesGen.getImplicitIntegerClass(objectValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((MetaClassIntNode_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            int objectValue_;
            try {
                if (this.objectImplicitType == Integer.TYPE) {
                    objectValue_ = this.root.object_.executeInteger(frameValue);
                } else {
                    Object objectValue__ = this.executeObject_(frameValue);
                    objectValue_ = RubyTypesGen.expectImplicitInteger(objectValue__, this.objectImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            return this.root.metaClassInt(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            if (RubyTypesGen.isImplicitInteger(objectValue, this.objectImplicitType)) {
                int objectValue_ = RubyTypesGen.asImplicitInteger(objectValue, this.objectImplicitType);
                return this.root.metaClassInt(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root, Object objectValue) {
            return new MetaClassIntNode_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="metaClassFalse(boolean)", value=MetaClassNode.class)
    private static final class MetaClassFalseNode_
    extends BaseNode_ {
        MetaClassFalseNode_(MetaClassNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            boolean objectValue_;
            try {
                objectValue_ = this.root.object_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            if (!objectValue_) {
                return this.root.metaClassFalse(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            boolean objectValue_;
            if (objectValue instanceof Boolean && !(objectValue_ = ((Boolean)objectValue).booleanValue())) {
                return this.root.metaClassFalse(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new MetaClassFalseNode_(root);
        }
    }

    @GeneratedBy(methodName="metaClassTrue(boolean)", value=MetaClassNode.class)
    private static final class MetaClassTrueNode_
    extends BaseNode_ {
        MetaClassTrueNode_(MetaClassNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeDynamicObject0(frameValue);
        }

        @Override
        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            boolean objectValue_;
            try {
                objectValue_ = this.root.object_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeDynamicObject1(ex.getResult());
            }
            if (objectValue_) {
                return this.root.metaClassTrue(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue_);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            boolean objectValue_;
            if (objectValue instanceof Boolean && (objectValue_ = ((Boolean)objectValue).booleanValue())) {
                return this.root.metaClassTrue(objectValue_);
            }
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new MetaClassTrueNode_(root);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(MetaClassNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue));
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            return this.getNext().executeDynamicObject1(objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(MetaClassNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject1(Object objectValue) {
            return (DynamicObject)this.uninitialized((Frame)null, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected MetaClassNodeGen root;

        BaseNode_(MetaClassNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (MetaClassNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.object_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object objectValue) {
            return this.executeDynamicObject1(objectValue);
        }

        public abstract DynamicObject executeDynamicObject1(Object var1);

        public Object execute(VirtualFrame frameValue) {
            Object objectValue_ = this.executeObject_(frameValue);
            return this.executeDynamicObject1(objectValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject0(VirtualFrame frameValue) {
            return (DynamicObject)this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object objectValue) {
            if (objectValue instanceof Boolean) {
                boolean objectValue_ = (Boolean)objectValue;
                if (objectValue_) {
                    return MetaClassTrueNode_.create(this.root);
                }
                return MetaClassFalseNode_.create(this.root);
            }
            if (RubyTypesGen.isImplicitInteger(objectValue)) {
                return MetaClassIntNode_.create(this.root, objectValue);
            }
            if (RubyTypesGen.isImplicitLong(objectValue)) {
                return MetaClassLongNode_.create(this.root, objectValue);
            }
            if (RubyTypesGen.isImplicitDouble(objectValue)) {
                return MetaClassDoubleNode_.create(this.root, objectValue);
            }
            if (objectValue instanceof DynamicObject) {
                DynamicObject objectValue_ = (DynamicObject)objectValue;
                Shape cachedShape6 = objectValue_.getShape();
                if (objectValue_.getShape() == cachedShape6 && !this.root.excludeMetaClassCached_) {
                    BaseNode_ s;
                    DynamicObject metaClass6 = MetaClassNode.getMetaClass(cachedShape6);
                    Assumption assumption0_6 = cachedShape6.getValidAssumption();
                    if (BaseNode_.isValid(assumption0_6) && this.countSame(s = MetaClassCachedNode_.create(this.root, cachedShape6, metaClass6, assumption0_6)) < this.root.getCacheLimit()) {
                        return s;
                    }
                }
                if (ShapeCachingGuards.updateShape(objectValue_) && !this.root.excludeUpdateShapeAndMetaClass_) {
                    return UpdateShapeAndMetaClassNode_.create(this.root);
                }
                this.root.excludeMetaClassCached_ = true;
                this.root.excludeUpdateShapeAndMetaClass_ = true;
                return MetaClassUncachedNode_.create(this.root);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createFallback() {
            return FallbackNode_.create(this.root);
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeObject_(Frame frameValue) {
            Object object;
            Class objectType_ = this.root.objectType_;
            if (objectType_ == Boolean.TYPE) {
                return this.root.object_.executeBoolean((VirtualFrame)frameValue);
            }
            if (objectType_ == Double.TYPE) {
                return this.root.object_.executeDouble((VirtualFrame)frameValue);
            }
            if (objectType_ == Integer.TYPE) {
                return this.root.object_.executeInteger((VirtualFrame)frameValue);
            }
            if (objectType_ == Long.TYPE) {
                return this.root.object_.executeLong((VirtualFrame)frameValue);
            }
            if (objectType_ != null) return this.root.object_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.object_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.objectType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.objectType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.objectType_ = _type;
            return object;
        }
    }
}

