/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class FlipParseNode
extends ParseNode {
    private final ParseNode beginNode;
    private final ParseNode endNode;
    private final boolean exclusive;
    private final int location;

    public FlipParseNode(ISourcePosition position, ParseNode beginNode, ParseNode endNode, boolean exclusive, int location) {
        super(position, beginNode.containsVariableAssignment() || endNode.containsVariableAssignment());
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = beginNode;
        this.endNode = endNode;
        this.exclusive = exclusive;
        this.location = location;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FLIPNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitFlipNode(this);
    }

    public ParseNode getBeginNode() {
        return this.beginNode;
    }

    public ParseNode getEndNode() {
        return this.endNode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.beginNode, this.endNode);
    }
}

