/* plank.vapi generated by valac 0.34.4, do not modify. */

namespace Plank {
	[CCode (cheader_filename = "plank.h")]
	public abstract class AbstractMain : Gtk.Application {
		public AbstractMain ();
		public override void activate ();
		public override int command_line (GLib.ApplicationCommandLine command_line);
		protected virtual void create_actions ();
		protected virtual void create_docks ();
		public override int handle_local_options (GLib.VariantDict options);
		protected virtual void initialize ();
		public bool is_launcher_for_dock (string launcher);
		public override void startup ();
		public string[] about_artists { get; set construct; }
		public string[] about_authors { get; set construct; }
		public string[] about_documenters { get; set construct; }
		public Gtk.License about_license_type { get; set construct; }
		public string about_translators { get; set construct; }
		public string app_copyright { get; construct; }
		public string app_dbus { get; construct; }
		public string app_icon { get; construct; }
		public string app_launcher { get; construct; }
		public string build_data_dir { get; construct; }
		public string build_pkg_data_dir { get; construct; }
		public string build_release_name { get; construct; }
		public string build_version { get; construct; }
		public string build_version_info { get; construct; }
		public string exec_name { get; construct; }
		public string help_url { get; set construct; }
		public string main_url { get; set construct; }
		public string program_name { get; construct; }
		public string translate_url { get; set construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class ApplicationDockItem : Plank.DockItem {
		public ApplicationDockItem ();
		public override bool accept_drop (Gee.ArrayList<string> uris);
		public override bool can_accept_drop (Gee.ArrayList<string> uris);
		public override string get_drop_text ();
		public override Gee.ArrayList<Gtk.MenuItem> get_menu_items ();
		public unowned string? get_unity_application_uri ();
		public unowned string? get_unity_dbusname ();
		public bool has_unity_info ();
		public bool is_running ();
		public bool is_window ();
		protected override void load_from_launcher ();
		protected override Plank.AnimationType on_clicked (Plank.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
		protected override Plank.AnimationType on_scrolled (Gdk.ScrollDirection direction, Gdk.ModifierType mod, uint32 event_time);
		public static void parse_launcher (string launcher, out string icon, out string text, Gee.ArrayList<string>? actions = null, Gee.Map<string,string>? actions_map = null, Gee.ArrayList<string>? mimes = null);
		public void set_urgent (bool is_urgent);
		public void unity_reset ();
		public void unity_update (string sender_name, GLib.VariantIter prop_iter);
		public ApplicationDockItem.with_dockitem_file (GLib.File file);
		public ApplicationDockItem.with_dockitem_filename (string filename);
		public Bamf.Application? App { internal get; internal set construct; }
		public signal void app_closed ();
		public signal void app_window_added ();
		public signal void app_window_removed ();
		public signal void pin_launcher ();
	}
	[CCode (cheader_filename = "plank.h")]
	public class ApplicationDockItemProvider : Plank.DockItemProvider, Plank.UnityClient {
		public ApplicationDockItemProvider (GLib.File launchers_dir);
		public override bool add_item_with_uri (string uri, Plank.DockItem? target = null);
		protected virtual void app_opened (Bamf.Application app);
		protected override void connect_element (Plank.DockElement element);
		protected void delay_items_monitor ();
		protected override void disconnect_element (Plank.DockElement element);
		public override string[] get_dockitem_filenames ();
		protected unowned Plank.ApplicationDockItem? item_for_application (Bamf.Application app);
		public override void prepare ();
		protected void resume_items_monitor ();
		public GLib.File LaunchersDir { get; construct; }
		public signal void item_window_added (Plank.ApplicationDockItem item);
	}
	[CCode (cheader_filename = "plank.h")]
	public class CompositedWindow : Gtk.Window {
		public CompositedWindow ();
		public override bool draw (Cairo.Context cr);
		public CompositedWindow.with_type (Gtk.WindowType window_type);
	}
	[CCode (cheader_filename = "plank.h")]
	public class DBusClient : GLib.Object {
		public bool add_item (string uri);
		public static unowned Plank.DBusClient get_instance ();
		public int get_items_count ();
		public unowned string[]? get_persistent_applications ();
		public unowned string[]? get_transient_applications ();
		public bool remove_item (string uri);
		public bool is_connected { get; }
		public signal void proxy_changed ();
	}
	[CCode (cheader_filename = "plank.h")]
	public class DBusManager : GLib.Object {
		public DBusManager (Plank.DockController controller);
		public Plank.DockController controller { private get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DefaultApplicationDockItemProvider : Plank.ApplicationDockItemProvider {
		public DefaultApplicationDockItemProvider (Plank.DockPreferences prefs, GLib.File launchers_dir);
		protected override void app_opened (Bamf.Application app);
		protected override void connect_element (Plank.DockElement element);
		protected override void disconnect_element (Plank.DockElement element);
		protected override void handle_item_deleted (Plank.DockItem item);
		public void pin_item (Plank.DockItem item);
		public override void prepare ();
		protected override void update_visible_elements ();
		public Plank.DockPreferences Prefs { get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public abstract class DockContainer : Plank.DockElement {
		protected Gee.ArrayList<Plank.DockElement> internal_elements;
		protected static Plank.PlaceholderDockItem placeholder_item;
		protected Gee.ArrayList<Plank.DockElement> visible_elements;
		public DockContainer ();
		public bool add (Plank.DockElement element, Plank.DockElement? target = null);
		public bool add_all (Gee.ArrayList<Plank.DockElement> elements);
		public bool clear ();
		protected abstract void connect_element (Plank.DockElement element);
		protected abstract void disconnect_element (Plank.DockElement element);
		protected static void move_element (Gee.List<Plank.DockElement> elements, int from, int to, Gee.List<weak Plank.DockElement>? moved = null);
		public virtual bool move_to (Plank.DockElement move, Plank.DockElement target);
		public virtual void prepare ();
		public void prepend (Plank.DockElement element);
		public bool remove (Plank.DockElement element);
		public bool remove_all (Gee.ArrayList<Plank.DockElement> elements);
		public virtual bool replace (Plank.DockElement new_element, Plank.DockElement old_element);
		public override void reset_buffers ();
		protected virtual void update_visible_elements ();
		public Gee.ArrayList<Plank.DockElement> Elements { get; }
		public Gee.ArrayList<Plank.DockElement> VisibleElements { get; }
		public signal void elements_changed (Gee.List<Plank.DockElement> added, Gee.List<Plank.DockElement> removed);
		public signal void positions_changed (Gee.List<weak Plank.DockElement> elements);
		public signal void states_changed ();
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockController : Plank.DockContainer {
		public DockController (string dock_name, GLib.File config_folder);
		public void add_default_provider ();
		protected override void connect_element (Plank.DockElement element);
		protected override void disconnect_element (Plank.DockElement element);
		public void initialize ();
		protected override void update_visible_elements ();
		public Gee.ArrayList<weak Plank.DockItem> Items { get; }
		public Gee.ArrayList<weak Plank.DockItem> VisibleItems { get; }
		public GLib.File config_folder { get; construct; }
		public Plank.DockItemProvider? default_provider { get; private set; }
		public Plank.DragManager drag_manager { get; protected set; }
		public Plank.HideManager hide_manager { get; protected set; }
		public Plank.HoverWindow hover { get; protected set; }
		public GLib.File launchers_folder { get; private set; }
		public string name { get; construct; }
		public Plank.PositionManager position_manager { get; protected set; }
		public Plank.DockPreferences prefs { get; construct; }
		public Plank.DockRenderer renderer { get; protected set; }
		public Plank.DockWindow window { get; protected set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public abstract class DockElement : GLib.Object {
		public DockElement ();
		public virtual bool accept_drop (Gee.ArrayList<string> uris);
		public string as_uri ();
		public virtual bool can_accept_drop (Gee.ArrayList<string> uris);
		public virtual bool can_be_removed ();
		public void clicked (Plank.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
		protected static Gtk.MenuItem create_menu_item (string title, string? icon = null, bool force_show_icon = false);
		protected static Gtk.MenuItem create_menu_item_with_pixbuf (string title, owned Gdk.Pixbuf pixbuf, bool force_show_icon = false);
		public unowned Plank.DockController? get_dock ();
		public virtual string get_drop_text ();
		public virtual Gee.ArrayList<Gtk.MenuItem> get_menu_items ();
		public void hovered ();
		protected virtual Plank.AnimationType on_clicked (Plank.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
		protected virtual Plank.AnimationType on_hovered ();
		protected virtual Plank.AnimationType on_scrolled (Gdk.ScrollDirection direction, Gdk.ModifierType mod, uint32 event_time);
		public abstract void reset_buffers ();
		public void scrolled (Gdk.ScrollDirection direction, Gdk.ModifierType mod, uint32 event_time);
		public virtual string unique_id ();
		public int64 AddTime { get; set; }
		public Plank.PopupButton Button { get; protected set; }
		public Plank.AnimationType ClickedAnimation { get; protected set; }
		public Plank.DockContainer? Container { get; set; }
		public Plank.AnimationType HoveredAnimation { get; protected set; }
		public bool IsAttached { get; set; }
		public bool IsVisible { get; set; }
		public int64 LastActive { get; protected set; }
		public int64 LastClicked { get; protected set; }
		public int64 LastHovered { get; protected set; }
		public int64 LastMove { get; protected set; }
		public int64 LastScrolled { get; protected set; }
		public int64 LastUrgent { get; protected set; }
		public int64 LastValid { get; protected set; }
		public int64 RemoveTime { get; set; }
		public Plank.AnimationType ScrolledAnimation { get; protected set; }
		public string Text { get; set; }
		public signal void needs_redraw ();
	}
	[CCode (cheader_filename = "plank.h")]
	public abstract class DockItem : Plank.DockElement {
		public DockItem ();
		public void copy_values_to (Plank.DockItem target);
		public void @delete ();
		protected virtual void draw_icon (Plank.Surface surface);
		protected virtual void draw_icon_fast (Plank.Surface surface);
		public Plank.Surface? get_background_surface (int width, int height, Plank.Surface model, Plank.DrawDataFunc<Plank.DockItem>? draw_data_func);
		public Plank.Surface? get_foreground_surface (int width, int height, Plank.Surface model, Plank.DrawDataFunc<Plank.DockItem>? draw_data_func);
		public Plank.Surface get_surface (int width, int height, Plank.Surface model);
		public Plank.Surface get_surface_copy (int width, int height, Plank.Surface model);
		public virtual bool is_valid ();
		protected virtual void load_from_launcher ();
		public override void reset_buffers ();
		protected void reset_icon_buffer ();
		public void unset_move_state ();
		public Plank.Color AverageIconColor { get; protected set; }
		public int64 Count { get; set; }
		public bool CountVisible { get; set; }
		public string DockItemFilename { owned get; }
		protected Gdk.Pixbuf? ForcePixbuf { get; set; }
		public string Icon { get; set; }
		public Plank.IndicatorState Indicator { get; protected set; }
		public int LastPosition { get; protected set; }
		public string Launcher { get; }
		public int Position { get; set; }
		public Plank.DockItemPreferences Prefs { get; construct; }
		public double Progress { get; set; }
		public bool ProgressVisible { get; set; }
		public Plank.ItemState State { get; protected set; }
		public signal void deleted ();
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockItemDrawValue {
		public Gdk.Rectangle background_region;
		public Plank.PointD center;
		public double darken;
		public Gdk.Rectangle draw_region;
		public Gdk.Rectangle hover_region;
		public double icon_size;
		public double lighten;
		public double opacity;
		public bool show_indicator;
		public Plank.PointD static_center;
		public double zoom;
		public DockItemDrawValue ();
		public void move_in (Gtk.PositionType position, double damount);
		public void move_right (Gtk.PositionType position, double damount);
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockItemPreferences : Plank.Preferences {
		public DockItemPreferences ();
		public override void reset_properties ();
		protected override void verify (string prop);
		public DockItemPreferences.with_file (GLib.File file);
		public DockItemPreferences.with_filename (string filename);
		public DockItemPreferences.with_launcher (string launcher);
		[Description (blurb = "The uri for this item.", nick = "launcher")]
		public string Launcher { get; set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockItemProvider : Plank.DockContainer {
		public DockItemProvider ();
		public override bool accept_drop (Gee.ArrayList<string> uris);
		public virtual bool add_item_with_uri (string uri, Plank.DockItem? target = null);
		public override bool can_accept_drop (Gee.ArrayList<string> uris);
		protected override void connect_element (Plank.DockElement element);
		protected override void disconnect_element (Plank.DockElement element);
		public virtual string[] get_dockitem_filenames ();
		protected virtual void handle_item_deleted (Plank.DockItem item);
		public virtual bool item_exists_for_uri (string uri);
		public virtual unowned Plank.DockItem? item_for_uri (string uri);
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockPreferences : Plank.Settings {
		public const int MAX_ICON_SIZE;
		public const int MAX_ICON_ZOOM;
		public const int MIN_ICON_SIZE;
		public const int MIN_ICON_ZOOM;
		public DockPreferences (string name);
		public void decrease_icon_size ();
		public void increase_icon_size ();
		public bool is_horizontal_dock ();
		protected override void verify (string prop);
		[Description (blurb = "The alignment for the dock on the monitor's edge.  If 0, panel-mode.  If 1, left-aligned.  If 2, right-aligned.  If 3, centered.", nick = "alignment")]
		public Gtk.Align Alignment { get; set; }
		[Description (blurb = "Whether to automatically pin an application if it seems useful to do.", nick = "auto-pinning")]
		public bool AutoPinning { get; set; }
		[Description (blurb = "Whether to show only windows of the current workspace.", nick = "current-workspace-only")]
		public bool CurrentWorkspaceOnly { get; set; }
		[Description (blurb = "Array of the dockitem-files on this dock. DO NOT MODIFY", nick = "dock-items")]
		public string[] DockItems { get; set; }
		[Description (blurb = "Time (in ms) to wait before hiding the dock.", nick = "hide-delay")]
		public uint HideDelay { get; set; }
		[Description (blurb = "If 0, the dock won't hide.  If 1, the dock intelligently hides.  If 2, the dock auto-hides. If 3, the dock dodges active maximized windows. If 4, the dock dodges every window.", nick = "hide-mode")]
		public Plank.HideType HideMode { get; set; }
		[Description (blurb = "The size of dock icons (in pixels).", nick = "icon-size")]
		public int IconSize { get; set; }
		[Description (blurb = "The alignment of the items in this dock if panel-mode is used.  If 1, left-aligned.  If 2, right-aligned.  If 3, centered.", nick = "items-alignment")]
		public Gtk.Align ItemsAlignment { get; set; }
		[Description (blurb = "Whether to prevent drag'n'drop actions and lock items on the dock.", nick = "lock-items")]
		public bool LockItems { get; set; }
		[Description (blurb = "The plug-name of the monitor for the dock to show on (e.g. DVI-I-1, HDMI1, LVDS1). Leave this empty to keep on the primary monitor.", nick = "monitor")]
		public string Monitor { get; set; }
		[Description (blurb = "The dock's position offset from center (in percent).", nick = "offset")]
		public int Offset { get; set; }
		[Description (blurb = "Whether to show only pinned applications. Useful for running more then one dock.", nick = "pinned-only")]
		public bool PinnedOnly { get; set; }
		[Description (blurb = "The position for the dock on the monitor.  If 0, left.  If 1, right.  If 2, top.  If 3, bottom.", nick = "position")]
		public Gtk.PositionType Position { get; set; }
		[Description (blurb = "Whether to use pressure-based revealing of the dock if the support is available.", nick = "pressure-reveal")]
		public bool PressureReveal { get; set; }
		[Description (blurb = "Whether to show the item for the dock itself.", nick = "show-dock-item")]
		public bool ShowDockItem { get; set; }
		[Description (blurb = "The name of the dock's theme to use.", nick = "theme")]
		public string Theme { get; set; }
		[Description (blurb = "Whether to show tooltips when items are hovered.", nick = "tooltips-enabled")]
		public bool TooltipsEnabled { get; set; }
		[Description (blurb = "Time (in ms) to wait before unhiding the dock.", nick = "unhide-delay")]
		public uint UnhideDelay { get; set; }
		[Description (blurb = "Whether the dock will zoom when hovered.", nick = "zoom-enabled")]
		public bool ZoomEnabled { get; set; }
		[Description (blurb = "The dock's icon-zoom (in percent).", nick = "zoom-percent")]
		public uint ZoomPercent { get; set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockRenderer : Plank.Renderer {
		public DockRenderer (Plank.DockController controller, Gtk.Window window);
		public void animate_items (Gee.List<Plank.DockElement> elements);
		protected override bool animation_needed (int64 frame_time);
		public override void draw (Cairo.Context cr, int64 frame_time);
		public void initialize ();
		protected override void initialize_frame (int64 frame_time);
		public void reset_buffers ();
		public void update_local_cursor (int x, int y);
		public Plank.DockController controller { private get; construct; }
		[CCode (notify = false)]
		public double hide_progress { get; private set; }
		[CCode (notify = false)]
		public Gdk.Point local_cursor { get; private set; }
		public Plank.DockTheme theme { get; private set; }
		[CCode (notify = false)]
		public double zoom_in_progress { get; private set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockTheme : Plank.Theme {
		public DockTheme (string name);
		public Plank.Surface create_background (int width, int height, Gtk.PositionType position, Plank.Surface model);
		public Plank.Surface create_indicator (int size, Plank.Color color, Plank.Surface model);
		public Plank.Surface create_urgent_glow (int size, Plank.Color color, Plank.Surface model);
		public void draw_active_glow (Plank.Surface surface, Gdk.Rectangle clip_rect, Gdk.Rectangle rect, Plank.Color color, double opacity, Gtk.PositionType pos);
		public void draw_item_count (Plank.Surface surface, int icon_size, Plank.Color color, int64 count);
		public void draw_item_progress (Plank.Surface surface, int icon_size, Plank.Color color, double progress);
		protected override void reset_properties ();
		protected override void verify (string prop);
		[Description (blurb = "The amount of time (in ms) for active window indicator animations.", nick = "active-time")]
		public int ActiveTime { get; set; }
		[Description (blurb = "The padding on the bottom dock edge, in tenths of a percent of IconSize.", nick = "bottom-padding")]
		public double BottomPadding { get; set; }
		[Description (blurb = "Whether background and icons will unhide/hide with different speeds. The top-border of both will leave/hit the screen-edge at the same time.", nick = "cascade-hide")]
		public bool CascadeHide { get; set; }
		[Description (blurb = "The amount of time (in ms) for click animations.", nick = "click-time")]
		public int ClickTime { get; set; }
		[Description (blurb = "The opacity value (0 to 1) to fade the dock to when hiding it.", nick = "fade-opacity")]
		public double FadeOpacity { get; set; }
		[Description (blurb = "The time (in ms) to fade the dock in/out on a hide (if FadeOpacity is < 1).", nick = "fade-time")]
		public int FadeTime { get; set; }
		[Description (blurb = "The time (in ms) of each pulse of the hidden-dock urgent glow.", nick = "glow-pulse-time")]
		public int GlowPulseTime { get; set; }
		[Description (blurb = "The size of the urgent glow (shown when dock is hidden), in tenths of a percent of IconSize.", nick = "glow-size")]
		public int GlowSize { get; set; }
		[Description (blurb = "The total time (in ms) to show the hidden-dock urgent glow.", nick = "glow-time")]
		public int GlowTime { get; set; }
		[Description (blurb = "The time (in ms) to slide the dock in/out on a hide (if FadeOpacity is 1).", nick = "hide-time")]
		public int HideTime { get; set; }
		[Description (blurb = "The padding on the left/right dock edges, in tenths of a percent of IconSize.", nick = "horizontal-padding")]
		public double HorizPadding { get; set; }
		[Description (blurb = "The size of the icon-shadow behind every item, in tenths of a percent of IconSize.", nick = "icon-shadow-size")]
		public double IconShadowSize { get; set; }
		[Description (blurb = "The size of item indicators, in tenths of a percent of IconSize.", nick = "indicator-size")]
		public double IndicatorSize { get; set; }
		[Description (blurb = "The time (in ms) to move an item to its new position or its addition/removal to/from the dock.", nick = "item-move-time")]
		public int ItemMoveTime { get; set; }
		[Description (blurb = "The padding between items on the dock, in tenths of a percent of IconSize.", nick = "item-padding")]
		public double ItemPadding { get; set; }
		[Description (blurb = "The height (in percent of IconSize) to bounce an icon when launching an application.", nick = "launch-bounce")]
		public double LaunchBounceHeight { get; set; }
		[Description (blurb = "The amount of time (in ms) to bounce an icon when launching an application.", nick = "launch-bounce-time")]
		public int LaunchBounceTime { get; set; }
		[Description (blurb = "The amount of time (in ms) to slide icons into/out of the dock.", nick = "slide-time")]
		public int SlideTime { get; set; }
		[Description (blurb = "The padding on the top dock edge, in tenths of a percent of IconSize.", nick = "top-padding")]
		public double TopPadding { get; set; }
		[Description (blurb = "The height (in percent of IconSize) to bounce an icon when the application sets urgent.", nick = "urgent-bounce")]
		public double UrgentBounceHeight { get; set; }
		[Description (blurb = "The amount of time (in ms) to bounce an urgent icon.", nick = "urgent-bounce-time")]
		public int UrgentBounceTime { get; set; }
		[Description (blurb = "The hue-shift (-180 to 180) of the urgent indicator color.", nick = "urgent-hue-shift")]
		public int UrgentHueShift { get; set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockWindow : Plank.CompositedWindow {
		public DockWindow (Plank.DockController controller);
		public override bool button_press_event (Gdk.EventButton event);
		public override bool button_release_event (Gdk.EventButton event);
		public override bool configure_event (Gdk.EventConfigure event);
		public override void drag_begin (Gdk.DragContext context);
		public override bool draw (Cairo.Context cr);
		public override bool enter_notify_event (Gdk.EventCrossing event);
		public override bool leave_notify_event (Gdk.EventCrossing event);
		public override bool map_event (Gdk.EventAny event);
		public bool menu_is_visible ();
		public override bool motion_notify_event (Gdk.EventMotion event);
		public override bool scroll_event (Gdk.EventScroll event);
		public bool update_hovered (int x, int y);
		public void update_icon_region (Plank.ApplicationDockItem appitem);
		public void update_icon_regions ();
		public void update_size_and_position ();
		public Plank.DockItem? HoveredItem { get; private set; }
		public Plank.DockItemProvider? HoveredItemProvider { get; private set; }
		public Plank.DockController controller { private get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public abstract class DockletItem : Plank.DockItem {
		public DockletItem ();
		public override bool is_valid ();
	}
	[CCode (cheader_filename = "plank.h")]
	public class DockletManager : GLib.Object {
		public static unowned Plank.DockletManager get_default ();
		public Plank.Docklet? get_docklet_by_id (string id);
		public Plank.Docklet? get_docklet_by_uri (string uri);
		public Gee.Collection<Plank.Docklet> list_docklets ();
		public void load_docklets ();
		public void register_docklet (GLib.Type type);
		public signal void docklet_added (Plank.Docklet docklet);
	}
	[CCode (cheader_filename = "plank.h")]
	public class DragManager : GLib.Object {
		public DragManager (Plank.DockController controller);
		public bool drop_is_accepted_by (Plank.DockItem item);
		public void ensure_proxy ();
		public void initialize ();
		public Plank.DockItem? DragItem { get; private set; }
		public bool DragNeedsCheck { get; private set; }
		public bool ExternalDragActive { get; private set; }
		public bool InternalDragActive { get; private set; }
		public bool RepositionMode { get; private set; }
		public Plank.DockController controller { private get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class DrawingService : GLib.Object {
		public static Gdk.Pixbuf ar_scale (Gdk.Pixbuf source, int width, int height);
		public static Plank.Color average_color (Gdk.Pixbuf source);
		public static string? get_icon_from_file (GLib.File file);
		public static string? get_icon_from_gicon (GLib.Icon? icon);
		public static unowned Gtk.IconTheme get_icon_theme ();
		public static Gdk.Pixbuf load_icon (string names, int width, int height);
		public static Cairo.Surface? load_icon_for_scale (string names, int width, int height, int scale);
		public static GLib.File? try_get_icon_file (string name);
	}
	[CCode (cheader_filename = "plank.h")]
	public class Factory : GLib.Object {
		public static Plank.ItemFactory item_factory;
		public static Plank.AbstractMain main;
		public Factory ();
		public static void init (Plank.AbstractMain main_class, Plank.ItemFactory item);
	}
	[CCode (cheader_filename = "plank.h")]
	public class FileDockItem : Plank.DockItem {
		public FileDockItem ();
		protected override void draw_icon (Plank.Surface surface);
		protected override void draw_icon_fast (Plank.Surface surface);
		public override Gee.ArrayList<Gtk.MenuItem> get_menu_items ();
		public void launch ();
		protected override void load_from_launcher ();
		protected override Plank.AnimationType on_clicked (Plank.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
		public FileDockItem.with_dockitem_file (GLib.File file);
		public FileDockItem.with_dockitem_filename (string filename);
		public FileDockItem.with_file (GLib.File file);
		public GLib.File OwnedFile { get; protected set construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class HideManager : GLib.Object {
		public HideManager (Plank.DockController controller);
		public void initialize ();
		public void update_barrier ();
		public void update_hovered ();
		public void update_hovered_with_coords (int x, int y);
		public bool Disabled { get; private set; }
		public bool Hidden { get; private set; }
		public bool Hovered { get; private set; }
		public Plank.DockController controller { private get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class HoverWindow : Gtk.Window {
		public HoverWindow ();
		public override bool draw (Cairo.Context cr);
		public void set_text (string text);
		public void show_at (int x, int y, Gtk.PositionType position);
	}
	[CCode (cheader_filename = "plank.h")]
	public class ItemFactory : GLib.Object {
		public GLib.File launchers_dir;
		public ItemFactory ();
		protected Plank.DockElement default_make_element (GLib.File file, string launcher);
		public virtual Plank.DockItem get_item_for_dock ();
		protected string get_launcher_from_dockitem (GLib.File file);
		public Gee.ArrayList<Plank.DockElement> load_elements (GLib.File source_dir, string[]? ordering = null);
		public void make_default_items ();
		public GLib.File? make_dock_item (string uri, GLib.File? target_dir = null);
		public virtual Plank.DockElement make_element (GLib.File file);
	}
	[CCode (cheader_filename = "plank.h")]
	public class Logger : GLib.Object {
		public static void initialize (string app_name);
		public static void notification (string msg, string icon = "");
		public static void verbose (string msg, ...);
		public static Plank.LogLevel DisplayLevel { get; set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class Paths : GLib.Object {
		public static bool ensure_directory_exists (GLib.File dir);
		public static void initialize (string app_name, string data_folder);
		public static GLib.File AppCacheFolder { get; protected set; }
		public static GLib.File AppConfigFolder { get; protected set; }
		public static GLib.File AppDataFolder { get; protected set; }
		public static string AppName { get; protected set; }
		public static GLib.File AppThemeFolder { get; protected set; }
		public static GLib.File CacheHomeFolder { get; protected set; }
		public static GLib.File ConfigHomeFolder { get; protected set; }
		public static Gee.ArrayList<GLib.File> DataDirFolders { get; protected set; }
		public static GLib.File DataFolder { get; protected set; }
		public static GLib.File DataHomeFolder { get; protected set; }
		public static GLib.File HomeFolder { get; protected set; }
		public static GLib.File ThemeFolder { get; protected set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class PlaceholderDockItem : Plank.DockItem {
		public PlaceholderDockItem ();
		public override bool can_be_removed ();
		public override string get_drop_text ();
		public override bool is_valid ();
		protected override Plank.AnimationType on_clicked (Plank.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
	}
	[CCode (cheader_filename = "plank.h")]
	public class PlankDockItem : Plank.DockItem {
		public override bool can_be_removed ();
		public static unowned Plank.PlankDockItem get_instance ();
		public override Gee.ArrayList<Gtk.MenuItem> get_menu_items ();
		protected override Plank.AnimationType on_clicked (Plank.PopupButton button, Gdk.ModifierType mod, uint32 event_time);
	}
	[CCode (cheader_filename = "plank.h")]
	public class PoofWindow : Plank.CompositedWindow {
		public PoofWindow ();
		public override bool draw (Cairo.Context cr);
		public static unowned Plank.PoofWindow get_default ();
		public void show_at (int x, int y);
	}
	[CCode (cheader_filename = "plank.h")]
	public class PositionManager : GLib.Object {
		public PositionManager (Plank.DockController controller);
		public void get_background_padding (out int x, out int y);
		public Gdk.Rectangle get_background_region ();
		public Gdk.Rectangle get_barrier ();
		public unowned Plank.DockItem? get_current_target_item (Plank.DockContainer? container = null);
		public Gdk.Rectangle get_cursor_region ();
		public void get_dock_draw_position (out int x, out int y);
		public Gdk.Rectangle get_dock_window_region ();
		public Plank.DockItemDrawValue get_draw_value_for_item (Plank.DockItem item);
		public void get_hover_position (Plank.DockItem hovered, out int x, out int y);
		public void get_hover_position_at (ref int x, ref int y);
		public Gdk.Rectangle get_hover_region_for_element (Plank.DockElement element);
		public Gdk.Rectangle get_icon_geometry (Plank.ApplicationDockItem item, bool for_hidden);
		public void get_menu_position (Plank.DockItem hovered, Gtk.Requisition requisition, out int x, out int y);
		public static string[] get_monitor_plug_names (Gdk.Screen screen);
		public unowned Plank.DockItem? get_nearest_item_at (int x, int y, Plank.DockContainer? container = null);
		public Gdk.Rectangle get_static_dock_region ();
		public void get_struts (ref ulong[] struts);
		public void get_urgent_glow_position (Plank.DockItem item, out int x, out int y);
		public void initialize ();
		public bool is_horizontal_dock ();
		public void update (Plank.DockTheme theme);
		public void update_dock_position ();
		public void update_draw_values (Gee.ArrayList<weak Plank.DockItem> items, Plank.DrawValueFunc? func = null, Plank.DrawValuesFunc? post_func = null);
		public void update_regions ();
		public Gtk.Align Alignment { get; private set; }
		public int BottomPadding { get; private set; }
		public int GlowSize { get; private set; }
		public int HorizPadding { get; private set; }
		public int IconShadowSize { get; private set; }
		public int IconSize { get; private set; }
		public int IndicatorSize { get; private set; }
		public int ItemPadding { get; private set; }
		public Gtk.Align ItemsAlignment { get; private set; }
		public int LaunchBounceHeight { get; private set; }
		public int LineWidth { get; private set; }
		public int MaxItemCount { get; private set; }
		public int Offset { get; private set; }
		public Gtk.PositionType Position { get; private set; }
		public int TopPadding { get; private set; }
		public int UrgentBounceHeight { get; private set; }
		public int ZoomIconSize { get; private set; }
		public Plank.DockController controller { private get; construct; }
		public bool screen_is_composited { get; private set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public abstract class Preferences : GLib.Object {
		public Preferences ();
		public void apply ();
		public void delay ();
		public void @delete ();
		public unowned GLib.File? get_backing_file ();
		public string get_filename ();
		protected void init_from_file (GLib.File file);
		protected void init_from_filename (string filename);
		protected abstract void reset_properties ();
		protected virtual void verify (string prop);
		public Preferences.with_file (GLib.File file);
		public Preferences.with_filename (string filename);
		public signal void deleted ();
	}
	[CCode (cheader_filename = "plank.h")]
	[GtkTemplate (ui = "/net/launchpad/plank/ui/preferences.ui")]
	public class PreferencesWindow : Gtk.Window {
		public PreferencesWindow (Plank.DockController controller);
		public override bool key_press_event (Gdk.EventKey event);
		public Plank.DockController controller { get; set construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public abstract class Renderer : GLib.Object {
		public Renderer (Gtk.Widget widget);
		public void animated_draw ();
		protected abstract bool animation_needed (int64 frame_time);
		public abstract void draw (Cairo.Context cr, int64 frame_time);
		protected void force_frame_time_update ();
		protected abstract void initialize_frame (int64 frame_time);
		[CCode (notify = false)]
		public int64 frame_time { get; private set; }
		public Gtk.Widget widget { get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public abstract class Settings : GLib.Object {
		public Settings (string schema);
		public void apply ();
		public void delay ();
		protected void reset_all ();
		protected virtual void verify (string name);
		public Settings.with_path (string schema, string path);
		[CCode (notify = false)]
		public GLib.SettingsBindFlags bind_flags { get; construct; }
		[CCode (notify = false)]
		public GLib.Settings settings { get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class Surface : GLib.Object {
		public Surface (int width, int height);
		public Plank.Color average_color ();
		public void clear ();
		public Plank.Surface copy ();
		public Plank.Surface create_mask (double threshold, out Gdk.Rectangle extent);
		public void exponential_blur (int radius);
		public void fast_blur (int radius, int process_count = 1);
		public void gaussian_blur (int radius);
		public Plank.Surface scaled_copy (int width, int height);
		public Gdk.Pixbuf to_pixbuf ();
		public Surface.with_cairo_surface (int width, int height, Cairo.Surface model);
		public Surface.with_internal (Cairo.ImageSurface image);
		public Surface.with_surface (int width, int height, Plank.Surface model);
		public Cairo.Context Context { get; construct; }
		public int Height { get; construct; }
		public Cairo.Surface Internal { get; construct; }
		public int Width { get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class SurfaceCache<G> : GLib.Object {
		public SurfaceCache (Plank.SurfaceCacheFlags flags = SurfaceCacheFlags.NONE);
		public void clear ();
		public Plank.Surface? get_surface<G> (int width, int height, Plank.Surface model, Plank.DrawFunc<G> draw_func, Plank.DrawDataFunc<G>? draw_data_func);
		public Plank.SurfaceCacheFlags flags { get; set construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class System : GLib.Object {
		public System (GLib.AppLaunchContext context);
		public static unowned Plank.System get_default ();
		public void launch (GLib.File app);
		public void launch_with_files (GLib.File? app, GLib.File[] files);
		public void open (GLib.File file);
		public void open_files (GLib.File[] files);
		public void open_uri (string uri);
		public GLib.AppLaunchContext context { get; construct; }
	}
	[CCode (cheader_filename = "plank.h")]
	public abstract class Theme : Plank.Preferences {
		public const string DEFAULT_NAME;
		public const string GTK_THEME_NAME;
		public Theme ();
		public static Gtk.StyleContext create_style_context (GLib.Type widget_type, Gtk.StyleContext? parent_style, Gtk.CssProvider provider, string? object_name, string first_class, ...);
		public void draw_background (Plank.Surface surface);
		protected void draw_inner_rect (Cairo.Context cr, int width, int height);
		public static void draw_rounded_line (Cairo.Context cr, double x, double y, double width, double height, bool is_round_left, bool is_round_right, Cairo.Pattern? stroke = null, Cairo.Pattern? fill = null);
		public static void draw_rounded_rect (Cairo.Context cr, double x, double y, double width, double height, double top_radius = 6.0, double bottom_radius = 6.0, double line_width = 1.0);
		public int get_bottom_offset ();
		public unowned Gtk.StyleContext get_style_context ();
		public static GLib.File? get_theme_folder (string name);
		public static string[] get_theme_list ();
		public int get_top_offset ();
		public void load (string type);
		protected override void reset_properties ();
		protected override void verify (string prop);
		public Theme.with_name (string name);
		[Description (blurb = "The roundness of the bottom corners.", nick = "bottom-roundness")]
		public int BottomRoundness { get; set; }
		[Description (blurb = "The ending color (RGBA) of the fill gradient.", nick = "fill-end-color")]
		public Plank.Color FillEndColor { get; set; }
		[Description (blurb = "The starting color (RGBA) of the fill gradient.", nick = "fill-start-color")]
		public Plank.Color FillStartColor { get; set; }
		[Description (blurb = "The color (RGBA) of the inner stroke.", nick = "inner-stroke-color")]
		public Plank.Color InnerStrokeColor { get; set; }
		[Description (blurb = "The thickness (in pixels) of lines drawn.", nick = "line-width")]
		public int LineWidth { get; set; }
		[Description (blurb = "The color (RGBA) of the outer stroke.", nick = "outer-stroke-color")]
		public Plank.Color OuterStrokeColor { get; set; }
		[Description (blurb = "The roundness of the top corners.", nick = "top-roundness")]
		public int TopRoundness { get; set; }
	}
	[CCode (cheader_filename = "plank.h")]
	public class TitledSeparatorMenuItem : Gtk.SeparatorMenuItem {
		public TitledSeparatorMenuItem (string text);
		protected override bool draw (Cairo.Context cr);
		public TitledSeparatorMenuItem.no_line (string text);
	}
	[CCode (cheader_filename = "plank.h")]
	public class TransientDockItem : Plank.ApplicationDockItem {
		public TransientDockItem ();
		public override bool can_be_removed ();
		public override bool is_valid ();
		public TransientDockItem.with_launcher (string launcher_uri);
	}
	[CCode (cheader_filename = "plank.h")]
	public class Unity : GLib.Object {
		public void add_client (Plank.UnityClient client);
		public static unowned Plank.Unity get_default ();
		public void remove_client (Plank.UnityClient client);
	}
	[CCode (cheader_filename = "plank.h")]
	public class Worker : GLib.Object {
		public void add_task (owned GLib.ThreadFunc<weak void*> func, Plank.TaskPriority priority = TaskPriority.DEFAULT);
		public async G add_task_with_result<G> (owned Plank.TaskFunc<G> func, Plank.TaskPriority priority = TaskPriority.DEFAULT) throws GLib.Error;
		public static unowned Plank.Worker get_default ();
	}
	[CCode (cheader_filename = "plank.h")]
	public interface Docklet : GLib.Object {
		public abstract unowned string get_description ();
		public abstract unowned string get_icon ();
		public abstract unowned string get_id ();
		public abstract unowned string get_name ();
		public abstract bool is_supported ();
		public abstract Plank.DockElement make_element (string launcher, GLib.File file);
	}
	[CCode (cheader_filename = "plank.h")]
	public interface Serializable : GLib.Object {
		public abstract void deserialize (string s);
		public abstract string serialize ();
	}
	[CCode (cheader_filename = "plank.h")]
	public interface UnityClient : GLib.Object {
		public abstract void remove_launcher_entry (string sender_name);
		public abstract void update_launcher_entry (string sender_name, GLib.Variant parameters, bool is_retry = false);
	}
	[CCode (cheader_filename = "plank.h")]
	public struct Color : Gdk.RGBA {
		public void add_hue (double val);
		public void brighten_val (double amount);
		public void darken_by_sat (double amount);
		public void darken_val (double amount);
		public static Plank.Color from_hsl (double h, double s, double l);
		public static Plank.Color from_hsv (double h, double s, double v);
		public static Plank.Color from_prefs_string (string s);
		public void get_hsl (out double h, out double s, out double l);
		public void get_hsv (out double h, out double s, out double v);
		public double get_hue ();
		public double get_sat ();
		public double get_val ();
		public void multiply_sat (double amount);
		public void set_hsl (double h, double s, double v);
		public void set_hsv (double h, double s, double v);
		public void set_hue (double hue);
		public void set_max_sat (double sat);
		public void set_max_val (double val);
		public void set_min_sat (double sat);
		public void set_min_val (double val);
		public void set_sat (double sat);
		public void set_val (double val);
		public string to_prefs_string ();
	}
	[CCode (cheader_filename = "plank.h")]
	public struct PointD {
		public double x;
		public double y;
	}
	[CCode (cheader_filename = "plank.h")]
	public enum AnimationMode {
		CUSTOM,
		LINEAR,
		EASE_IN_QUAD,
		EASE_OUT_QUAD,
		EASE_IN_OUT_QUAD,
		EASE_IN_CUBIC,
		EASE_OUT_CUBIC,
		EASE_IN_OUT_CUBIC,
		EASE_IN_QUART,
		EASE_OUT_QUART,
		EASE_IN_OUT_QUART,
		EASE_IN_QUINT,
		EASE_OUT_QUINT,
		EASE_IN_OUT_QUINT,
		EASE_IN_SINE,
		EASE_OUT_SINE,
		EASE_IN_OUT_SINE,
		EASE_IN_EXPO,
		EASE_OUT_EXPO,
		EASE_IN_OUT_EXPO,
		EASE_IN_CIRC,
		EASE_OUT_CIRC,
		EASE_IN_OUT_CIRC,
		EASE_IN_ELASTIC,
		EASE_OUT_ELASTIC,
		EASE_IN_OUT_ELASTIC,
		EASE_IN_BACK,
		EASE_OUT_BACK,
		EASE_IN_OUT_BACK,
		EASE_IN_BOUNCE,
		EASE_OUT_BOUNCE,
		EASE_IN_OUT_BOUNCE,
		LAST
	}
	[CCode (cheader_filename = "plank.h")]
	public enum AnimationType {
		NONE,
		BOUNCE,
		DARKEN,
		LIGHTEN
	}
	[CCode (cheader_filename = "plank.h")]
	public enum HideType {
		NONE,
		INTELLIGENT,
		AUTO,
		DODGE_MAXIMIZED,
		WINDOW_DODGE,
		DODGE_ACTIVE
	}
	[CCode (cheader_filename = "plank.h")]
	public enum IndicatorState {
		NONE,
		SINGLE,
		SINGLE_PLUS
	}
	[CCode (cheader_filename = "plank.h")]
	[Flags]
	public enum ItemState {
		NORMAL,
		ACTIVE,
		URGENT,
		MOVE,
		INVALID
	}
	[CCode (cheader_filename = "plank.h")]
	public enum LogLevel {
		VERBOSE,
		DEBUG,
		INFO,
		NOTIFY,
		WARN,
		CRITICAL,
		ERROR
	}
	[CCode (cheader_filename = "plank.h")]
	[Flags]
	public enum PopupButton {
		NONE,
		LEFT,
		MIDDLE,
		RIGHT;
		public static Plank.PopupButton from_event_button (Gdk.EventButton event);
	}
	[CCode (cheader_filename = "plank.h")]
	[Flags]
	public enum SurfaceCacheFlags {
		NONE,
		ALLOW_DOWNSCALE,
		ALLOW_UPSCALE,
		ALLOW_SCALE,
		ADAPTIVE_SCALE
	}
	[CCode (cheader_filename = "plank.h")]
	public enum TaskPriority {
		LOW,
		DEFAULT,
		HIGH
	}
	[CCode (cheader_filename = "plank.h")]
	public enum XdgSessionClass {
		USER,
		GREETER,
		LOCK_SCREEN,
		BACKGROUND;
		public static Plank.XdgSessionClass from_string (string s);
	}
	[CCode (cheader_filename = "plank.h")]
	[Flags]
	public enum XdgSessionDesktop {
		GNOME,
		KDE,
		LXDE,
		MATE,
		RAZOR,
		ROX,
		TDE,
		UNITY,
		XFCE,
		EDE,
		CINNAMON,
		PANTHEON,
		OLD;
		public static Plank.XdgSessionDesktop from_string (string s);
	}
	[CCode (cheader_filename = "plank.h")]
	public enum XdgSessionType {
		UNSPECIFIED,
		TTY,
		X11,
		WAYLAND,
		MIR;
		public static Plank.XdgSessionType from_string (string s);
	}
	[CCode (cheader_filename = "plank.h")]
	public delegate void DockletInitFunc (Plank.DockletManager manager);
	[CCode (cheader_filename = "plank.h")]
	public delegate Plank.Surface? DrawDataFunc<G> (int width, int height, Plank.Surface model, G data);
	[CCode (cheader_filename = "plank.h")]
	public delegate Plank.Surface? DrawFunc<G> (int width, int height, Plank.Surface model, Plank.DrawDataFunc<G>? draw_data_func);
	[CCode (cheader_filename = "plank.h")]
	public delegate void DrawValueFunc (Plank.DockItem item, Plank.DockItemDrawValue draw_value);
	[CCode (cheader_filename = "plank.h")]
	public delegate void DrawValuesFunc (Gee.HashMap<Plank.DockElement,Plank.DockItemDrawValue> draw_values);
	[CCode (cheader_filename = "plank.h")]
	public delegate G TaskFunc<G> () throws GLib.Error;
	[CCode (cheader_filename = "plank.h")]
	public const string DOCKLET_ENTRY_POINT;
	[CCode (cheader_filename = "plank.h")]
	public const string G_RESOURCE_PATH;
	[CCode (cheader_filename = "plank.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "plank.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "plank.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "plank.h")]
	public const int NANO_VERSION;
	[CCode (cheader_filename = "plank.h")]
	public static unowned string? check_version (uint required_major, uint required_minor, uint required_micro);
	[CCode (cheader_filename = "plank.h")]
	public static double easing_for_mode (Plank.AnimationMode mode, double t, double d);
	[CCode (cheader_filename = "plank.h")]
	public static void environment_initialize ();
	[CCode (cheader_filename = "plank.h")]
	public static bool environment_is_session_class (Plank.XdgSessionClass type);
	[CCode (cheader_filename = "plank.h")]
	public static bool environment_is_session_desktop (Plank.XdgSessionDesktop type);
	[CCode (cheader_filename = "plank.h")]
	public static bool environment_is_session_type (Plank.XdgSessionType type);
	[CCode (cheader_filename = "plank.h")]
	public static uint get_major_version ();
	[CCode (cheader_filename = "plank.h")]
	public static uint get_micro_version ();
	[CCode (cheader_filename = "plank.h")]
	public static uint get_minor_version ();
	[CCode (cheader_filename = "plank.h")]
	public static uint get_nano_version ();
}
