/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.List;
import javax.swing.JSeparator;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.ReportUnitPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportMilitaryPanel
extends ReportUnitPanel {
    public ReportMilitaryPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportMilitaryAction", true);
    }

    private boolean reportable(UnitType unitType) {
        return !unitType.isNaval() && unitType.isAvailableTo(this.getMyPlayer()) && (unitType.hasAbility("model.ability.expertSoldier") || unitType.isOffensive());
    }

    private boolean reportable(Unit unit) {
        return !unit.isNaval() && (unit.hasAbility("model.ability.expertSoldier") || unit.isOffensiveUnit());
    }

    private void tryUnitRole(UnitType unitType, String roleId) {
        int count = this.getCount(roleId, unitType);
        if (count > 0) {
            AbstractUnit au = new AbstractUnit(unitType, roleId, count);
            this.reportPanel.add((Component)this.createUnitTypeLabel(au), "sg");
        }
    }

    @Override
    protected void gatherData() {
        for (Unit unit : this.getMyPlayer().getUnits()) {
            if (!this.reportable(unit)) continue;
            this.addUnit(unit, unit.getRole().getId());
        }
    }

    @Override
    protected void addREFUnits() {
        Specification spec = this.getSpecification();
        Nation refNation = this.getMyPlayer().getNation().getREFNation();
        this.reportPanel.add((Component)Utility.localizedLabel(refNation), "span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        List<AbstractUnit> refUnits = this.igc().getREFUnits();
        if (refUnits != null) {
            for (AbstractUnit au : refUnits) {
                if (au.getType(spec).isNaval()) continue;
                this.reportPanel.add((Component)this.createUnitTypeLabel(au), "sg");
            }
        }
    }

    @Override
    protected void addOwnUnits() {
        Specification spec = this.getSpecification();
        Player player = this.getMyPlayer();
        UnitType defaultType = spec.getDefaultUnitType(player);
        this.reportPanel.add((Component)Utility.localizedLabel(player.getForcesLabel()), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        List<Role> militaryRoles = this.getSpecification().getMilitaryRoles();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (this.reportable(unitType)) {
                this.tryUnitRole(unitType, "model.role.default");
            }
            for (Role r : militaryRoles) {
                this.tryUnitRole(unitType, r.getId());
            }
        }
    }
}

