/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.ByteIo;
import org.mozilla.javascript.typedarrays.Conversions;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeTypedArrayView;

public class NativeUint16Array
extends NativeTypedArrayView<Integer> {
    private static final long serialVersionUID = 7700018949434240321L;
    private static final String CLASS_NAME = "Uint16Array";
    private static final int BYTES_PER_ELEMENT = 2;

    public NativeUint16Array() {
    }

    public NativeUint16Array(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        super(nativeArrayBuffer, n, n2, n2 * 2);
    }

    public NativeUint16Array(int n) {
        this(new NativeArrayBuffer(n * 2), 0, n);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeUint16Array nativeUint16Array = new NativeUint16Array();
        nativeUint16Array.exportAsJSClass(4, scriptable, bl);
    }

    @Override
    protected NativeTypedArrayView construct(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        return new NativeUint16Array(nativeArrayBuffer, n, n2);
    }

    @Override
    public int getBytesPerElement() {
        return 2;
    }

    @Override
    protected NativeTypedArrayView realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof NativeUint16Array)) {
            throw NativeUint16Array.incompatibleCallError(idFunctionObject);
        }
        return (NativeUint16Array)scriptable;
    }

    @Override
    protected Object js_get(int n) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        return ByteIo.readUint16(this.arrayBuffer.buffer, n * 2 + this.offset, false);
    }

    @Override
    protected Object js_set(int n, Object object) {
        if (this.checkIndex(n)) {
            return Undefined.instance;
        }
        int n2 = Conversions.toUint16(object);
        ByteIo.writeUint16(this.arrayBuffer.buffer, n * 2 + this.offset, n2, false);
        return null;
    }

    @Override
    public Integer get(int n) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Integer)this.js_get(n);
    }

    @Override
    public Integer set(int n, Integer n2) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return (Integer)this.js_set(n, n2);
    }
}

