/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.AntFileTreeBuilder;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Cast;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileTree
extends AbstractFileCollection
implements FileTreeInternal {
    @Override
    public Set<File> getFiles() {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                files.add(fileDetails.getFile());
            }
        });
        return files;
    }

    @Override
    public boolean isEmpty() {
        final AtomicBoolean found = new AtomicBoolean();
        this.visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                found.set(true);
                fileDetails.stopVisiting();
            }
        });
        return !found.get();
    }

    @Override
    public FileTree matching(Closure filterConfigClosure) {
        PatternSet patternSet = new PatternSet();
        ConfigureUtil.configure(filterConfigClosure, patternSet);
        return this.matching(patternSet);
    }

    @Override
    public FileTree matching(PatternFilterable patterns) {
        PatternSet patternSet = (PatternSet)patterns;
        return new FilteredFileTreeImpl(this, patternSet.getAsSpec());
    }

    public Map<String, File> getAsMap() {
        final LinkedHashMap<String, File> map = new LinkedHashMap<String, File>();
        this.visit(new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                map.put(fileDetails.getRelativePath().getPathString(), fileDetails.getFile());
            }
        });
        return map;
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileTreeBuilder(this.getAsMap()).addToAntBuilder(builder, nodeName);
    }

    protected boolean visitAll() {
        final AtomicBoolean hasContent = new AtomicBoolean();
        this.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
                dirDetails.getFile();
                hasContent.set(true);
            }

            public void visitFile(FileVisitDetails fileDetails) {
                fileDetails.getFile();
                hasContent.set(true);
            }
        });
        return hasContent.get();
    }

    @Override
    public FileTree getAsFileTree() {
        return this;
    }

    @Override
    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this, (FileTreeInternal)Cast.cast(FileTreeInternal.class, (Object)fileTree));
    }

    @Override
    public FileTree visit(Closure closure) {
        return this.visit((FileVisitor)DefaultGroovyMethods.asType((Closure)closure, FileVisitor.class));
    }

    @Override
    public void visitTreeOrBackingFile(FileVisitor visitor) {
        this.visit(visitor);
    }

    @Override
    public void visitRootElements(FileCollectionVisitor visitor) {
        visitor.visitTree(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredFileTreeImpl
    extends AbstractFileTree {
        private final AbstractFileTree fileTree;
        private final Spec<FileTreeElement> spec;

        public FilteredFileTreeImpl(AbstractFileTree fileTree, Spec<FileTreeElement> spec) {
            this.fileTree = fileTree;
            this.spec = spec;
        }

        @Override
        public String getDisplayName() {
            return this.fileTree.getDisplayName();
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return this.fileTree.getBuildDependencies();
        }

        @Override
        public FileTree visit(final FileVisitor visitor) {
            this.fileTree.visit(new FileVisitor(){

                public void visitDir(FileVisitDetails dirDetails) {
                    if (FilteredFileTreeImpl.this.spec.isSatisfiedBy((Object)dirDetails)) {
                        visitor.visitDir(dirDetails);
                    }
                }

                public void visitFile(FileVisitDetails fileDetails) {
                    if (FilteredFileTreeImpl.this.spec.isSatisfiedBy((Object)fileDetails)) {
                        visitor.visitFile(fileDetails);
                    }
                }
            });
            return this;
        }

        @Override
        public void registerWatchPoints(FileSystemSubset.Builder builder) {
            this.fileTree.registerWatchPoints(builder);
        }

        @Override
        public void visitTreeOrBackingFile(FileVisitor visitor) {
            this.fileTree.visitTreeOrBackingFile(visitor);
        }
    }
}

