/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;

public class LockOptionsBuilder
implements LockOptions {
    private FileLockManager.LockMode mode;
    private boolean crossVersion;

    private LockOptionsBuilder(FileLockManager.LockMode mode, boolean crossVersion) {
        this.mode = mode;
        this.crossVersion = crossVersion;
    }

    public static LockOptionsBuilder mode(FileLockManager.LockMode lockMode) {
        return new LockOptionsBuilder(lockMode, false);
    }

    public LockOptionsBuilder useCrossVersionImplementation() {
        this.crossVersion = true;
        return this;
    }

    public FileLockManager.LockMode getMode() {
        return this.mode;
    }

    public boolean isUseCrossVersionImplementation() {
        return this.crossVersion;
    }

    public LockOptions withMode(FileLockManager.LockMode mode) {
        return new LockOptionsBuilder(mode, this.crossVersion);
    }

    public String toString() {
        return (Object)((Object)this.mode) + " (simple=" + this.crossVersion + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LockOptionsBuilder)) {
            return false;
        }
        LockOptionsBuilder that = (LockOptionsBuilder)o;
        if (this.crossVersion != that.crossVersion) {
            return false;
        }
        return this.mode == that.mode;
    }

    public int hashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + (this.crossVersion ? 1 : 0);
        return result;
    }
}

