/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.registry;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValue;

public class Registry {
    private static Reference<ResourceBundle> ourBundle;
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final Map<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private static final Registry ourInstance;

    @NotNull
    public static RegistryValue get(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry", "get"));
        }
        Registry registry = Registry.getInstance();
        RegistryValue value = registry.myValues.get(key);
        if (value == null) {
            value = new RegistryValue(registry, key);
            registry.myValues.put(key, value);
        }
        RegistryValue registryValue = value;
        if (registryValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry", "get"));
        }
        return registryValue;
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry", "is"));
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, boolean defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry", "is"));
        }
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry", "intValue"));
        }
        return Registry.get(key).asInteger();
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("misc.registry");
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry", "getBundle"));
        }
        return resourceBundle;
    }

    public static Registry getInstance() {
        return ourInstance;
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map2 = this.myUserProperties;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry", "getUserProperties"));
        }
        return map2;
    }

    static {
        ourInstance = new Registry();
    }
}

