/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyVariantReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSet;

public class PsiMultiReference
implements PsiPolyVariantReference {
    public static final Comparator<PsiReference> COMPARATOR = new Comparator<PsiReference>(){

        @Override
        public int compare(PsiReference ref1, PsiReference ref2) {
            TextRange range2;
            if (ref1.isSoft() && !ref2.isSoft()) {
                return 1;
            }
            if (!ref1.isSoft() && ref2.isSoft()) {
                return -1;
            }
            boolean resolves1 = PsiMultiReference.resolves(ref1);
            boolean resolves2 = PsiMultiReference.resolves(ref2);
            if (resolves1 && !resolves2) {
                return -1;
            }
            if (!resolves1 && resolves2) {
                return 1;
            }
            TextRange range1 = ref1.getRangeInElement();
            if (TextRange.areSegmentsEqual(range1, range2 = ref2.getRangeInElement())) {
                return 0;
            }
            if (range1.getStartOffset() >= range2.getStartOffset() && range1.getEndOffset() <= range2.getEndOffset()) {
                return -1;
            }
            if (range2.getStartOffset() >= range1.getStartOffset() && range2.getEndOffset() <= range1.getEndOffset()) {
                return 1;
            }
            return 0;
        }
    };
    private final PsiReference[] myReferences;
    private final PsiElement myElement;
    private boolean mySorted;

    private static boolean resolves(PsiReference ref1) {
        return ref1 instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)ref1).multiResolve(false).length > 0 || ref1.resolve() != null;
    }

    public PsiMultiReference(@NotNull PsiReference[] references, PsiElement element) {
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "<init>"));
        }
        assert (references.length > 0);
        this.myReferences = references;
        this.myElement = element;
    }

    public PsiReference[] getReferences() {
        return this.myReferences;
    }

    private synchronized PsiReference chooseReference() {
        if (!this.mySorted) {
            Arrays.sort(this.myReferences, COMPARATOR);
            this.mySorted = true;
        }
        return this.myReferences[0];
    }

    @Override
    public PsiElement getElement() {
        return this.myElement;
    }

    @Override
    public TextRange getRangeInElement() {
        TextRange range = this.getRangeInElementIfSameForAll();
        if (range != null) {
            return range;
        }
        PsiReference chosenRef = this.chooseReference();
        return this.getReferenceRange(chosenRef);
    }

    @Nullable
    private TextRange getRangeInElementIfSameForAll() {
        TextRange range = null;
        for (PsiReference reference : this.getReferences()) {
            TextRange refRange = this.getReferenceRange(reference);
            if (range == null) {
                range = refRange;
                continue;
            }
            if (range.equals(refRange)) continue;
            return null;
        }
        return range;
    }

    private TextRange getReferenceRange(PsiReference reference) {
        TextRange rangeInElement = reference.getRangeInElement();
        PsiElement element = reference.getElement();
        while (element != this.myElement) {
            rangeInElement = rangeInElement.shiftRight(element.getStartOffsetInParent());
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return rangeInElement;
    }

    @Override
    public PsiElement resolve() {
        PsiReference reference = this.chooseReference();
        if (this.cannotChoose()) {
            ResolveResult[] results = this.multiResolve(false);
            return results.length == 1 ? results[0].getElement() : null;
        }
        return reference.resolve();
    }

    private boolean cannotChoose() {
        return this.myReferences.length > 1 && COMPARATOR.compare(this.myReferences[0], this.myReferences[1]) == 0;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.chooseReference().getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.chooseReference().handleElementRename(newElementName);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "bindToElement"));
        }
        return this.chooseReference().bindToElement(element);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        for (PsiReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        for (PsiReference ref : this.myReferences) {
            Object[] refVariants = ref.getVariants();
            ContainerUtil.addAll(variants, refVariants);
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "getVariants"));
        }
        return objectArray;
    }

    @Override
    public boolean isSoft() {
        for (PsiReference reference : this.getReferences()) {
            if (reference.isSoft()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiReference[] refs = this.getReferences();
        LinkedHashSet<PsiElementResolveResult> result2 = new LinkedHashSet<PsiElementResolveResult>(refs.length);
        PsiElementResolveResult selfReference = null;
        for (PsiReference reference : refs) {
            if (reference instanceof PsiPolyVariantReference) {
                ContainerUtil.addAll(result2, ((PsiPolyVariantReference)reference).multiResolve(incompleteCode));
                continue;
            }
            PsiElement resolved = reference.resolve();
            if (resolved == null) continue;
            PsiElementResolveResult rresult = new PsiElementResolveResult(resolved);
            if (this.getElement() == resolved) {
                selfReference = rresult;
                continue;
            }
            result2.add(rresult);
        }
        if (result2.isEmpty() && selfReference != null) {
            result2.add(selfReference);
        }
        ResolveResult[] resolveResultArray = result2.toArray(new ResolveResult[result2.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public String toString() {
        return "PsiMultiReference{myReferences=" + Arrays.toString(this.myReferences) + '}';
    }
}

