/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope.processor;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class MethodResolverProcessor
extends MethodCandidatesProcessor {
    private boolean myStopAcceptingCandidates;

    public MethodResolverProcessor(@NotNull PsiMethodCallExpression place, @NotNull PsiFile placeFile) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        this(place, place.getArgumentList(), placeFile);
    }

    public MethodResolverProcessor(@NotNull PsiCallExpression place, @NotNull PsiExpressionList argumentList2, @NotNull PsiFile placeFile) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        if (argumentList2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        this((PsiElement)place, placeFile, new PsiConflictResolver[]{new JavaMethodsConflictResolver(argumentList2, PsiUtil.getLanguageLevel(placeFile))});
        this.setArgumentList(argumentList2);
        this.obtainTypeArguments(place);
    }

    public MethodResolverProcessor(PsiClass classConstr, @NotNull PsiExpressionList argumentList2, @NotNull PsiElement place, @NotNull PsiFile placeFile) {
        if (argumentList2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        super(place, placeFile, new PsiConflictResolver[]{new JavaMethodsConflictResolver(argumentList2, PsiUtil.getLanguageLevel(placeFile))}, new SmartList<CandidateInfo>());
        this.myStopAcceptingCandidates = false;
        this.setIsConstructor(true);
        this.setAccessClass(classConstr);
        this.setArgumentList(argumentList2);
    }

    public MethodResolverProcessor(@NotNull PsiElement place, @NotNull PsiFile placeFile, @NotNull PsiConflictResolver[] resolvers) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        if (resolvers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvers", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "<init>"));
        }
        super(place, placeFile, resolvers, new SmartList<CandidateInfo>());
        this.myStopAcceptingCandidates = false;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "handleEvent"));
        }
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL && this.myHasAccessibleStaticCorrectCandidate) {
            this.myStopAcceptingCandidates = true;
        }
        super.handleEvent(event, associated);
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "execute"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/scope/processor/MethodResolverProcessor", "execute"));
        }
        return !this.myStopAcceptingCandidates && super.execute(element, state2);
    }

    @Override
    protected boolean acceptVarargs() {
        return true;
    }
}

