/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.health.DaemonMemoryStatus;

public class GcThrashingDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private final DaemonMemoryStatus status;
    private static final Logger LOG = Logging.getLogger(GcThrashingDaemonExpirationStrategy.class);
    public static final String EXPIRATION_REASON = "JVM garbage collector thrashing";

    public GcThrashingDaemonExpirationStrategy(DaemonMemoryStatus status) {
        this.status = status;
    }

    public DaemonExpirationResult checkExpiration() {
        if (this.status.isThrashing()) {
            LOG.info("JVM garbage collector is thrashing. Daemon will be stopped immediately");
            return new DaemonExpirationResult(DaemonExpirationStatus.IMMEDIATE_EXPIRE, EXPIRATION_REASON);
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }
}

