/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.memory.behavior.IMemoryCache;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMemoryCache<K, V>
implements IMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(AbstractMemoryCache.class);
    private ICompositeCacheAttributes cacheAttributes;
    private CompositeCache<K, V> cache;
    protected int chunkSize;
    protected final Lock lock = new ReentrantLock();
    protected Map<K, MemoryElementDescriptor<K, V>> map;
    protected AtomicLong hitCnt;
    protected AtomicLong missCnt;
    protected AtomicLong putCnt;

    @Override
    public void initialize(CompositeCache<K, V> compositeCache) {
        this.hitCnt = new AtomicLong(0L);
        this.missCnt = new AtomicLong(0L);
        this.putCnt = new AtomicLong(0L);
        this.cacheAttributes = compositeCache.getCacheAttributes();
        this.chunkSize = this.cacheAttributes.getSpoolChunkSize();
        this.cache = compositeCache;
        this.map = this.createMap();
    }

    public abstract Map<K, MemoryElementDescriptor<K, V>> createMap();

    @Override
    public abstract boolean remove(K var1) throws IOException;

    @Override
    public abstract ICacheElement<K, V> get(K var1) throws IOException;

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(Set<K> set) throws IOException {
        HashMap<K, ICacheElement<K, V>> hashMap = new HashMap<K, ICacheElement<K, V>>();
        if (set != null && !set.isEmpty()) {
            for (K k : set) {
                ICacheElement<K, V> iCacheElement = this.get(k);
                if (iCacheElement == null) continue;
                hashMap.put(k, iCacheElement);
            }
        }
        return hashMap;
    }

    @Override
    public ICacheElement<K, V> getQuiet(K k) throws IOException {
        ICacheElement<K, V> iCacheElement = null;
        MemoryElementDescriptor<K, V> memoryElementDescriptor = this.map.get(k);
        if (memoryElementDescriptor != null) {
            if (log.isDebugEnabled()) {
                log.debug(this.getCacheName() + ": MemoryCache quiet hit for " + k);
            }
            iCacheElement = memoryElementDescriptor.getCacheElement();
        } else if (log.isDebugEnabled()) {
            log.debug(this.getCacheName() + ": MemoryCache quiet miss for " + k);
        }
        return iCacheElement;
    }

    @Override
    public abstract void update(ICacheElement<K, V> var1) throws IOException;

    @Override
    public abstract Set<K> getKeySet();

    @Override
    public void removeAll() throws IOException {
        this.map.clear();
    }

    @Override
    public void dispose() throws IOException {
        this.removeAll();
        this.hitCnt.set(0L);
        this.missCnt.set(0L);
        this.putCnt.set(0L);
        log.info("Memory Cache dispose called.");
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Memory Cache");
        ArrayList arrayList = new ArrayList();
        stats.setStatElements(arrayList);
        arrayList.add(new StatElement<AtomicLong>("Put Count", this.putCnt));
        arrayList.add(new StatElement<AtomicLong>("Hit Count", this.hitCnt));
        arrayList.add(new StatElement<AtomicLong>("Miss Count", this.missCnt));
        arrayList.add(new StatElement<Integer>("Map Size", this.getSize()));
        return stats;
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    public String getCacheName() {
        String string = this.cacheAttributes.getCacheName();
        if (string != null) {
            return string;
        }
        return this.cache.getCacheName();
    }

    @Override
    public void waterfal(ICacheElement<K, V> iCacheElement) {
        this.cache.spoolToDisk(iCacheElement);
    }

    public void dumpMap() {
        log.debug("dumpingMap");
        for (Map.Entry<K, MemoryElementDescriptor<K, V>> entry : this.map.entrySet()) {
            MemoryElementDescriptor<K, V> memoryElementDescriptor = entry.getValue();
            log.debug("dumpMap> key=" + entry.getKey() + ", val=" + memoryElementDescriptor.getCacheElement().getVal());
        }
    }

    @Override
    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheAttributes;
    }

    @Override
    public void setCacheAttributes(ICompositeCacheAttributes iCompositeCacheAttributes) {
        this.cacheAttributes = iCompositeCacheAttributes;
    }

    @Override
    public CompositeCache<K, V> getCompositeCache() {
        return this.cache;
    }
}

