/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.changeset.query.RestrictionPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.I18n;

public class OpenAndCloseStateRestrictionPanel
extends JPanel
implements RestrictionPanel {
    private static final String PREF_ROOT = "changeset-query.advanced.open-restrictions";
    private static final String PREF_QUERY_TYPE = "changeset-query.advanced.open-restrictions.query-type";
    private final JRadioButton rbOpenOnly = new JRadioButton();
    private final JRadioButton rbClosedOnly = new JRadioButton();
    private final JRadioButton rbBoth = new JRadioButton();

    public OpenAndCloseStateRestrictionPanel() {
        this.build();
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rbOpenOnly, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Query open changesets only", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rbClosedOnly, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Query closed changesets only", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rbBoth, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Query both open and closed changesets", new Object[0])), gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbBoth);
        buttonGroup.add(this.rbClosedOnly);
        buttonGroup.add(this.rbOpenOnly);
    }

    public void startUserInput() {
        this.restoreFromSettings();
    }

    @Override
    public void fillInQuery(ChangesetQuery changesetQuery) {
        if (this.rbBoth.isSelected()) {
            changesetQuery.beingClosed(true);
            changesetQuery.beingOpen(true);
        } else if (this.rbOpenOnly.isSelected()) {
            changesetQuery.beingOpen(true);
        } else if (this.rbClosedOnly.isSelected()) {
            changesetQuery.beingClosed(true);
        }
    }

    public void rememberSettings() {
        if (this.rbBoth.isSelected()) {
            Main.pref.put(PREF_QUERY_TYPE, "both");
        } else if (this.rbOpenOnly.isSelected()) {
            Main.pref.put(PREF_QUERY_TYPE, "open");
        } else if (this.rbClosedOnly.isSelected()) {
            Main.pref.put(PREF_QUERY_TYPE, "closed");
        }
    }

    public void restoreFromSettings() {
        String string = Main.pref.get(PREF_QUERY_TYPE, "open");
        this.rbBoth.setSelected("both".equals(string));
        this.rbOpenOnly.setSelected("open".equals(string));
        this.rbClosedOnly.setSelected("closed".equals(string));
    }

    @Override
    public boolean isValidChangesetQuery() {
        return true;
    }

    @Override
    public void displayMessageIfInvalid() {
    }
}

