/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class TileSourceDisplaySettings {
    public static final String AUTO_LOAD = "automatic-downloading";
    public static final String AUTO_ZOOM = "automatically-change-resolution";
    private static final String SHOW_ERRORS = "show-errors";
    private static final String DISPLACEMENT = "displacement";
    private static final String PREFERENCE_PREFIX = "imagery.generic";
    public static final BooleanProperty PROP_AUTO_LOAD = new BooleanProperty("imagery.generic.default_autoload", true);
    public static final BooleanProperty PROP_AUTO_ZOOM = new BooleanProperty("imagery.generic.default_autozoom", true);
    private boolean autoZoom;
    private boolean autoLoad;
    private boolean showErrors;
    private EastNorth displacement = new EastNorth(0.0, 0.0);
    private final CopyOnWriteArrayList<DisplaySettingsChangeListener> listeners = new CopyOnWriteArrayList();

    public TileSourceDisplaySettings() {
        this(new String[]{PREFERENCE_PREFIX});
    }

    public TileSourceDisplaySettings(String string) {
        this(PREFERENCE_PREFIX, string);
    }

    private TileSourceDisplaySettings(String ... stringArray) {
        this.autoZoom = TileSourceDisplaySettings.getProperty(stringArray, "default_autozoom");
        this.autoLoad = TileSourceDisplaySettings.getProperty(stringArray, "default_autoload");
        this.showErrors = TileSourceDisplaySettings.getProperty(stringArray, "default_showerrors");
    }

    private static boolean getProperty(String[] stringArray, String string) {
        boolean bl = true;
        for (String string2 : stringArray) {
            String string3 = string2 + "." + string;
            boolean bl2 = Main.pref.getBoolean(string3, true);
            if (Main.pref.get(string3).isEmpty()) continue;
            bl = bl2;
        }
        return bl;
    }

    public boolean isAutoZoom() {
        return this.autoZoom;
    }

    public void setAutoZoom(boolean bl) {
        this.autoZoom = bl;
        this.fireSettingsChange(AUTO_ZOOM);
    }

    public boolean isAutoLoad() {
        return this.autoLoad;
    }

    public void setAutoLoad(boolean bl) {
        this.autoLoad = bl;
        this.fireSettingsChange(AUTO_LOAD);
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean bl) {
        this.showErrors = bl;
        this.fireSettingsChange(SHOW_ERRORS);
    }

    public double getDx() {
        return this.displacement.east();
    }

    public double getDy() {
        return this.displacement.north();
    }

    public EastNorth getDisplacement() {
        return this.displacement;
    }

    public void setDisplacement(EastNorth eastNorth) {
        CheckParameterUtil.ensureValidCoordinates(eastNorth, DISPLACEMENT);
        this.displacement = eastNorth;
        this.fireSettingsChange(DISPLACEMENT);
    }

    public void addDisplacement(EastNorth eastNorth) {
        CheckParameterUtil.ensureValidCoordinates(eastNorth, DISPLACEMENT);
        this.setDisplacement(this.displacement.add(eastNorth));
    }

    private void fireSettingsChange(String string) {
        DisplaySettingsChangeEvent displaySettingsChangeEvent = new DisplaySettingsChangeEvent(string);
        for (DisplaySettingsChangeListener displaySettingsChangeListener : this.listeners) {
            displaySettingsChangeListener.displaySettingsChanged(displaySettingsChangeEvent);
        }
    }

    public void addSettingsChangeListener(DisplaySettingsChangeListener displaySettingsChangeListener) {
        this.listeners.add(displaySettingsChangeListener);
    }

    public void removeSettingsChangeListener(DisplaySettingsChangeListener displaySettingsChangeListener) {
        this.listeners.remove(displaySettingsChangeListener);
    }

    public void storeTo(Map<String, String> map) {
        map.put(AUTO_LOAD, Boolean.toString(this.autoLoad));
        map.put(AUTO_ZOOM, Boolean.toString(this.autoZoom));
        map.put(SHOW_ERRORS, Boolean.toString(this.showErrors));
        map.put("dx", String.valueOf(this.getDx()));
        map.put("dy", String.valueOf(this.getDy()));
    }

    public void loadFrom(Map<String, String> map) {
        try {
            String string;
            String string2;
            String string3 = map.get(AUTO_LOAD);
            if (string3 != null) {
                this.setAutoLoad(Boolean.parseBoolean(string3));
            }
            if ((string2 = map.get(AUTO_ZOOM)) != null) {
                this.setAutoZoom(Boolean.parseBoolean(string2));
            }
            if ((string = map.get(SHOW_ERRORS)) != null) {
                this.setShowErrors(Boolean.parseBoolean(string));
            }
            String string4 = map.get("dx");
            String string5 = map.get("dy");
            if (string4 != null && string5 != null) {
                this.setDisplacement(new EastNorth(Double.parseDouble(string4), Double.parseDouble(string5)));
            }
        }
        catch (RuntimeException runtimeException) {
            throw BugReport.intercept(runtimeException).put("data", map);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.autoLoad ? 1231 : 1237);
        n = 31 * n + (this.autoZoom ? 1231 : 1237);
        n = 31 * n + (this.showErrors ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TileSourceDisplaySettings tileSourceDisplaySettings = (TileSourceDisplaySettings)object;
        if (this.autoLoad != tileSourceDisplaySettings.autoLoad) {
            return false;
        }
        if (this.autoZoom != tileSourceDisplaySettings.autoZoom) {
            return false;
        }
        return this.showErrors == tileSourceDisplaySettings.showErrors;
    }

    public String toString() {
        return "TileSourceDisplaySettings [autoZoom=" + this.autoZoom + ", autoLoad=" + this.autoLoad + ", showErrors=" + this.showErrors + ']';
    }

    public static final class DisplaySettingsChangeEvent {
        private final String changedSetting;

        DisplaySettingsChangeEvent(String string) {
            this.changedSetting = string;
        }

        public String getChangedSetting() {
            return this.changedSetting;
        }

        public String toString() {
            return "DisplaySettingsChangeEvent [changedSetting=" + this.changedSetting + ']';
        }
    }

    @FunctionalInterface
    public static interface DisplaySettingsChangeListener {
        public void displaySettingsChanged(DisplaySettingsChangeEvent var1);
    }
}

