/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class Environment {
    public OsmPrimitive osm;
    public MultiCascade mc;
    public String layer;
    public StyleSource source;
    private Condition.Context context = Condition.Context.PRIMITIVE;
    public static final String DEFAULT_LAYER = "default";
    public OsmPrimitive parent;
    public OsmPrimitive child;
    public Integer index;
    public Integer count;

    public Environment() {
    }

    public Environment(OsmPrimitive osmPrimitive) {
        this.osm = osmPrimitive;
    }

    public Environment(OsmPrimitive osmPrimitive, MultiCascade multiCascade, String string, StyleSource styleSource) {
        this.osm = osmPrimitive;
        this.mc = multiCascade;
        this.layer = string;
        this.source = styleSource;
    }

    public Environment(Environment environment) {
        CheckParameterUtil.ensureParameterNotNull(environment);
        this.osm = environment.osm;
        this.mc = environment.mc;
        this.layer = environment.layer;
        this.parent = environment.parent;
        this.child = environment.child;
        this.source = environment.source;
        this.index = environment.index;
        this.count = environment.count;
        this.context = environment.getContext();
    }

    public Environment withPrimitive(OsmPrimitive osmPrimitive) {
        Environment environment = new Environment(this);
        environment.osm = osmPrimitive;
        return environment;
    }

    public Environment withParent(OsmPrimitive osmPrimitive) {
        Environment environment = new Environment(this);
        environment.parent = osmPrimitive;
        return environment;
    }

    public Environment withParentAndIndexAndLinkContext(OsmPrimitive osmPrimitive, int n, int n2) {
        Environment environment = new Environment(this);
        environment.parent = osmPrimitive;
        environment.index = n;
        environment.count = n2;
        environment.context = Condition.Context.LINK;
        return environment;
    }

    public Environment withChild(OsmPrimitive osmPrimitive) {
        Environment environment = new Environment(this);
        environment.child = osmPrimitive;
        return environment;
    }

    public Environment withChildAndIndexAndLinkContext(OsmPrimitive osmPrimitive, int n, int n2) {
        Environment environment = new Environment(this);
        environment.child = osmPrimitive;
        environment.index = n;
        environment.count = n2;
        environment.context = Condition.Context.LINK;
        return environment;
    }

    public Environment withIndex(int n, int n2) {
        Environment environment = new Environment(this);
        environment.index = n;
        environment.count = n2;
        return environment;
    }

    public Environment withContext(Condition.Context context) {
        Environment environment = new Environment(this);
        environment.context = context == null ? Condition.Context.PRIMITIVE : context;
        return environment;
    }

    public Environment withLinkContext() {
        Environment environment = new Environment(this);
        environment.context = Condition.Context.LINK;
        return environment;
    }

    public boolean isLinkContext() {
        return Condition.Context.LINK.equals((Object)this.context);
    }

    public boolean hasParentRelation() {
        return this.parent instanceof Relation;
    }

    public Condition.Context getContext() {
        return this.context == null ? Condition.Context.PRIMITIVE : this.context;
    }

    public String getRole() {
        if (this.getContext().equals((Object)Condition.Context.PRIMITIVE)) {
            return null;
        }
        if (this.parent instanceof Relation) {
            return ((Relation)this.parent).getMember(this.index).getRole();
        }
        if (this.child != null && this.osm instanceof Relation) {
            return ((Relation)this.osm).getMember(this.index).getRole();
        }
        return null;
    }

    public void clearSelectorMatchingInformation() {
        this.parent = null;
        this.child = null;
        this.index = null;
        this.count = null;
    }

    public Cascade getCascade(String string) {
        return this.mc == null ? null : this.mc.getCascade(string == null ? this.layer : string);
    }
}

