/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.exception.ExceptionOperations;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;

@CoreClass(value="Exception")
public abstract class ExceptionNodes {

    @Primitive(name="exception_errno_error", needsSelf=false)
    public static abstract class ExceptionErrnoErrorPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject exceptionErrnoError(DynamicObject message, int errno, DynamicObject location) {
            String errorMessage = message != this.nil() ? (RubyGuards.isRubyString(location) ? " @ " + location.toString() + " - " + RopeOperations.decodeRope(StringOperations.rope(message)) : " - " + RopeOperations.decodeRope(StringOperations.rope(message))) : "";
            return this.coreExceptions().errnoError(errno, errorMessage, this);
        }
    }

    @Primitive(name="exception_set_message")
    public static abstract class MessageSetNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object setMessage(DynamicObject error, Object message) {
            Layouts.EXCEPTION.setMessage(error, message);
            return error;
        }
    }

    @Primitive(name="exception_message")
    public static abstract class MessagePrimitiveNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object message(DynamicObject exception) {
            return Layouts.EXCEPTION.getMessage(exception);
        }
    }

    @CoreMethod(names={"capture_backtrace!"}, optional=1)
    public static abstract class CaptureBacktraceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject captureBacktrace(DynamicObject exception, NotProvided offset) {
            return this.captureBacktrace(exception, 1);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject captureBacktrace(DynamicObject exception, int offset) {
            Backtrace backtrace = this.getContext().getCallStack().getBacktrace(this, offset, exception);
            Layouts.EXCEPTION.setBacktrace(exception, backtrace);
            return this.nil();
        }
    }

    @CoreMethod(names={"backtrace"})
    public static abstract class BacktraceNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ReadObjectFieldNode readCustomBacktraceNode;

        @Specialization
        public Object backtrace(DynamicObject exception, @Cached(value="createBinaryProfile()") ConditionProfile hasCustomBacktraceProfile, @Cached(value="createBinaryProfile()") ConditionProfile hasBacktraceProfile) {
            Object customBacktrace = this.getReadCustomBacktraceNode().execute(exception);
            if (hasCustomBacktraceProfile.profile(customBacktrace != null)) {
                return customBacktrace;
            }
            if (hasBacktraceProfile.profile(Layouts.EXCEPTION.getBacktrace(exception) != null)) {
                return ExceptionOperations.backtraceAsRubyStringArray(this.getContext(), exception, Layouts.EXCEPTION.getBacktrace(exception));
            }
            return this.nil();
        }

        private ReadObjectFieldNode getReadCustomBacktraceNode() {
            if (this.readCustomBacktraceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readCustomBacktraceNode = this.insert(ReadObjectFieldNodeGen.create("@custom_backtrace", null));
            }
            return this.readCustomBacktraceNode;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject initialize(DynamicObject exception, NotProvided message) {
            Layouts.EXCEPTION.setMessage(exception, this.nil());
            return exception;
        }

        @Specialization(guards={"wasProvided(message)"})
        public DynamicObject initialize(DynamicObject exception, Object message) {
            Layouts.EXCEPTION.setMessage(exception, message);
            return exception;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode = AllocateObjectNode.create();

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocateNameError(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, this.nil(), null);
        }
    }
}

