/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.AppScheduledExecutorService;
import com.sampullara.cli.Args;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.Usage;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.messages.PlainTextMessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.cli.jvm.compiler.CompilerJarLocator;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.utils.StringsKt;

public abstract class CLICompiler<A extends CommonCompilerArguments> {
    private static void setIdeaIoUseFallback() {
        if (SystemInfo.isWindows) {
            Properties properties2 = System.getProperties();
            properties2.setProperty("idea.io.use.nio2", Boolean.TRUE.toString());
            if (!SystemInfo.isJavaVersionAtLeast("1.7") || "1.7.0-ea".equals(SystemInfo.JAVA_VERSION)) {
                properties2.setProperty("idea.io.use.fallback", Boolean.TRUE.toString());
            }
        }
    }

    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_RELATIVE_PATHS, args);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execAndOutputXml(@NotNull PrintStream errStream, @NotNull Services services, String ... args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "execAndOutputXml"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/cli/common/CLICompiler", "execAndOutputXml"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "execAndOutputXml"));
        }
        ExitCode exitCode = this.exec(errStream, services, MessageRenderer.XML, args);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "execAndOutputXml"));
        }
        return exitCode;
    }

    @NotNull
    public ExitCode execFullPathsInMessages(@NotNull PrintStream errStream, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "execFullPathsInMessages"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "execFullPathsInMessages"));
        }
        ExitCode exitCode = this.exec(errStream, Services.EMPTY, MessageRenderer.PLAIN_FULL_PATHS, args);
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "execFullPathsInMessages"));
        }
        return exitCode;
    }

    @Nullable
    private A parseArguments(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseArguments"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseArguments"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseArguments"));
        }
        try {
            A arguments2 = this.createArguments();
            this.parseArguments(args, arguments2);
            return arguments2;
        }
        catch (IllegalArgumentException e) {
            errStream.println(e.getMessage());
            Usage.print(errStream, this.createArguments(), false);
        }
        catch (Throwable t) {
            errStream.println(messageRenderer.render(CompilerMessageSeverity.EXCEPTION, OutputMessageUtil.renderException(t), CompilerMessageLocation.NO_LOCATION));
        }
        return null;
    }

    public void parseArguments(@NotNull String[] args, @NotNull A arguments2) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseArguments"));
        }
        Pair<List<String>, List<String>> unparsedArgs = CollectionsKt.partition(Args.parse(arguments2, args, false), new Function1<String, Boolean>(){

            @Override
            public Boolean invoke(String s) {
                return s.startsWith("-X");
            }
        });
        ((CommonCompilerArguments)arguments2).unknownExtraFlags = unparsedArgs.getFirst();
        ((CommonCompilerArguments)arguments2).freeArgs = unparsedArgs.getSecond();
        for (String argument : ((CommonCompilerArguments)arguments2).freeArgs) {
            if (!argument.startsWith("-")) continue;
            throw new IllegalArgumentException("Invalid argument: " + argument);
        }
    }

    @NotNull
    protected abstract A createArguments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ExitCode exec(@NotNull PrintStream errStream, @NotNull Services services, @NotNull MessageRenderer messageRenderer, @NotNull String[] args) {
        if (errStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errStream", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        if (messageRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageRenderer", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        K2JVMCompiler.Companion.resetInitStartTime();
        A arguments2 = this.parseArguments(errStream, messageRenderer, args);
        if (arguments2 == null) {
            ExitCode exitCode = ExitCode.INTERNAL_ERROR;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
            }
            return exitCode;
        }
        if (((CommonCompilerArguments)arguments2).help || ((CommonCompilerArguments)arguments2).extraHelp) {
            Usage.print(errStream, this.createArguments(), ((CommonCompilerArguments)arguments2).extraHelp);
            ExitCode exitCode = ExitCode.OK;
            if (exitCode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
            }
            return exitCode;
        }
        PrintingMessageCollector collector2 = new PrintingMessageCollector(errStream, messageRenderer, ((CommonCompilerArguments)arguments2).verbose);
        if (PlainTextMessageRenderer.COLOR_ENABLED) {
            AnsiConsole.systemInstall();
        }
        errStream.print(messageRenderer.renderPreamble());
        ExitCode exitCode = this.exec(collector2, services, arguments2);
        ExitCode exitCode2 = exitCode;
        if (exitCode2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "exec"));
        }
        return exitCode2;
        finally {
            errStream.print(messageRenderer.renderConclusion());
            if (PlainTextMessageRenderer.COLOR_ENABLED) {
                AnsiConsole.systemUninstall();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public ExitCode exec(@NotNull MessageCollector messageCollector, @NotNull Services services, @NotNull A arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void setupCommonArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull CommonCompilerArguments arguments2, @NotNull Services services) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/common/CLICompiler", "setupCommonArgumentsAndServices"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/common/CLICompiler", "setupCommonArgumentsAndServices"));
        }
        if (services == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "services", "org/jetbrains/kotlin/cli/common/CLICompiler", "setupCommonArgumentsAndServices"));
        }
        CompilerJarLocator locator = services.get(CompilerJarLocator.class);
        if (locator != null) {
            configuration.put(CLIConfigurationKeys.COMPILER_JAR_LOCATOR, locator);
        }
        LanguageVersion languageVersion = CLICompiler.parseVersion(configuration, arguments2.languageVersion, "language");
        LanguageVersion apiVersion = CLICompiler.parseVersion(configuration, arguments2.apiVersion, "API");
        if (languageVersion != null || apiVersion != null) {
            if (languageVersion == null) {
                languageVersion = LanguageVersion.LATEST;
            }
            if (apiVersion == null) {
                apiVersion = languageVersion;
            }
            if (apiVersion.compareTo(languageVersion) > 0) {
                configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, "-api-version (" + apiVersion.getVersionString() + ") cannot be greater than " + "-language-version (" + languageVersion.getVersionString() + ")", CompilerMessageLocation.NO_LOCATION);
            }
            configuration.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, new LanguageVersionSettingsImpl(languageVersion, ApiVersion.createByLanguageVersion(apiVersion)));
        }
    }

    private static LanguageVersion parseVersion(@NotNull CompilerConfiguration configuration, @Nullable String value, @NotNull String versionOf) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseVersion"));
        }
        if (versionOf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionOf", "org/jetbrains/kotlin/cli/common/CLICompiler", "parseVersion"));
        }
        if (value == null) {
            return null;
        }
        LanguageVersion version = LanguageVersion.fromVersionString(value);
        if (version != null) {
            return version;
        }
        List<String> versionStrings = ArraysKt.map(LanguageVersion.values(), new Function1<LanguageVersion, String>(){

            @Override
            public String invoke(LanguageVersion version) {
                return version.getVersionString();
            }
        });
        String message = "Unknown " + versionOf + " version: " + value + "\n" + "Supported " + versionOf + " versions: " + StringsKt.join(versionStrings, ", ");
        configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY).report(CompilerMessageSeverity.ERROR, message, CompilerMessageLocation.NO_LOCATION);
        return null;
    }

    private void reportUnknownExtraFlags(@NotNull MessageCollector collector2, @NotNull A arguments2) {
        if (collector2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "org/jetbrains/kotlin/cli/common/CLICompiler", "reportUnknownExtraFlags"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/common/CLICompiler", "reportUnknownExtraFlags"));
        }
        for (String flag : ((CommonCompilerArguments)arguments2).unknownExtraFlags) {
            collector2.report(CompilerMessageSeverity.WARNING, "Flag is not supported by this version of the compiler: " + flag, CompilerMessageLocation.NO_LOCATION);
        }
    }

    @NotNull
    protected abstract ExitCode doExecute(@NotNull A var1, @NotNull Services var2, @NotNull MessageCollector var3, @NotNull Disposable var4);

    private void printVersionIfNeeded(@NotNull MessageCollector messageCollector, @NotNull A arguments2) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/kotlin/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/cli/common/CLICompiler", "printVersionIfNeeded"));
        }
        if (!((CommonCompilerArguments)arguments2).version) {
            return;
        }
        messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin Compiler version 1.0.5", CompilerMessageLocation.NO_LOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doMain(@NotNull CLICompiler compiler, @NotNull String[] args) {
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMain"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMain"));
        }
        System.setProperty("java.awt.headless", "true");
        try {
            ExitCode exitCode = CLICompiler.doMainNoExit(compiler, args);
            if (exitCode != ExitCode.OK) {
                System.exit(exitCode.getCode());
            }
        }
        finally {
            AppScheduledExecutorService service = (AppScheduledExecutorService)AppExecutorUtil.getAppScheduledExecutorService();
            service.shutdownAppScheduledExecutorService();
        }
    }

    @NotNull
    public static ExitCode doMainNoExit(@NotNull CLICompiler compiler, @NotNull String[] args) {
        ExitCode exitCode;
        if (compiler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compiler", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMainNoExit"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMainNoExit"));
        }
        try {
            exitCode = compiler.exec(System.err, args);
        }
        catch (CompileEnvironmentException e) {
            System.err.println(e.getMessage());
            ExitCode exitCode2 = ExitCode.INTERNAL_ERROR;
            if (exitCode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMainNoExit"));
            }
            return exitCode2;
        }
        if (exitCode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/CLICompiler", "doMainNoExit"));
        }
        return exitCode;
    }
}

