##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Auxiliary

  def initialize
    super(
      'Name'         => 'VSploit Zeus DNS Query Module',
      'Description'  => 'This module queries known Zeus Botnet DNS records.',
      'Author'       => 'MJC',
      'License'      => MSF_LICENSE,
      'References'   =>
        [
          [ 'URL', 'https://zeustracker.abuse.ch/blocklist.php?download=domainblocklist']
        ]
    )
    register_options(
      [
        OptString.new('DNS_SERVER',[false, "Specifies a DNS Server"]),
        OptInt.new('COUNT', [false, "Number of intervals to loop",1]),
        OptInt.new('DELAY', [false, "Delay in seconds between intervals",3])
    ],self.class)
  end

  def run
    @res = Net::DNS::Resolver.new()

    domain = [
    "allspring.net","antifoher.biz","asdfasdgqghgsw.cx.cc",
    "ashnmjjpoljfnl.info","atlaz.net","b3l.org","back.boroborogold.ru",
    "bandwithcheckstart.com","batmanrobinho.com","bellicbridge.ru",
    "bestfihteerdr.com","bestprice2you.net","billyd.com.au",
    "bitschoonerop.com","blackskullbg.sytes.net","botikov.eu.tf",
    "botnetdown.gicp.net","boutique.vcm-mode.it","brandc.name",
    "bxkkuskgdjskdn.com","c0re.su","cdvqvnjqqtkqhsoo.info",
    "christmassuper.com","ciritas.ru","citi-spb.ru","clavn.ru",
    "client.trackups.org","client.upsclients.net","cnewsus.ru",
    "cnnus.ru","concapow.in","consoleencydd.com","cqoqgzqmkpkrmlo.com",
    "ctllutheran.org","currencytradechat.com","cyytmmlxsthywst.com",
    "damaka.com","datacricketuf.ru","deimingames.com",
    "dfhhdkdddqjda.start.tl","djerk.info","djpeterblue.com.br",
    "dlmsonisfzksioqq.org","domio.pwomega.ru","favdstgssdqdsfg.start.tl",
    "favoritopilodjd.com","favqnornkwvkwfxv.biz","fdhjkfhskas.com",
    "federalreserve-report.com","federetoktyt.net"
    ]

    if datastore['DNS_SERVER']
      @res.nameservers = datastore['DNS_SERVER']
    end

    count = 0

    while count < datastore['COUNT']

      domain.each do |name|
        query = @res.query(name, "A")
        time = Time.new
        time = time.strftime("%Y-%m-%d %H:%M:%S")
        print_status("#{time} - DNS Query sent for => #{name}")
        if query.answer.length == 0
          print_error("#{time} - #{name} => No Record Found")
        else
          a = query.answer[0].to_s.split(/[\s,]+/)
          print_good("#{time} - #{name} => #{a[-1]}")
        end
      end
      unless count == (datastore['COUNT'] - 1)
        time = Time.new
        time = time.strftime("%Y-%m-%d %H:%M:%S")
        print_status("#{time} - Waiting #{datastore['DELAY']} seconds to query")
        select(nil, nil, nil, datastore['DELAY'])
      end
      count += 1
    end
  end
end
