/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.desktop;

import com.sun.javafx.tk.Toolkit;
import com.sun.scenario.DelayedRunnable;
import com.sun.scenario.Settings;
import com.sun.scenario.animation.AbstractMasterTimer;
import com.sun.scenario.animation.AnimationPulse;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Map;

public final class MasterTimer
extends AbstractMasterTimer {
    private static PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("com.sun.scenario.animation.nogaps")) {
                nogaps = Settings.getBoolean("com.sun.scenario.animation.nogaps");
            } else if (propertyChangeEvent.getPropertyName().equals("javafx.animation.fullspeed")) {
                fullspeed = Settings.getBoolean("javafx.animation.fullspeed");
            } else if (propertyChangeEvent.getPropertyName().equals("com.sun.scenario.animation.adaptivepulse")) {
                useAdaptivePulse = Settings.getBoolean("com.sun.scenario.animation.adaptivepulse");
            } else if (propertyChangeEvent.getPropertyName().equals("com.sun.scenario.animation.AnimationMBean.enabled")) {
                AnimationPulse.getDefaultBean().setEnabled(Settings.getBoolean("com.sun.scenario.animation.AnimationMBean.enabled"));
            }
        }
    };
    private static ReflectAppContext reflectInfo = null;
    private static final Object MASTER_TIMER_KEY;

    private MasterTimer() {
    }

    public static synchronized MasterTimer getInstance() {
        Map<Object, Object> map = Toolkit.getToolkit().getContextMap();
        MasterTimer masterTimer = (MasterTimer)map.get(MASTER_TIMER_KEY);
        if (masterTimer == null) {
            masterTimer = new MasterTimer();
            map.put(MASTER_TIMER_KEY, masterTimer);
            if (Settings.getBoolean("com.sun.scenario.animation.AnimationMBean.enabled", false)) {
                AnimationPulse.getDefaultBean().setEnabled(true);
            }
        }
        return masterTimer;
    }

    @Override
    protected boolean shouldUseNanoTime() {
        boolean bl = false;
        try {
            System.nanoTime();
            bl = true;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return bl;
    }

    @Override
    protected int getPulseDuration(int n) {
        int n2 = n / 60;
        if (Settings.get("javafx.animation.framerate") != null) {
            int n3 = Settings.getInt("javafx.animation.framerate", 60);
            if (n3 > 0) {
                n2 = n / n3;
            }
        } else if (Settings.get("javafx.animation.pulse") != null) {
            int n4 = Settings.getInt("javafx.animation.pulse", 60);
            if (n4 > 0) {
                n2 = n / n4;
            }
        } else {
            int n5 = Toolkit.getToolkit().getRefreshRate();
            if (n5 > 0) {
                n2 = n / n5;
            }
        }
        return n2;
    }

    @Override
    protected void postUpdateAnimationRunnable(DelayedRunnable delayedRunnable) {
        Toolkit.getToolkit().setAnimationRunnable(delayedRunnable);
    }

    static void timePulse(long l) {
        MasterTimer.getInstance().timePulseImpl(l);
    }

    @Override
    protected void recordStart(long l) {
        AnimationPulse.getDefaultBean().recordStart(l);
    }

    @Override
    protected void recordEnd() {
        AnimationPulse.getDefaultBean().recordEnd();
    }

    @Override
    protected void recordAnimationEnd() {
        AnimationPulse.getDefaultBean().recordAnimationEnd();
    }

    static {
        Settings.addPropertyChangeListener("com.sun.scenario.animation.nogaps", pcl);
        Settings.addPropertyChangeListener("com.sun.scenario.animation.adaptivepulse", pcl);
        Settings.addPropertyChangeListener("javafx.animation.fullspeed", pcl);
        Settings.addPropertyChangeListener("com.sun.scenario.animation.AnimationMBean.enabled", pcl);
        MASTER_TIMER_KEY = new StringBuilder("MasterTimerKey");
    }

    private static class ReflectAppContext
    implements PrivilegedAction {
        Class clazz = null;
        Method getAppCtx = null;
        Method isDisposed = null;

        private ReflectAppContext() {
        }

        public Object run() {
            try {
                this.clazz = Class.forName("sun.awt.AppContext", true, null);
                this.getAppCtx = this.clazz.getDeclaredMethod("getAppContext", null);
                this.isDisposed = this.clazz.getDeclaredMethod("isDisposed", null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }
    }
}

