/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.owasp.jbrofuzz.fuzz.Connection;
import org.owasp.jbrofuzz.fuzz.ConnectionException;
import org.owasp.jbrofuzz.fuzz.ui.FuzzingPanel;

public class MessageContainer {
    private static final SimpleDateFormat SD_FORMAT = new SimpleDateFormat("zzz-yyyy-MM-dd-HH-mm-ss-SSS", Locale.ENGLISH);
    private static final SimpleDateFormat SH_FORMAT = new SimpleDateFormat("DDD-HH-mm-ss-SSS", Locale.ENGLISH);
    private final transient StringBuffer message;
    private transient String filename;
    private transient String textURL;
    private transient Date start;
    private transient Date end;
    private transient String status;
    private transient String payload;
    private transient String encodedPayload;
    private transient int replyByteLength;
    private transient String textRequest;

    public MessageContainer(FuzzingPanel fuzzingPanel) {
        this.end = this.start = new Date();
        this.filename = fuzzingPanel.getCounter();
        this.textURL = fuzzingPanel.getTextURL();
        this.status = "---";
        this.payload = fuzzingPanel.getPayload();
        this.encodedPayload = fuzzingPanel.getEncodedPayload();
        this.replyByteLength = 0;
        this.message = new StringBuffer("<!--\n");
    }

    public void setEnd(Date date) {
        this.end = date;
    }

    public String getEndDateFull() {
        return SD_FORMAT.format(this.end);
    }

    public String getEndDateShort() {
        return SH_FORMAT.format(this.end);
    }

    public int getEndDateNumerical() {
        return (int)this.end.getTime();
    }

    public int getStartDateNumerical() {
        return (int)this.start.getTime();
    }

    private void append(int input) {
        this.message.append(input);
        this.message.append('\n');
        this.message.append('-');
        this.message.append('-');
        this.message.append('\n');
    }

    private void append(String input) {
        this.message.append(input);
        this.message.append('\n');
        this.message.append('-');
        this.message.append('-');
        this.message.append('\n');
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public int getByteCount() {
        return this.replyByteLength;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String fileName) {
        this.filename = fileName;
    }

    public int getResponseTime() {
        return (int)(this.end.getTime() - this.start.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStartDateFull() {
        MessageContainer messageContainer = this;
        synchronized (messageContainer) {
            return SD_FORMAT.format(this.start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStartDateShort() {
        MessageContainer messageContainer = this;
        synchronized (messageContainer) {
            return SH_FORMAT.format(this.start);
        }
    }

    public void setStartDate(Date date) {
        this.start = date;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTextURL() {
        return this.textURL;
    }

    public void setTextURL(String url) {
        this.textURL = url;
    }

    public void setConnection(Connection connection) {
        String reply = connection.getReply();
        this.status = connection.getStatus();
        this.end = new Date();
        this.replyByteLength = reply.getBytes().length;
        this.append(this.getResponseTime());
        this.append(this.status);
        this.append(this.getStartDateFull());
        this.append(this.filename);
        this.append(this.textURL);
        this.append(connection.getPort());
        this.append(connection.getMessage());
        this.message.append("--jbrofuzz-->\n");
        this.message.append(reply);
    }

    public String getTextRequest() {
        return this.textRequest;
    }

    public void setTextRequest(String textRequest) {
        this.textRequest = textRequest;
    }

    public void setException(ConnectionException conException) {
        String reply = conException.getMessage();
        this.end = new Date();
        this.append(this.getResponseTime());
        this.append(this.getStartDateFull());
        this.append(this.status);
        this.append(this.filename);
        this.append(this.textURL);
        this.append(reply);
        this.message.append("--jbrofuzz-->\n");
    }

    public String getMessage() {
        return this.message.toString();
    }

    public void setMessage(String message) {
        this.message.append(message);
    }

    public String toString() {
        return this.message.toString();
    }

    public String getEncodedPayload() {
        return this.encodedPayload;
    }

    public void setEncodedPayload(String payload) {
        this.encodedPayload = payload;
    }
}

