/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import ch.csnc.extension.httpclient.PKCS11Configuration;
import ch.csnc.extension.httpclient.SSLContextManager;
import ch.csnc.extension.ui.AliasTableModel;
import ch.csnc.extension.ui.CertificateView;
import ch.csnc.extension.ui.DriversView;
import ch.csnc.extension.util.DriverConfiguration;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.cert.Certificate;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.OptionsParamCertificate;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.utils.ZapTextField;

public class OptionsCertificatePanel
extends AbstractParamPanel
implements Observer {
    private static final long serialVersionUID = 4350957038174673492L;
    private static final int MAX_LOGIN_ATTEMPTS = 3;
    private JButton addPkcs11Button;
    private JButton addPkcs12Button;
    private JScrollPane aliasScrollPane;
    private JTable aliasTable;
    private JButton browseButton;
    private JLabel certificateLabel;
    private JPanel certificatePanel;
    private ZapTextField certificateTextField;
    private JTabbedPane certificatejTabbedPane;
    private JPanel cryptoApiPanel;
    private JLabel cryptoApiLabel;
    private JButton deleteButton;
    private JButton driverButton;
    private JComboBox<String> driverComboBox;
    private JLabel driverLabel;
    private JLabel fileLabel;
    private ZapTextField fileTextField;
    private JList<String> keyStoreList;
    private JPanel keyStorePanel;
    private JScrollPane keyStoreScrollPane;
    private JLabel passwordPkcs11Label;
    private JLabel passwordPkcs12Label;
    private JPanel pkcs11Panel;
    private JPasswordField pkcs11PasswordField;
    private JPanel pkcs12Panel;
    private JPasswordField pkcs12PasswordField;
    private JButton setActiveButton;
    private JButton showActiveCertificateButton;
    private JButton showAliasButton;
    private JLabel textLabel;
    private JCheckBox useClientCertificateCheckBox;
    private JCheckBox usePkcs11ExperimentalSliSupportCheckBox;
    private JCheckBox enableUnsafeSSLRenegotiationCheckBox;
    private SSLContextManager contextManager;
    private DefaultListModel<String> keyStoreListModel;
    private AliasTableModel aliasTableModel;
    private DriverConfiguration driverConfig;
    private boolean retry = true;
    private static int login_attempts = 0;
    private static final Logger logger = Logger.getLogger(OptionsCertificatePanel.class);

    public OptionsCertificatePanel() {
        this.initialize();
    }

    private void initialize() {
        this.contextManager = Model.getSingleton().getOptionsParam().getCertificateParam().getSSLContextManager();
        this.keyStoreListModel = new DefaultListModel();
        this.aliasTableModel = new AliasTableModel(this.contextManager);
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("options.cert.title.cert"));
        JPanel jPanel = this.getPanelCertificate();
        this.add((Component)jPanel, jPanel.getName());
        this.driverConfig = new DriverConfiguration(new File(Constant.getZapInstall(), "xml/drivers.xml"));
        this.updateDriverComboBox();
        this.driverConfig.addObserver(this);
        Certificate certificate = this.contextManager.getDefaultCertificate();
        if (certificate != null) {
            this.certificateTextField.setText(certificate.toString());
        }
    }

    private void updateDriverComboBox() {
        this.driverComboBox.removeAllItems();
        for (String string : this.driverConfig.getNames()) {
            this.driverComboBox.addItem(string);
        }
        this.driverComboBox.repaint();
    }

    private JPanel getPanelCertificate() {
        if (this.certificatePanel == null) {
            this.certificatePanel = new JPanel();
            this.certificatejTabbedPane = new JTabbedPane();
            this.keyStorePanel = new JPanel();
            this.setActiveButton = new JButton();
            this.showAliasButton = new JButton();
            this.aliasScrollPane = new JScrollPane();
            this.aliasTable = new JTable();
            this.deleteButton = new JButton();
            this.keyStoreScrollPane = new JScrollPane();
            this.keyStoreList = new JList();
            this.pkcs12Panel = new JPanel();
            this.fileLabel = new JLabel();
            this.fileTextField = new ZapTextField();
            this.browseButton = new JButton();
            this.passwordPkcs12Label = new JLabel();
            this.addPkcs12Button = new JButton();
            this.pkcs12PasswordField = new JPasswordField();
            this.pkcs11Panel = new JPanel();
            this.driverLabel = new JLabel();
            this.driverComboBox = new JComboBox();
            this.driverButton = new JButton();
            this.passwordPkcs11Label = new JLabel();
            this.cryptoApiLabel = new JLabel();
            this.addPkcs11Button = new JButton();
            this.pkcs11PasswordField = new JPasswordField();
            this.cryptoApiPanel = new JPanel();
            this.useClientCertificateCheckBox = new JCheckBox();
            this.enableUnsafeSSLRenegotiationCheckBox = new JCheckBox();
            this.textLabel = new JLabel();
            this.certificateLabel = new JLabel();
            this.certificateTextField = new ZapTextField();
            this.showActiveCertificateButton = new JButton();
            this.usePkcs11ExperimentalSliSupportCheckBox = new JCheckBox();
            this.certificatejTabbedPane.setEnabled(false);
            this.setActiveButton.setText(Constant.messages.getString("options.cert.button.setactive"));
            this.setActiveButton.setEnabled(false);
            this.setActiveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.setActiveButtonActionPerformed(actionEvent);
                }
            });
            this.showAliasButton.setText("->");
            this.showAliasButton.setEnabled(false);
            this.showAliasButton.setMargin(new Insets(2, 2, 2, 2));
            this.showAliasButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.showAliasButtonActionPerformed(actionEvent);
                }
            });
            this.aliasTable.setModel(this.aliasTableModel);
            this.aliasTable.setTableHeader(null);
            this.aliasScrollPane.setViewportView(this.aliasTable);
            this.deleteButton.setText(Constant.messages.getString("options.cert.button.delete"));
            this.deleteButton.setEnabled(false);
            this.deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.deleteButtonActionPerformed(actionEvent);
                }
            });
            this.keyStoreList.setModel(this.keyStoreListModel);
            this.keyStoreList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    OptionsCertificatePanel.this.keyStoreListMouseClicked(mouseEvent);
                }
            });
            this.keyStoreScrollPane.setViewportView(this.keyStoreList);
            GroupLayout groupLayout = new GroupLayout(this.keyStorePanel);
            this.keyStorePanel.setLayout(groupLayout);
            groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deleteButton).addComponent(this.keyStoreScrollPane, -1, 181, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.setActiveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 100, Short.MAX_VALUE).addComponent(this.showAliasButton)).addComponent(this.aliasScrollPane, -1, 202, Short.MAX_VALUE))));
            groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aliasScrollPane, 0, 0, Short.MAX_VALUE).addComponent(this.keyStoreScrollPane, -1, 95, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deleteButton).addComponent(this.setActiveButton, -2, 18, -2).addComponent(this.showAliasButton))));
            groupLayout.linkSize(1, this.deleteButton, this.setActiveButton, this.showAliasButton);
            this.certificatejTabbedPane.addTab(Constant.messages.getString("options.cert.tab.keystore"), this.keyStorePanel);
            this.fileLabel.setText(Constant.messages.getString("options.cert.label.file"));
            this.browseButton.setText(Constant.messages.getString("options.cert.button.browse"));
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.browseButtonActionPerformed(actionEvent);
                }
            });
            this.passwordPkcs12Label.setText(Constant.messages.getString("options.cert.label.password"));
            this.addPkcs12Button.setText(Constant.messages.getString("options.cert.button.keystore"));
            this.addPkcs12Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.addPkcs12ButtonActionPerformed(actionEvent);
                }
            });
            GroupLayout groupLayout2 = new GroupLayout(this.pkcs12Panel);
            this.pkcs12Panel.setLayout(groupLayout2);
            groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.fileTextField, -1, 296, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(groupLayout2.createSequentialGroup().addGap(12, 12, 12).addComponent(this.fileLabel)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.passwordPkcs12Label)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap(270, Short.MAX_VALUE).addComponent(this.addPkcs12Button)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.pkcs12PasswordField, -1, 369, Short.MAX_VALUE))).addContainerGap()));
            groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.fileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordPkcs12Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pkcs12PasswordField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addPkcs12Button).addGap(70, 70, 70)));
            groupLayout2.linkSize(1, this.addPkcs12Button, this.browseButton, this.fileTextField, this.pkcs12PasswordField);
            this.certificatejTabbedPane.addTab(Constant.messages.getString("options.cert.tab.pkcs"), this.pkcs12Panel);
            this.driverLabel.setText(Constant.messages.getString("options.cert.label.driver"));
            this.driverButton.setText("...");
            this.driverButton.setMargin(new Insets(2, 5, 2, 5));
            this.driverButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.driverButtonActionPerformed(actionEvent);
                }
            });
            this.passwordPkcs11Label.setText(Constant.messages.getString("options.cert.label.pincode"));
            this.addPkcs11Button.setText(Constant.messages.getString("options.cert.button.pkcs11"));
            this.addPkcs11Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.addPkcs11ButtonActionPerformed(actionEvent);
                }
            });
            this.usePkcs11ExperimentalSliSupportCheckBox.setText(Constant.messages.getString("certificates.pkcs11.label.experimentalSliSupport"));
            this.usePkcs11ExperimentalSliSupportCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.usePkcs11ExperimentalSliSupportCheckBox.setMargin(new Insets(0, 0, 0, 0));
            this.usePkcs11ExperimentalSliSupportCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.usePkcs11ExperimentalSliSupportCheckBoxActionPerformed(actionEvent);
                }
            });
            GroupLayout groupLayout3 = new GroupLayout(this.pkcs11Panel);
            this.pkcs11Panel.setLayout(groupLayout3);
            groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pkcs11PasswordField, -1, 369, Short.MAX_VALUE).addComponent(this.driverLabel).addComponent(this.passwordPkcs11Label).addGroup(groupLayout3.createSequentialGroup().addComponent(this.driverComboBox, 0, 336, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.driverButton)).addComponent(this.usePkcs11ExperimentalSliSupportCheckBox).addComponent(this.addPkcs11Button, GroupLayout.Alignment.TRAILING)).addContainerGap()));
            groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.driverLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.driverButton).addComponent(this.driverComboBox, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordPkcs11Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pkcs11PasswordField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.usePkcs11ExperimentalSliSupportCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addPkcs11Button).addGap(58, 58, 58)));
            groupLayout3.linkSize(1, this.addPkcs11Button, this.driverButton, this.driverComboBox, this.pkcs11PasswordField);
            this.certificatejTabbedPane.addTab(Constant.messages.getString("options.cert.tab.pkcs11"), this.pkcs11Panel);
            GroupLayout groupLayout4 = new GroupLayout(this.cryptoApiPanel);
            this.cryptoApiPanel.setLayout(groupLayout4);
            this.cryptoApiLabel.setText(Constant.messages.getString("options.cert.error.crypto"));
            groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 389, Short.MAX_VALUE).addComponent(this.cryptoApiLabel));
            groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 124, Short.MAX_VALUE).addComponent(this.cryptoApiLabel));
            this.certificatejTabbedPane.addTab(Constant.messages.getString("options.cert.tab.cryptoapi"), this.cryptoApiPanel);
            this.useClientCertificateCheckBox.setText(Constant.messages.getString("options.cert.label.useclientcert"));
            this.useClientCertificateCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.useClientCertificateCheckBox.setMargin(new Insets(0, 0, 0, 0));
            this.useClientCertificateCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.useClientCertificateCheckBoxActionPerformed(actionEvent);
                }
            });
            this.enableUnsafeSSLRenegotiationCheckBox.setText(Constant.messages.getString("options.cert.label.enableunsafesslrenegotiation"));
            this.enableUnsafeSSLRenegotiationCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.enableUnsafeSSLRenegotiationCheckBox.setMargin(new Insets(0, 0, 0, 0));
            this.enableUnsafeSSLRenegotiationCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.enableUnsafeSSLRenegotiationCheckBoxActionPerformed(actionEvent);
                }
            });
            this.textLabel.setText(Constant.messages.getString("options.cert.label.addkeystore"));
            this.certificateLabel.setText(Constant.messages.getString("options.cert.label.activecerts"));
            this.certificateTextField.setEnabled(false);
            this.showActiveCertificateButton.setText("->");
            this.showActiveCertificateButton.setActionCommand(">");
            this.showActiveCertificateButton.setEnabled(false);
            this.showActiveCertificateButton.setMargin(new Insets(2, 2, 2, 2));
            this.showActiveCertificateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsCertificatePanel.this.showActiveCertificateButtonActionPerformed(actionEvent);
                }
            });
            GroupLayout groupLayout5 = new GroupLayout(this.certificatePanel);
            this.certificatePanel.setLayout(groupLayout5);
            groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.textLabel, 0, 0, Short.MAX_VALUE).addContainerGap()).addGroup(groupLayout5.createSequentialGroup().addGap(2, 2, 2).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.certificatejTabbedPane, -1, 394, Short.MAX_VALUE).addGroup(groupLayout5.createSequentialGroup().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enableUnsafeSSLRenegotiationCheckBox).addComponent(this.useClientCertificateCheckBox).addComponent(this.certificateLabel).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addComponent(this.certificateTextField, -1, 363, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showActiveCertificateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addContainerGap())))));
            groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.textLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.enableUnsafeSSLRenegotiationCheckBox).addComponent(this.useClientCertificateCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.certificatejTabbedPane, -1, 152, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.certificateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.certificateTextField, -2, -1, -2).addComponent(this.showActiveCertificateButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
            groupLayout5.linkSize(1, this.certificateTextField, this.showActiveCertificateButton);
            GroupLayout groupLayout6 = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout(groupLayout6);
            groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.certificatePanel, -1, -1, Short.MAX_VALUE));
            groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addComponent(this.certificatePanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        }
        return this.certificatePanel;
    }

    private void keyStoreListMouseClicked(MouseEvent mouseEvent) {
        int n = this.keyStoreList.getSelectedIndex();
        try {
            this.aliasTableModel.setKeystore(n);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), exception.toString()}, Constant.messages.getString("options.cert.error.accesskeystore"), 0);
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void showActiveCertificateButtonActionPerformed(ActionEvent actionEvent) {
        Certificate certificate = this.contextManager.getDefaultCertificate();
        if (certificate != null) {
            this.showCertificate(certificate);
        }
    }

    private void addPkcs11ButtonActionPerformed(ActionEvent actionEvent) {
        String string = null;
        try {
            int n = this.driverComboBox.getSelectedIndex();
            string = this.driverConfig.getNames().get(n);
            if (string.equals("")) {
                return;
            }
            String string2 = this.driverConfig.getPaths().get(n);
            if (string2.equals("")) {
                return;
            }
            int n2 = this.driverConfig.getSlots().get(n);
            if (n2 < 0) {
                return;
            }
            int n3 = this.driverConfig.getSlotIndexes().get(n);
            if (n3 < 0) {
                return;
            }
            String string3 = new String(this.pkcs11PasswordField.getPassword());
            if (string3.equals("")) {
                string3 = null;
            }
            PKCS11Configuration.PCKS11ConfigurationBuilder pCKS11ConfigurationBuilder = PKCS11Configuration.builder();
            pCKS11ConfigurationBuilder.setName(string).setLibrary(string2);
            if (this.usePkcs11ExperimentalSliSupportCheckBox.isSelected()) {
                pCKS11ConfigurationBuilder.setSlotListIndex(n3);
            } else {
                pCKS11ConfigurationBuilder.setSlotId(n2);
            }
            int n4 = this.contextManager.initPKCS11(pCKS11ConfigurationBuilder.build(), string3);
            if (n4 == -1) {
                logger.error((Object)"The required PKCS#11 provider is not available (sun.security.pkcs11.SunPKCS11 or com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl).");
                this.showErrorMessageSunPkcs11ProviderNotAvailable();
                return;
            }
            login_attempts = 0;
            this.keyStoreListModel.insertElementAt(this.contextManager.getKeyStoreDescription(n4), n4);
            this.retry = true;
            this.certificatejTabbedPane.setSelectedIndex(0);
            this.driverComboBox.setSelectedIndex(-1);
            this.pkcs11PasswordField.setText("");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof ProviderException) {
                if ("Error parsing configuration".equals(invocationTargetException.getCause().getMessage())) {
                    this.showGenericErrorMessagePkcs11CouldNotBeAdded();
                    logger.warn((Object)("Couldn't add key from " + string), invocationTargetException.getCause());
                } else if ("Initialization failed".equals(invocationTargetException.getCause().getMessage())) {
                    if (this.retry) {
                        this.retry = false;
                        this.addPkcs11ButtonActionPerformed(actionEvent);
                    } else {
                        JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.pkcs11")}, Constant.messages.getString("options.cert.label.client.cert"), 0);
                        this.retry = true;
                        logger.warn((Object)("Couldn't add key from " + string), (Throwable)invocationTargetException);
                    }
                } else {
                    this.showGenericErrorMessagePkcs11CouldNotBeAdded();
                    logger.warn((Object)("Couldn't add key from " + string), (Throwable)invocationTargetException);
                }
            } else {
                this.showGenericErrorMessagePkcs11CouldNotBeAdded();
                logger.error((Object)("Couldn't add key from " + string), (Throwable)invocationTargetException);
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("load failed") && iOException.getCause().getClass().getName().equals("javax.security.auth.login.FailedLoginException")) {
                String string4 = " (" + ++login_attempts + "/" + 3 + ") ";
                if (login_attempts == 2) {
                    JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.wrongpassword"), Constant.messages.getString("options.cert.error.wrongpasswordlast"), string4}, Constant.messages.getString("options.cert.label.client.cert"), 0);
                    logger.warn((Object)("PKCS#11: Incorrect PIN or password" + string4 + ": " + string + " *LAST TRY BEFORE BLOCKING*"));
                } else {
                    JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.wrongpassword"), string4}, Constant.messages.getString("options.cert.label.client.cert"), 0);
                    logger.warn((Object)("PKCS#11: Incorrect PIN or password" + string4 + ": " + string));
                }
            } else {
                this.showGenericErrorMessagePkcs11CouldNotBeAdded();
                logger.warn((Object)("Couldn't add key from " + string), (Throwable)iOException);
            }
        }
        catch (KeyStoreException keyStoreException) {
            this.showGenericErrorMessagePkcs11CouldNotBeAdded();
            logger.warn((Object)("Couldn't add key from " + string), (Throwable)keyStoreException);
        }
        catch (Exception exception) {
            this.showGenericErrorMessagePkcs11CouldNotBeAdded();
            logger.error((Object)("Couldn't add key from " + string), (Throwable)exception);
        }
    }

    private void showErrorMessageSunPkcs11ProviderNotAvailable() {
        String string = Constant.messages.getString("options.cert.error.pkcs11notavailable.sun.hyperlink");
        String string2 = Constant.messages.getString("options.cert.error.pkcs11notavailable.ibm.hyperlink");
        Object[] objectArray = new Object[2];
        try {
            JXHyperlink jXHyperlink = new JXHyperlink();
            jXHyperlink.setURI(URI.create(string));
            jXHyperlink.setText(Constant.messages.getString("options.cert.error.pkcs11notavailable.sun.hyperlink.text"));
            objectArray[0] = jXHyperlink;
            jXHyperlink = new JXHyperlink();
            jXHyperlink.setURI(URI.create(string2));
            jXHyperlink.setText(Constant.messages.getString("options.cert.error.pkcs11notavailable.ibm.hyperlink.text"));
            objectArray[1] = jXHyperlink;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            objectArray[0] = string;
            objectArray[1] = string2;
        }
        JOptionPane.showMessageDialog(null, new Object[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.pkcs11notavailable"), objectArray}, Constant.messages.getString("options.cert.label.client.cert"), 0);
    }

    private void showGenericErrorMessagePkcs11CouldNotBeAdded() {
        JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error"), Constant.messages.getString("options.cert.error.password")}, Constant.messages.getString("options.cert.label.client.cert"), 0);
    }

    private void driverButtonActionPerformed(ActionEvent actionEvent) {
        new JDialog((Frame)new DriversView(this.driverConfig), true);
    }

    private void addPkcs12ButtonActionPerformed(ActionEvent actionEvent) {
        if (this.fileTextField.getText().equals("")) {
            return;
        }
        String string = new String(this.pkcs12PasswordField.getPassword());
        if (string.equals("")) {
            JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error.pkcs12nopass"), Constant.messages.getString("options.cert.error.usepassfile")}, Constant.messages.getString("options.cert.error"), 0);
            return;
        }
        try {
            int n = this.contextManager.loadPKCS12Certificate(this.fileTextField.getText(), string);
            this.keyStoreListModel.insertElementAt(this.contextManager.getKeyStoreDescription(n), n);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error.accesskeystore"), Constant.messages.getString("options.cert.error.password")}, Constant.messages.getString("options.cert.error"), 0);
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return;
        }
        this.certificatejTabbedPane.setSelectedIndex(0);
        this.fileTextField.setText("");
        this.pkcs12PasswordField.setText("");
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Constant.messages.getString("options.cert.label.client.cert") + " (*.p12)";
            }

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".p12");
            }
        });
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            this.fileTextField.setText(jFileChooser.getSelectedFile().toString());
        }
    }

    private void showAliasButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        Certificate certificate;
        int n2 = this.keyStoreList.getSelectedIndex();
        if (n2 >= 0 && (certificate = this.contextManager.getCertificate(n2, n = this.aliasTable.getSelectedRow())) != null) {
            this.showCertificate(certificate);
        }
    }

    private void showCertificate(Certificate certificate) {
        if (certificate != null) {
            CertificateView certificateView = new CertificateView(certificate.toString());
            certificateView.setVisible(true);
        }
    }

    private void setActiveButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.keyStoreList.getSelectedIndex();
        int n2 = this.aliasTable.getSelectedRow();
        if (n > -1 && n2 > -1) {
            Object object;
            if (!this.contextManager.isKeyUnlocked(n, n2)) {
                try {
                    if (!this.contextManager.unlockKeyWithDefaultPassword(n, n2) && !this.contextManager.unlockKey(n, n2, (String)(object = this.getPassword()))) {
                        JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error.accesskeystore")}, Constant.messages.getString("options.cert.error"), 0);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error.accesskeystore"), exception.toString()}, Constant.messages.getString("options.cert.error"), 0);
                }
            }
            object = this.contextManager.getCertificate(n, n2);
            try {
                this.contextManager.getFingerPrint((Certificate)object);
            }
            catch (KeyStoreException keyStoreException) {
                JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.error.fingerprint"), keyStoreException.toString()}, Constant.messages.getString("options.cert.error"), 0);
            }
            try {
                this.contextManager.setDefaultKey(n, n2);
                OptionsParamCertificate optionsParamCertificate = Model.getSingleton().getOptionsParam().getCertificateParam();
                optionsParamCertificate.setActiveCertificate();
            }
            catch (KeyStoreException keyStoreException) {
                logger.error((Object)keyStoreException.getMessage(), (Throwable)keyStoreException);
            }
            this.certificateTextField.setText(this.contextManager.getDefaultKey());
        }
    }

    public String getPassword() {
        JPasswordField jPasswordField = new JPasswordField();
        int n = JOptionPane.showConfirmDialog(this, jPasswordField, Constant.messages.getString("options.cert.label.enterpassword"), 2);
        if (n == 0) {
            return new String(jPasswordField.getPassword());
        }
        return null;
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.keyStoreList.getSelectedIndex();
        if (n >= 0) {
            boolean bl = this.contextManager.removeKeyStore(n);
            if (bl) {
                this.certificateTextField.setText("");
            }
            this.keyStoreListModel.removeElementAt(this.keyStoreList.getSelectedIndex());
            this.aliasTableModel.removeKeystore();
        }
    }

    private void useClientCertificateCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.certificatejTabbedPane.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.keyStoreScrollPane.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.keyStoreList.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.aliasScrollPane.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.aliasTable.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.deleteButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.setActiveButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.showAliasButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.fileTextField.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.browseButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.pkcs12PasswordField.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.addPkcs12Button.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.driverComboBox.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.driverButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.pkcs11PasswordField.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.addPkcs11Button.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.usePkcs11ExperimentalSliSupportCheckBox.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.usePkcs11ExperimentalSliSupportCheckBox.setSelected(Model.getSingleton().getOptionsParam().getExperimentalFeaturesParam().isExerimentalSliSupportEnabled());
        this.certificateTextField.setEnabled(this.useClientCertificateCheckBox.isSelected());
        this.showActiveCertificateButton.setEnabled(this.useClientCertificateCheckBox.isSelected());
    }

    private void enableUnsafeSSLRenegotiationCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.enableUnsafeSSLRenegotiationCheckBox.isSelected();
        if (bl) {
            JOptionPane.showMessageDialog(null, new String[]{Constant.messages.getString("options.cert.label.enableunsafesslrenegotiationwarning")}, Constant.messages.getString("options.cert.label.enableunsafesslrenegotiation"), 1);
        }
    }

    private void usePkcs11ExperimentalSliSupportCheckBoxActionPerformed(ActionEvent actionEvent) {
        Model.getSingleton().getOptionsParam().getExperimentalFeaturesParam().setSlotListIndexSupport(this.usePkcs11ExperimentalSliSupportCheckBox.isSelected());
    }

    private OptionsCertificatePanel getContentPane() {
        return this;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        OptionsParamCertificate optionsParamCertificate = optionsParam.getCertificateParam();
        this.useClientCertificateCheckBox.setSelected(optionsParamCertificate.isUseClientCert());
        this.enableUnsafeSSLRenegotiationCheckBox.setSelected(optionsParamCertificate.isAllowUnsafeSslRenegotiation());
    }

    @Override
    public void validateParam(Object object) {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        OptionsParamCertificate optionsParamCertificate = optionsParam.getCertificateParam();
        optionsParamCertificate.setEnableCertificate(this.useClientCertificateCheckBox.isSelected());
        optionsParamCertificate.setAllowUnsafeSslRenegotiation(this.enableUnsafeSSLRenegotiationCheckBox.isSelected());
    }

    @Override
    public void update(Observable observable, Object object) {
        this.updateDriverComboBox();
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.certificate";
    }
}

