/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public class PopupMenuPurgeHistory
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = -155358408946131183L;
    private final ExtensionHistory extension;

    public PopupMenuPurgeHistory(ExtensionHistory extensionHistory) {
        super(Constant.messages.getString("history.purge.popup"), true);
        this.extension = extensionHistory;
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.HISTORY_PANEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performHistoryReferenceActions(List<HistoryReference> list) {
        int n;
        if (list.size() > 1 && (n = this.extension.getView().showConfirmDialog(Constant.messages.getString("history.purge.warning"))) != 0) {
            return;
        }
        ExtensionHistory extensionHistory = this.extension;
        synchronized (extensionHistory) {
            for (HistoryReference historyReference : list) {
                this.purgeHistory(historyReference);
            }
        }
    }

    @Override
    public void performAction(HistoryReference historyReference) {
    }

    private void purgeHistory(HistoryReference historyReference) {
        if (historyReference == null) {
            return;
        }
        this.extension.removeFromHistoryList(historyReference);
        this.extension.clearLogPanelDisplayQueue();
        ExtensionAlert extensionAlert = (ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert");
        if (extensionAlert != null) {
            extensionAlert.deleteHistoryReferenceAlerts(historyReference);
        }
        this.extension.delete(historyReference);
        SiteNode siteNode = historyReference.getSiteNode();
        if (siteNode == null) {
            return;
        }
        SiteMap siteMap = Model.getSingleton().getSession().getSiteTree();
        if (siteNode.getHistoryReference() == historyReference) {
            this.extension.purge(siteMap, siteNode);
        } else {
            siteNode.getPastHistoryReference().remove(historyReference);
            siteMap.removeHistoryReference(historyReference.getHistoryId());
        }
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

