/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.Debug;
import com.oracle.truffle.object.DebugCounter;
import com.oracle.truffle.object.Locations;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.PropertyMap;
import com.oracle.truffle.object.ShapeImpl;

public abstract class DynamicObjectImpl
extends DynamicObject
implements Cloneable {
    private ShapeImpl shape;
    public static final DebugCounter reshapeCount = DebugCounter.create("Reshape count");

    protected DynamicObjectImpl(Shape shape) {
        assert (shape instanceof ShapeImpl);
        this.initialize(shape);
        this.setShape(shape);
        if (ObjectStorageOptions.Profile) {
            Debug.trackObject(this);
        }
    }

    @Override
    public Object getTypeIdentifier() {
        return this.getShape();
    }

    @Override
    public ShapeImpl getShape() {
        return this.shape;
    }

    protected void setShape(Shape shape) {
        assert (shape.getLayout().getType().isInstance(this));
        this.shape = (ShapeImpl)shape;
    }

    protected abstract void initialize(Shape var1);

    public final void setShapeAndResize(Shape newShape) {
        this.setShapeAndResize(this.getShape(), newShape);
    }

    @Override
    public final void setShapeAndResize(Shape oldShape, Shape newShape) {
        assert (this.getShape() == oldShape) : "wrong old shape";
        assert (!oldShape.isShared());
        if (oldShape != newShape) {
            this.setShape(newShape);
            this.resizeStore(oldShape, newShape);
            assert (this.checkExtensionArrayInvariants(newShape));
        }
    }

    @Override
    public final void setShapeAndGrow(Shape oldShape, Shape newShape) {
        assert (this.getShape() == oldShape) : "wrong old shape";
        if (oldShape != newShape) {
            assert (this.checkSetShape(oldShape, newShape));
            this.setShape(newShape);
            this.growStore(oldShape, newShape);
            assert (this.checkExtensionArrayInvariants(newShape));
        }
    }

    private void growStore(Shape oldShape, Shape newShape) {
        this.growObjectStore(oldShape, newShape);
        if (((ShapeImpl)newShape).hasPrimitiveArray) {
            this.growPrimitiveStore(oldShape, newShape);
        }
    }

    protected abstract void growObjectStore(Shape var1, Shape var2);

    protected abstract void growPrimitiveStore(Shape var1, Shape var2);

    private void resizeStore(Shape oldShape, Shape newShape) {
        this.resizeObjectStore(oldShape, newShape);
        if (((ShapeImpl)newShape).hasPrimitiveArray) {
            this.resizePrimitiveStore(oldShape, newShape);
        }
    }

    protected abstract void resizePrimitiveStore(Shape var1, Shape var2);

    protected abstract void resizeObjectStore(Shape var1, Shape var2);

    private boolean checkSetShape(Shape oldShape, Shape newShape) {
        ShapeImpl currentShape = this.getShape();
        assert (oldShape != newShape) : "Wrong old shape assumption?";
        assert (newShape != currentShape) : "Redundant shape change? shape=" + currentShape;
        return true;
    }

    protected abstract boolean checkExtensionArrayInvariants(Shape var1);

    protected final DynamicObject clone() {
        try {
            return (DynamicObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    protected abstract DynamicObject cloneWithShape(Shape var1);

    protected abstract void reshape(ShapeImpl var1);

    public final void copyProperties(DynamicObject fromObject, Shape ancestor) {
        ShapeImpl fromShape = (ShapeImpl)fromObject.getShape();
        ShapeImpl toShape = this.getShape();
        assert (toShape.isRelated(ancestor));
        assert (toShape.isValid());
        assert (ancestor.isValid());
        assert (!fromShape.isShared());
        PropertyMap ancestorMap = ((ShapeImpl)ancestor).getPropertyMap();
        PropertyMap fromMap = fromShape.getPropertyMap();
        for (PropertyMap toMap = toShape.getPropertyMap(); !toMap.isEmpty() && toMap != ancestorMap; toMap = toMap.getParentMap()) {
            Property toProperty = toMap.getLastProperty();
            Property fromProperty = (Property)fromMap.get(toProperty.getKey());
            if (toProperty.getLocation() != null && !(toProperty.getLocation() instanceof Locations.ValueLocation) && !toProperty.getLocation().equals(fromProperty.getLocation())) {
                toProperty.setInternal(this, fromProperty.get(fromObject, false));
                assert (toShape.isValid());
            }
            if (fromProperty != fromMap.getLastProperty()) continue;
            fromMap = fromMap.getParentMap();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean changeFlags(Object key, int newFlags) {
        ShapeImpl oldShape = this.getShape();
        Property existing = ((Shape)oldShape).getProperty(key);
        if (existing != null) {
            if (existing.getFlags() != newFlags) {
                Property newProperty = existing.copyWithFlags(newFlags);
                Shape newShape = ((Shape)oldShape).replaceProperty(existing, newProperty);
                this.setShape(newShape);
            }
            return true;
        }
        return false;
    }

    public String debugDump(int level) {
        return this.debugDump(0, level);
    }

    public String debugDump(int level, int levelStop) {
        return Debug.dumpObject(this, level, levelStop);
    }

    public String toString() {
        return this.getShape().getObjectType().toString(this);
    }

    public boolean equals(Object obj) {
        return this.getShape().getObjectType().equals(this, obj);
    }

    public int hashCode() {
        return this.getShape().getObjectType().hashCode(this);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object get(Object key, Object defaultValue) {
        Property existing = this.getShape().getProperty(key);
        if (existing != null) {
            return existing.get((DynamicObject)this, false);
        }
        return defaultValue;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(Object key, Object value) {
        Property existing = this.getShape().getProperty(key);
        if (existing != null) {
            existing.setGeneric(this, value, null);
            return true;
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void define(Object key, Object value, int flags) {
        this.define(key, value, flags, this.getShape().getLayout().getStrategy().getDefaultLocationFactory());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void define(Object key, Object value, int flags, LocationFactory locationFactory) {
        ShapeImpl oldShape = this.getShape();
        oldShape.getLayout().getStrategy().objectDefineProperty(this, key, value, flags, locationFactory, oldShape);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(Object key) {
        ShapeImpl oldShape = this.getShape();
        Property existing = oldShape.getProperty(key);
        if (existing != null) {
            oldShape.getLayout().getStrategy().objectRemoveProperty(this, existing, oldShape);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.getShape().getPropertyCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean updateShape() {
        return this.getShape().getLayout().getStrategy().updateShape(this);
    }

    @Override
    public final DynamicObject copy(Shape currentShape) {
        return this.cloneWithShape(currentShape);
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return this.getShape().getForeignAccessFactory(this);
    }
}

