/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.PrimitiveValueProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import org.jruby.truffle.language.RubyNode;

@NodeInfo(cost=NodeCost.NONE)
public class ProfileArgumentNode
extends RubyNode {
    @Node.Child
    private RubyNode readArgumentNode;
    private final ConditionProfile objectProfile = ConditionProfile.createBinaryProfile();
    private final ValueProfile primitiveProfile = PrimitiveValueProfile.createEqualityProfile();
    private final ValueProfile classProfile = ValueProfile.createClassProfile();

    public ProfileArgumentNode(RubyNode readArgumentNode) {
        this.readArgumentNode = readArgumentNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object value = this.readArgumentNode.execute(frame);
        if (this.objectProfile.profile(value instanceof TruffleObject)) {
            return this.classProfile.profile(value);
        }
        return this.primitiveProfile.profile(value);
    }
}

