#ifndef _EFL_EVENT_POINTER_EO_H_
#define _EFL_EVENT_POINTER_EO_H_

#ifndef _EFL_EVENT_POINTER_EO_CLASS_TYPE
#define _EFL_EVENT_POINTER_EO_CLASS_TYPE

typedef Eo Efl_Event_Pointer;

#endif

#ifndef _EFL_EVENT_POINTER_EO_TYPES
#define _EFL_EVENT_POINTER_EO_TYPES


#endif
/** Event data carried over with any pointer event (mouse, touch, ...)
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
#define EFL_EVENT_POINTER_CLASS efl_event_pointer_class_get()

EWAPI const Eo_Class *efl_event_pointer_class_get(void);

/**
 * @brief The action represented by this event.
 *
 * @param[in] act
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_action_set(Eo *obj, Efl_Pointer_Action act);

/** The action represented by this event.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI Efl_Pointer_Action efl_event_pointer_action_get(const Eo *obj);

/**
 * @brief The mouse button that triggered the event.
 *
 * @param[in] but 1 to 32, 0 if not a button event.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_button_set(Eo *obj, int but);

/**
 * @brief The mouse button that triggered the event.
 *
 * @return 1 to 32, 0 if not a button event.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI int efl_event_pointer_button_get(const Eo *obj);

/**
 * @brief Whether a mouse button is pressed at the moment of the event.
 *
 * @param[in] button
 * @param[in] pressed
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_button_pressed_set(Eo *obj, int button, Eina_Bool pressed);

/**
 * @brief Whether a mouse button is pressed at the moment of the event.
 *
 * @param[in] button
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI Eina_Bool efl_event_pointer_button_pressed_get(const Eo *obj, int button);

/**
 * @brief Position where the event happened, relative to the window.
 *
 * @param[in] x
 * @param[in] y
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_position_set(Eo *obj, int x, int y);

/**
 * @brief Position where the event happened, relative to the window.
 *
 * @param[out] x
 * @param[out] y
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_position_get(const Eo *obj, int *x, int *y);

/**
 * @brief Position where the event happened, with subpixel precision
 *
 * @note Same value as @ref efl_event_pointer_position_get, relative to the
 * window.
 *
 * @param[in] x
 * @param[in] y
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_position_precise_set(Eo *obj, double x, double y);

/**
 * @brief Position where the event happened, with subpixel precision
 *
 * @note Same value as @ref efl_event_pointer_position_get, relative to the
 * window.
 *
 * @param[out] x
 * @param[out] y
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_position_precise_get(const Eo *obj, double *x, double *y);

/**
 * @brief Position of the previous event, valid for move events.
 *
 * Relative to the window. May be equal to @ref efl_event_pointer_position_get.
 *
 * @param[in] x
 * @param[in] y
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_previous_position_set(Eo *obj, int x, int y);

/**
 * @brief Position of the previous event, valid for move events.
 *
 * Relative to the window. May be equal to @ref efl_event_pointer_position_get.
 *
 * @param[out] x
 * @param[out] y
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_previous_position_get(const Eo *obj, int *x, int *y);

/**
 * @brief Position of the previous event, with subpixel precision.
 *
 * Valid for move events, may not be valid for other events. Relative to the
 * window. May be equal to @ref efl_event_pointer_position_precise_get.
 *
 * @param[in] x
 * @param[in] y
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_previous_position_precise_set(Eo *obj, double x, double y);

/**
 * @brief Position of the previous event, with subpixel precision.
 *
 * Valid for move events, may not be valid for other events. Relative to the
 * window. May be equal to @ref efl_event_pointer_position_precise_get.
 *
 * @param[out] x
 * @param[out] y
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_previous_position_precise_get(const Eo *obj, double *x, double *y);

/**
 * @brief Finger ID in case of a multi touch event.
 *
 * @param[in] id
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_finger_set(Eo *obj, int id);

/** Finger ID in case of a multi touch event.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI int efl_event_pointer_finger_get(const Eo *obj);

/**
 * @brief Touch information about a specific finger or pointer.
 *
 * @param[in] radius
 * @param[in] rad_x
 * @param[in] rad_y
 * @param[in] pressure
 * @param[in] angle
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_touch_set(Eo *obj, double radius, double rad_x, double rad_y, double pressure, double angle);

/**
 * @brief Touch information about a specific finger or pointer.
 *
 * @param[out] radius
 * @param[out] rad_x
 * @param[out] rad_y
 * @param[out] pressure
 * @param[out] angle
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_touch_get(const Eo *obj, double *radius, double *rad_x, double *rad_y, double *pressure, double *angle);

/**
 * @brief The object where this event first originated, in case of propagation
 * or repetition of the event.
 *
 * @param[in] src Source object: @c Efl.Gfx
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_source_set(Eo *obj, Eo_Base *src);

/**
 * @brief The object where this event first originated, in case of propagation
 * or repetition of the event.
 *
 * @return Source object: @c Efl.Gfx
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI Eo_Base *efl_event_pointer_source_get(const Eo *obj);

/**
 * @brief Double or triple click information.
 *
 * @param[in] flags
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_button_flags_set(Eo *obj, Efl_Pointer_Flags flags);

/** Double or triple click information.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI Efl_Pointer_Flags efl_event_pointer_button_flags_get(const Eo *obj);

/**
 * @brief @c true if @ref efl_event_pointer_button_flags_get indicates a double
 * click (2nd press).
 *
 * This is just a helper function around
 * @ref efl_event_pointer_button_flags_get.
 *
 * @param[in] val
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_double_click_set(Eo *obj, Eina_Bool val);

/**
 * @brief @c true if @ref efl_event_pointer_button_flags_get indicates a double
 * click (2nd press).
 *
 * This is just a helper function around
 * @ref efl_event_pointer_button_flags_get.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI Eina_Bool efl_event_pointer_double_click_get(const Eo *obj);

/**
 * @brief @c true if @ref efl_event_pointer_button_flags_get indicates a triple
 * click (3rd press).
 *
 * This is just a helper function around
 * @ref efl_event_pointer_button_flags_get.
 *
 * @param[in] val
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI void efl_event_pointer_triple_click_set(Eo *obj, Eina_Bool val);

/**
 * @brief @c true if @ref efl_event_pointer_button_flags_get indicates a triple
 * click (3rd press).
 *
 * This is just a helper function around
 * @ref efl_event_pointer_button_flags_get.
 *
 * @since 1.18
 *
 * @ingroup Efl_Event_Pointer
 */
EOAPI Eina_Bool efl_event_pointer_triple_click_get(const Eo *obj);

EOAPI void efl_event_pointer_wheel_direction_set(Eo *obj, Efl_Orient dir);

EOAPI Efl_Orient efl_event_pointer_wheel_direction_get(const Eo *obj);

EOAPI void efl_event_pointer_wheel_distance_set(Eo *obj, int dist);

EOAPI int efl_event_pointer_wheel_distance_get(const Eo *obj);


#endif
