-- EFL LuaJIT bindings: elm_app_server_view.eo (class Elm.App.Server.View)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_app_server_view_class_get()
    eo.class_register("Elm_App_Server_View", {"Eo_Base"}, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_app_server_view_class_get(void);
    void elm_app_server_view_progress_set(short progress);
    short elm_app_server_view_progress_get(void);
    void elm_app_server_view_new_events_set(int events);
    int elm_app_server_view_new_events_get(void);
    void elm_app_server_view_icon_set(const char * icon);
    const char *elm_app_server_view_icon_get(void);
    void elm_app_server_view_title_set(const char * title);
    const char *elm_app_server_view_title_get(void);
    void elm_app_server_view_window_set(Efl_Canvas_Object * win);
    void elm_app_server_view_id_set(const char * ret);
    const char *elm_app_server_view_id_get(void);
    Elm_App_View_State elm_app_server_view_state_get(void);
    const char *elm_app_server_view_path_get(void);
    void elm_app_server_view_pixels_set(unsigned int w, unsigned int h, Eina_Bool has_alpha, const unsigned char * pixels);
    void elm_app_server_view_pixels_get(unsigned int *w, unsigned int *h, Eina_Bool *has_alpha, const unsigned char * *pixels);
    void elm_app_server_view_pause(void);
    void elm_app_server_view_resume(void);
    void elm_app_server_view_shallow(void);
    void elm_app_server_view_close(void);
    extern const Eo_Event_Description _ELM_APP_SERVER_VIEW_EVENT_RESUMED;
    extern const Eo_Event_Description _ELM_APP_SERVER_VIEW_EVENT_PAUSED;
    extern const Eo_Event_Description _ELM_APP_SERVER_VIEW_EVENT_CLOSED;
    extern const Eo_Event_Description _ELM_APP_SERVER_VIEW_EVENT_SHALLOW;
    extern const Eo_Event_Description _ELM_APP_SERVER_VIEW_EVENT_SAVE;
]]

local __M = util.get_namespace(M, { "app", "server" })
__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    progress_set = function(self, progress)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_progress_set(progress)
        eo.__do_end()
    end,

    progress_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_view_progress_get()
        eo.__do_end()
        return tonumber(v)
    end,

    new_events_set = function(self, events)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_new_events_set(events)
        eo.__do_end()
    end,

    new_events_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_view_new_events_get()
        eo.__do_end()
        return tonumber(v)
    end,

    icon_set = function(self, icon)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_icon_set(icon)
        eo.__do_end()
    end,

    icon_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_view_icon_get()
        eo.__do_end()
        return v
    end,

    title_set = function(self, title)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_title_set(title)
        eo.__do_end()
    end,

    title_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_view_title_get()
        eo.__do_end()
        return v
    end,

    window_set = function(self, win)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_window_set(win)
        eo.__do_end()
    end,

    id_set = function(self, ret)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_id_set(ret)
        eo.__do_end()
    end,

    id_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_view_id_get()
        eo.__do_end()
        return v
    end,

    state_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_view_state_get()
        eo.__do_end()
        return v
    end,

    path_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_view_path_get()
        eo.__do_end()
        return v
    end,

    pixels_set = function(self, w, h, has_alpha, pixels)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_pixels_set(w, h, has_alpha, pixels)
        eo.__do_end()
    end,

    pixels_get = function(self)
        eo.__do_start(self, __class)
        local w = ffi.new("unsigned int[1]")
        local h = ffi.new("unsigned int[1]")
        local has_alpha = ffi.new("Eina_Bool[1]")
        local pixels = ffi.new("const unsigned char *[1]")
        __lib.elm_app_server_view_pixels_get(w, h, has_alpha, pixels)
        eo.__do_end()
        return w[0], h[0], ((has_alpha[0]) ~= 0), pixels[0]
    end,

    pause = function(self)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_pause()
        eo.__do_end()
    end,

    resume = function(self)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_resume()
        eo.__do_end()
    end,

    shallow = function(self)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_shallow()
        eo.__do_end()
    end,

    close = function(self)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_close()
        eo.__do_end()
    end,

    __events = {
        ["resumed"] = __lib._ELM_APP_SERVER_VIEW_EVENT_RESUMED,
        ["paused"] = __lib._ELM_APP_SERVER_VIEW_EVENT_PAUSED,
        ["closed"] = __lib._ELM_APP_SERVER_VIEW_EVENT_CLOSED,
        ["shallow"] = __lib._ELM_APP_SERVER_VIEW_EVENT_SHALLOW,
        ["save"] = __lib._ELM_APP_SERVER_VIEW_EVENT_SAVE
    },

    __properties = {
        ["icon"] = { 0, 0, 1, 1, true, true },
        ["id"] = { 0, 0, 1, 1, true, true },
        ["path"] = { 0, 0, 1, 0, true, false },
        ["title"] = { 0, 0, 1, 1, true, true },
        ["pixels"] = { 0, 0, 4, 4, true, true },
        ["state"] = { 0, 0, 1, 0, true, false },
        ["new_events"] = { 0, 0, 1, 1, true, true },
        ["window"] = { 0, 0, 0, 1, false, true },
        ["progress"] = { 0, 0, 1, 1, true, true }
    }
}

__M.View = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_App_Server_View").__eo_ctor,
                            1, ...)
end

return M
