/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.internal.AbstractNativeBinarySpec;
import org.gradle.platform.base.LibraryBinarySpec;

public abstract class AbstractNativeLibraryBinarySpec
extends AbstractNativeBinarySpec
implements LibraryBinarySpec {
    @Override
    public NativeLibrarySpec getComponent() {
        return (NativeLibrarySpec)this.getComponentAs(NativeLibrarySpec.class);
    }

    public NativeLibrarySpec getLibrary() {
        return (NativeLibrarySpec)this.getComponentAs(NativeLibrarySpec.class);
    }

    protected boolean hasSources() {
        for (LanguageSourceSet sourceSet : this.getInputs()) {
            if (!sourceSet.getSource().isEmpty()) {
                return true;
            }
            if (!sourceSet.hasBuildDependencies()) continue;
            return true;
        }
        return false;
    }

    public FileCollection getHeaderDirs() {
        return this.getFileCollectionFactory().create((MinimalFileSet)new HeaderFileSet());
    }

    private class HeaderFileSet
    implements MinimalFileSet,
    Buildable {
        private HeaderFileSet() {
        }

        public String getDisplayName() {
            return "Headers for " + AbstractNativeLibraryBinarySpec.this.getDisplayName();
        }

        public Set<File> getFiles() {
            LinkedHashSet<File> headerDirs = new LinkedHashSet<File>();
            for (HeaderExportingSourceSet sourceSet : AbstractNativeLibraryBinarySpec.this.getInputs().withType(HeaderExportingSourceSet.class)) {
                headerDirs.addAll(sourceSet.getExportedHeaders().getSrcDirs());
            }
            return headerDirs;
        }

        public TaskDependency getBuildDependencies() {
            DefaultTaskDependency dependency = new DefaultTaskDependency();
            for (HeaderExportingSourceSet sourceSet : AbstractNativeLibraryBinarySpec.this.getInputs().withType(HeaderExportingSourceSet.class)) {
                dependency.add(new Object[]{sourceSet.getBuildDependencies()});
            }
            return dependency;
        }
    }

    protected abstract class LibraryOutputs
    implements MinimalFileSet,
    Buildable {
        protected LibraryOutputs() {
        }

        public final Set<File> getFiles() {
            if (this.hasOutputs()) {
                return this.getOutputs();
            }
            return Collections.emptySet();
        }

        public final TaskDependency getBuildDependencies() {
            if (this.hasOutputs()) {
                return AbstractNativeLibraryBinarySpec.this.getBuildDependencies();
            }
            return new DefaultTaskDependency();
        }

        protected abstract boolean hasOutputs();

        protected abstract Set<File> getOutputs();
    }
}

