/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.util.Path;

public class AggregateMultiProjectTaskReportModel
implements TaskReportModel {
    private List<TaskReportModel> projects = new ArrayList<TaskReportModel>();
    private SetMultimap<String, TaskDetails> groups;
    private final boolean mergeTasksWithSameName;

    public AggregateMultiProjectTaskReportModel(boolean mergeTasksWithSameName) {
        this.mergeTasksWithSameName = mergeTasksWithSameName;
    }

    public void add(TaskReportModel project) {
        this.projects.add(project);
    }

    public void build() {
        this.groups = TreeMultimap.create((Comparator)new Comparator<String>(){

            @Override
            public int compare(String string1, String string2) {
                return string1.compareToIgnoreCase(string2);
            }
        }, (Comparator)new Comparator<TaskDetails>(){

            @Override
            public int compare(TaskDetails task1, TaskDetails task2) {
                return task1.getPath().compareTo(task2.getPath());
            }
        });
        for (TaskReportModel project : this.projects) {
            for (String group : project.getGroups()) {
                for (TaskDetails task : project.getTasksForGroup(group)) {
                    this.groups.put((Object)group, (Object)(this.mergeTasksWithSameName ? new MergedTaskDetails(task) : task));
                }
            }
        }
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        return this.groups.get((Object)group);
    }

    private static class MergedTaskDetails
    implements TaskDetails {
        private final TaskDetails task;

        public MergedTaskDetails(TaskDetails task) {
            this.task = task;
        }

        @Override
        public Path getPath() {
            return Path.path((String)this.task.getPath().getName());
        }

        @Override
        public Set<TaskDetails> getChildren() {
            return this.task.getChildren();
        }

        @Override
        public String getDescription() {
            return this.task.getDescription();
        }

        @Override
        public Set<TaskDetails> getDependencies() {
            return this.task.getDependencies();
        }
    }
}

