/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeAliasDeserializer {
    private final DeserializationComponents components;

    @Nullable
    public final TypeAliasDescriptor deserializeTypeAlias(@NotNull ClassId typeAliasId) {
        MemberScope memberScope2;
        Intrinsics.checkParameterIsNotNull((Object)typeAliasId, (String)"typeAliasId");
        if (typeAliasId.isNestedClass()) {
            ClassDeserializer classDeserializer = this.components.getClassDeserializer();
            ClassId classId = typeAliasId.getOuterClassId();
            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"typeAliasId.outerClassId");
            ClassDescriptor classDescriptor = ClassDeserializer.deserializeClass$default(classDeserializer, classId, null, 2, null);
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor outerClass = classDescriptor;
            memberScope2 = outerClass.getUnsubstitutedMemberScope();
        } else {
            PackageFragmentProvider packageFragmentProvider = this.components.getPackageFragmentProvider();
            FqName fqName2 = typeAliasId.getPackageFqName();
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"typeAliasId.packageFqName");
            PackageFragmentDescriptor packageFragment = (PackageFragmentDescriptor)CollectionsKt.single(packageFragmentProvider.getPackageFragments(fqName2));
            memberScope2 = packageFragment.getMemberScope();
        }
        MemberScope parentScope = memberScope2;
        Name name = typeAliasId.getShortClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"typeAliasId.shortClassName");
        ClassifierDescriptor classifierDescriptor = parentScope.getContributedClassifier(name, NoLookupLocation.FROM_DESERIALIZATION);
        if (!(classifierDescriptor instanceof TypeAliasDescriptor)) {
            classifierDescriptor = null;
        }
        return (TypeAliasDescriptor)classifierDescriptor;
    }

    public TypeAliasDeserializer(@NotNull DeserializationComponents components) {
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        this.components = components;
    }
}

