/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex.remote;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class RemoteInfo
implements Writeable {
    private final String scheme;
    private final String host;
    private final int port;
    private final BytesReference query;
    private final String username;
    private final String password;
    private final Map<String, String> headers;

    public RemoteInfo(String scheme, String host, int port, BytesReference query, String username, String password, Map<String, String> headers) {
        this.scheme = Objects.requireNonNull(scheme, "[scheme] must be specified to reindex from a remote cluster");
        this.host = Objects.requireNonNull(host, "[host] must be specified to reindex from a remote cluster");
        this.port = port;
        this.query = Objects.requireNonNull(query, "[query] must be specified to reindex from a remote cluster");
        this.username = username;
        this.password = password;
        this.headers = Collections.unmodifiableMap(Objects.requireNonNull(headers, "[headers] is required"));
    }

    public RemoteInfo(StreamInput in) throws IOException {
        this.scheme = in.readString();
        this.host = in.readString();
        this.port = in.readVInt();
        this.query = in.readBytesReference();
        this.username = in.readOptionalString();
        this.password = in.readOptionalString();
        int headersLength = in.readVInt();
        HashMap<String, String> headers = new HashMap<String, String>(headersLength);
        for (int i = 0; i < headersLength; ++i) {
            headers.put(in.readString(), in.readString());
        }
        this.headers = Collections.unmodifiableMap(headers);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.scheme);
        out.writeString(this.host);
        out.writeVInt(this.port);
        out.writeBytesReference(this.query);
        out.writeOptionalString(this.username);
        out.writeOptionalString(this.password);
        out.writeVInt(this.headers.size());
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            out.writeString(header.getKey());
            out.writeString(header.getValue());
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public BytesReference getQuery() {
        return this.query;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!"http".equals(this.scheme)) {
            b.append("scheme=").append(this.scheme).append(' ');
        }
        b.append("host=").append(this.host).append(" port=").append(this.port).append(" query=").append(this.query.utf8ToString());
        if (this.username != null) {
            b.append(" username=").append(this.username);
        }
        if (this.password != null) {
            b.append(" password=<<>>");
        }
        return b.toString();
    }
}

