/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import java.net.InetSocketAddress;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty3.Netty3Transport;
import org.elasticsearch.transport.netty3.Netty3Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.WriteCompletionEvent;

class Netty3MessageChannelHandler
extends SimpleChannelUpstreamHandler {
    protected final TransportServiceAdapter transportServiceAdapter;
    protected final Netty3Transport transport;
    protected final String profileName;

    Netty3MessageChannelHandler(Netty3Transport transport, String profileName) {
        this.transportServiceAdapter = transport.transportServiceAdapter();
        this.transport = transport;
        this.profileName = profileName;
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        this.transportServiceAdapter.addBytesSent(e.getWrittenAmount());
        super.writeComplete(ctx, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Transports.assertTransportThread();
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream((ChannelEvent)e);
            return;
        }
        ChannelBuffer buffer = (ChannelBuffer)m;
        int remainingMessageSize = buffer.getInt(buffer.readerIndex() - 4);
        int expectedReaderIndex = buffer.readerIndex() + remainingMessageSize;
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.getChannel().getRemoteAddress();
        try {
            BytesReference reference = Netty3Utils.toBytesReference(buffer, remainingMessageSize);
            this.transport.messageReceived(reference, ctx.getChannel(), this.profileName, remoteAddress, remainingMessageSize);
        }
        finally {
            buffer.readerIndex(expectedReaderIndex);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Netty3Utils.maybeDie(e.getCause());
        this.transport.exceptionCaught(ctx, e);
    }
}

