/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWithinQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanWithinQueryBuilder
extends AbstractQueryBuilder<SpanWithinQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_within";
    private static final ParseField BIG_FIELD = new ParseField("big", new String[0]);
    private static final ParseField LITTLE_FIELD = new ParseField("little", new String[0]);
    private final SpanQueryBuilder big;
    private final SpanQueryBuilder little;

    public SpanWithinQueryBuilder(SpanQueryBuilder big, SpanQueryBuilder little) {
        if (big == null) {
            throw new IllegalArgumentException("inner clause [big] cannot be null.");
        }
        if (little == null) {
            throw new IllegalArgumentException("inner clause [little] cannot be null.");
        }
        this.little = little;
        this.big = big;
    }

    public SpanWithinQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.big = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.little = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.big);
        out.writeNamedWriteable(this.little);
    }

    public SpanQueryBuilder littleQuery() {
        return this.little;
    }

    public SpanQueryBuilder bigQuery() {
        return this.big;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(BIG_FIELD.getPreferredName());
        this.big.toXContent(builder, params);
        builder.field(LITTLE_FIELD.getPreferredName());
        this.little.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<SpanWithinQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        Optional<QueryBuilder> query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        String queryName = null;
        SpanQueryBuilder big = null;
        SpanQueryBuilder little = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseContext.getParseFieldMatcher().match(currentFieldName, BIG_FIELD)) {
                    query = parseContext.parseInnerQueryBuilder();
                    if (!query.isPresent() || !(query.get() instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "span_within [big] must be of type span query", new Object[0]);
                    }
                    big = (SpanQueryBuilder)query.get();
                    continue;
                }
                if (parseContext.getParseFieldMatcher().match(currentFieldName, LITTLE_FIELD)) {
                    query = parseContext.parseInnerQueryBuilder();
                    if (!query.isPresent() || !(query.get() instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "span_within [little] must be of type span query", new Object[0]);
                    }
                    little = (SpanQueryBuilder)query.get();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_within] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                boost = parser.floatValue();
                continue;
            }
            if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_within] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (big == null) {
            throw new ParsingException(parser.getTokenLocation(), "span_within must include [big]", new Object[0]);
        }
        if (little == null) {
            throw new ParsingException(parser.getTokenLocation(), "span_within must include [little]", new Object[0]);
        }
        query = new SpanWithinQueryBuilder(big, little);
        ((SpanWithinQueryBuilder)((AbstractQueryBuilder)((Object)query)).boost(boost)).queryName(queryName);
        return Optional.of(query);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query innerBig = this.big.toQuery(context);
        assert (innerBig instanceof SpanQuery);
        Query innerLittle = this.little.toQuery(context);
        assert (innerLittle instanceof SpanQuery);
        return new SpanWithinQuery((SpanQuery)innerBig, (SpanQuery)innerLittle);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.big, this.little);
    }

    @Override
    protected boolean doEquals(SpanWithinQueryBuilder other) {
        return Objects.equals(this.big, other.big) && Objects.equals(this.little, other.little);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

