/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestPutStoredScriptAction
extends BaseRestHandler {
    @Inject
    public RestPutStoredScriptAction(Settings settings, RestController controller) {
        this(settings, controller, true);
    }

    protected RestPutStoredScriptAction(Settings settings, RestController controller, boolean registerDefaultHandlers) {
        super(settings);
        if (registerDefaultHandlers) {
            controller.registerHandler(RestRequest.Method.POST, "/_scripts/{lang}/{id}", this);
            controller.registerHandler(RestRequest.Method.PUT, "/_scripts/{lang}/{id}", this);
        }
    }

    protected String getScriptLang(RestRequest request) {
        return request.param("lang");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutStoredScriptRequest putRequest = new PutStoredScriptRequest(this.getScriptLang(request), request.param("id"));
        putRequest.script(request.content());
        return channel -> client.admin().cluster().putStoredScript(putRequest, new AcknowledgedRestListener<PutStoredScriptResponse>(channel));
    }
}

