/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestActionListener;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolStats;

public class RestThreadPoolAction
extends AbstractCatAction {
    private static final Set<String> RESPONSE_PARAMS;

    @Inject
    public RestThreadPoolAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/thread_pool", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/thread_pool/{thread_pool_patterns}", this);
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/thread_pool\n");
        sb.append("/_cat/thread_pool/{thread_pools}");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, final NodeClient client) {
        ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
        clusterStateRequest.clear().nodes(true);
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().state(clusterStateRequest, (ActionListener<ClusterStateResponse>)new RestActionListener<ClusterStateResponse>(channel){

            @Override
            public void processResponse(final ClusterStateResponse clusterStateResponse) {
                NodesInfoRequest nodesInfoRequest = new NodesInfoRequest();
                nodesInfoRequest.clear().process(true).threadPool(true);
                client.admin().cluster().nodesInfo(nodesInfoRequest, (ActionListener<NodesInfoResponse>)new RestActionListener<NodesInfoResponse>(this.channel){

                    @Override
                    public void processResponse(final NodesInfoResponse nodesInfoResponse) {
                        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest();
                        nodesStatsRequest.clear().threadPool(true);
                        client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener<NodesStatsResponse>)new RestResponseListener<NodesStatsResponse>(this.channel){

                            @Override
                            public RestResponse buildResponse(NodesStatsResponse nodesStatsResponse) throws Exception {
                                return RestTable.buildResponse(RestThreadPoolAction.this.buildTable(request, clusterStateResponse, nodesInfoResponse, nodesStatsResponse), this.channel);
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("node_name", "default:true;alias:nn;desc:node name");
        table.addCell("node_id", "default:false;alias:id;desc:persistent node id");
        table.addCell("ephemeral_node_id", "default:false;alias:eid;desc:ephemeral node id");
        table.addCell("pid", "default:false;alias:p;desc:process id");
        table.addCell("host", "default:false;alias:h;desc:host name");
        table.addCell("ip", "default:false;alias:i;desc:ip address");
        table.addCell("port", "default:false;alias:po;desc:bound transport port");
        table.addCell("name", "default:true;alias:n;desc:thread pool name");
        table.addCell("type", "alias:t;default:false;desc:thread pool type");
        table.addCell("active", "alias:a;default:true;text-align:right;desc:number of active threads");
        table.addCell("size", "alias:s;default:false;text-align:right;desc:number of threads");
        table.addCell("queue", "alias:q;default:true;text-align:right;desc:number of tasks currently in queue");
        table.addCell("queue_size", "alias:qs;default:false;text-align:right;desc:maximum number of tasks permitted in queue");
        table.addCell("rejected", "alias:r;default:true;text-align:right;desc:number of rejected tasks");
        table.addCell("largest", "alias:l;default:false;text-align:right;desc:highest number of seen active threads");
        table.addCell("completed", "alias:c;default:false;text-align:right;desc:number of completed tasks");
        table.addCell("min", "alias:mi;default:false;text-align:right;desc:minimum number of threads");
        table.addCell("max", "alias:ma;default:false;text-align:right;desc:maximum number of threads");
        table.addCell("keep_alive", "alias:ka;default:false;text-align:right;desc:thread keep alive time");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest req, ClusterStateResponse state, NodesInfoResponse nodesInfo, NodesStatsResponse nodesStats) {
        String[] threadPools = req.paramAsStringArray("thread_pool_patterns", new String[]{"*"});
        DiscoveryNodes nodes = state.getState().nodes();
        Table table = this.getTableWithHeader(req);
        HashSet<String> candidates = new HashSet<String>();
        for (NodeStats nodeStats : nodesStats.getNodes()) {
            for (ThreadPoolStats.Stats threadPoolStats : nodeStats.getThreadPool()) {
                candidates.add(threadPoolStats.getName());
            }
        }
        HashSet<String> included = new HashSet<String>();
        for (String candidate : candidates) {
            if (!Regex.simpleMatch(threadPools, candidate)) continue;
            included.add(candidate);
        }
        for (DiscoveryNode node : nodes) {
            Map<String, ThreadPool.Info> poolThreadInfo;
            Map<String, ThreadPoolStats.Stats> poolThreadStats;
            NodeInfo info = (NodeInfo)nodesInfo.getNodesMap().get(node.getId());
            NodeStats stats = (NodeStats)nodesStats.getNodesMap().get(node.getId());
            if (stats == null) {
                poolThreadStats = Collections.emptyMap();
                poolThreadInfo = Collections.emptyMap();
            } else {
                poolThreadStats = new TreeMap();
                poolThreadInfo = new HashMap();
                ThreadPoolStats threadPoolStats = stats.getThreadPool();
                for (ThreadPoolStats.Stats threadPoolStat : threadPoolStats) {
                    poolThreadStats.put(threadPoolStat.getName(), threadPoolStat);
                }
                if (info != null) {
                    for (ThreadPool.Info threadPoolInfo : info.getThreadPool()) {
                        poolThreadInfo.put(threadPoolInfo.getName(), threadPoolInfo);
                    }
                }
            }
            for (Map.Entry entry : poolThreadStats.entrySet()) {
                if (!included.contains(entry.getKey())) continue;
                table.startRow();
                table.addCell(node.getName());
                table.addCell(node.getId());
                table.addCell(node.getEphemeralId());
                table.addCell(info == null ? null : Long.valueOf(info.getProcess().getId()));
                table.addCell(node.getHostName());
                table.addCell(node.getHostAddress());
                if (node.getAddress() instanceof InetSocketTransportAddress) {
                    table.addCell(((InetSocketTransportAddress)node.getAddress()).address().getPort());
                } else {
                    table.addCell("-");
                }
                ThreadPoolStats.Stats poolStats = (ThreadPoolStats.Stats)entry.getValue();
                ThreadPool.Info poolInfo = (ThreadPool.Info)poolThreadInfo.get(entry.getKey());
                Long maxQueueSize = null;
                String keepAlive = null;
                Integer minThreads = null;
                Integer maxThreads = null;
                if (poolInfo != null) {
                    if (poolInfo.getQueueSize() != null) {
                        maxQueueSize = poolInfo.getQueueSize().singles();
                    }
                    if (poolInfo.getKeepAlive() != null) {
                        keepAlive = poolInfo.getKeepAlive().toString();
                    }
                    if (poolInfo.getMin() >= 0) {
                        minThreads = poolInfo.getMin();
                    }
                    if (poolInfo.getMax() >= 0) {
                        maxThreads = poolInfo.getMax();
                    }
                }
                table.addCell(entry.getKey());
                table.addCell(poolInfo == null ? null : poolInfo.getThreadPoolType().getType());
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getActive()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getThreads()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getQueue()));
                table.addCell(maxQueueSize);
                table.addCell(poolStats == null ? null : Long.valueOf(poolStats.getRejected()));
                table.addCell(poolStats == null ? null : Integer.valueOf(poolStats.getLargest()));
                table.addCell(poolStats == null ? null : Long.valueOf(poolStats.getCompleted()));
                table.addCell(minThreads);
                table.addCell(maxThreads);
                table.addCell(keepAlive);
                table.endRow();
            }
        }
        return table;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>();
        responseParams.addAll(AbstractCatAction.RESPONSE_PARAMS);
        responseParams.add("thread_pool_patterns");
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

