/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.BitSet;
import java.util.Map;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.search.lookup.LeafDocLookup;

public abstract class Executable {
    private final String name;
    private final String source;
    private final BitSet statements;

    public Executable(String name, String source, BitSet statements) {
        this.name = name;
        this.source = source;
        this.statements = statements;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public int getPreviousStatement(int offset) {
        return this.statements.previousSetBit(offset);
    }

    public int getNextStatement(int offset) {
        return this.statements.nextSetBit(offset + 1);
    }

    public abstract Object execute(Map<String, Object> var1, Scorer var2, LeafDocLookup var3, Object var4);
}

