/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.multislider.TrackRenderer;
import org.jdesktop.swingx.plaf.MultiThumbSliderUI;

public class BasicMultiThumbSliderUI
extends MultiThumbSliderUI {
    protected JXMultiThumbSlider<?> slider;

    public static ComponentUI createUI(JComponent c) {
        return new BasicMultiThumbSliderUI();
    }

    public void installUI(JComponent c) {
        this.slider = (JXMultiThumbSlider)c;
        this.slider.setThumbRenderer(new BasicThumbRenderer());
        this.slider.setTrackRenderer(new BasicTrackRenderer());
    }

    public void uninstallUI(JComponent c) {
        this.slider = null;
    }

    private class BasicTrackRenderer
    extends JComponent
    implements TrackRenderer {
        private JXMultiThumbSlider<?> slider;

        private BasicTrackRenderer() {
        }

        public void paintComponent(Graphics g) {
            g.setColor(this.slider.getBackground());
            g.fillRect(0, 0, this.slider.getWidth(), this.slider.getHeight());
            g.setColor(Color.black);
            g.drawLine(0, this.slider.getHeight() / 2, this.slider.getWidth(), this.slider.getHeight() / 2);
            g.drawLine(0, this.slider.getHeight() / 2 + 1, this.slider.getWidth(), this.slider.getHeight() / 2 + 1);
        }

        public JComponent getRendererComponent(JXMultiThumbSlider slider) {
            this.slider = slider;
            return this;
        }
    }

    private class BasicThumbRenderer
    extends JComponent
    implements ThumbRenderer {
        public BasicThumbRenderer() {
            this.setPreferredSize(new Dimension(14, 14));
        }

        protected void paintComponent(Graphics g) {
            g.setColor(Color.green);
            Polygon poly = new Polygon();
            BasicThumbRenderer thumb = this;
            poly.addPoint(thumb.getWidth() / 2, 0);
            poly.addPoint(0, thumb.getHeight() / 2);
            poly.addPoint(thumb.getWidth() / 2, thumb.getHeight());
            poly.addPoint(thumb.getWidth(), thumb.getHeight() / 2);
            g.fillPolygon(poly);
        }

        public JComponent getThumbRendererComponent(JXMultiThumbSlider slider, int index, boolean selected) {
            return this;
        }
    }
}

