/*
 * Decompiled with CFR 0.152.
 */
package esmska.utils;

import esmska.gui.ThemeManager;
import esmska.integration.IntegrationAdapter;
import java.awt.Dialog;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class RuntimeUtils {
    private static String vendor = StringUtils.defaultString(System.getProperty("java.vendor"));
    private static String vm = StringUtils.defaultString(System.getProperty("java.vm.name"));
    private static final Logger logger = Logger.getLogger(RuntimeUtils.class.getName());

    public static OSType detectOS() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("linux")) {
            return OSType.LINUX;
        }
        if (os.contains("mac os x")) {
            return OSType.MAC_OS_X;
        }
        if (os.contains("windows")) {
            return OSType.WINDOWS;
        }
        return OSType.OTHER;
    }

    public static boolean isLinux() {
        return RuntimeUtils.detectOS() == OSType.LINUX;
    }

    public static boolean isMac() {
        return RuntimeUtils.detectOS() == OSType.MAC_OS_X;
    }

    public static boolean isWindows() {
        return RuntimeUtils.detectOS() == OSType.WINDOWS;
    }

    public static boolean isGnomeDesktop() {
        return System.getenv("GNOME_DESKTOP_SESSION_ID") != null;
    }

    public static boolean isKDEDesktop() {
        return System.getenv("KDE_FULL_SESSION") != null;
    }

    public static boolean isGnome3Desktop() {
        if (!RuntimeUtils.isGnomeDesktop()) {
            return false;
        }
        try {
            Process p = Runtime.getRuntime().exec("which gnome-default-applications-properties");
            p.waitFor();
            if (p.exitValue() != 0 && p.exitValue() != 1) {
                logger.log(Level.WARNING, "''which'' returned an unexpected exit code: {0}", p.exitValue());
            }
            return p.exitValue() != 0;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Can't test whether this is Gnome 3", e);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Can't test whether this is Gnome 3", e);
        }
        return false;
    }

    public static boolean isOracleJava() {
        return (vendor.toLowerCase().contains("sun microsystems") || vendor.toLowerCase().contains("oracle corporation")) && !RuntimeUtils.isOpenJDK();
    }

    public static boolean isOpenJDK() {
        return vm.toLowerCase().contains("openjdk");
    }

    public static boolean isAppleJava() {
        return vendor.toLowerCase().contains("apple");
    }

    public static boolean isSupportedJava() {
        return RuntimeUtils.isOracleJava() || RuntimeUtils.isOpenJDK() || RuntimeUtils.isAppleJava();
    }

    public static String getSystemInfo() {
        String[] props = new String[]{"os.name", "os.version", "os.arch", "user.name", "user.home", "user.dir", "java.version", "java.vendor", "java.vm.name", "java.vm.version"};
        StringBuilder builder = new StringBuilder();
        for (String prop : props) {
            builder.append(prop);
            builder.append("=");
            builder.append(System.getProperty(prop));
            builder.append("; ");
        }
        if (RuntimeUtils.isGnomeDesktop()) {
            builder.append("desktop=GNOME; ");
        } else if (RuntimeUtils.isKDEDesktop()) {
            builder.append("desktop=KDE; ");
        }
        builder.append("language=").append(Locale.getDefault().getLanguage()).append("; ");
        builder.delete(builder.length() - 2, builder.length());
        return builder.toString();
    }

    public static <T> T[] sortDialogOptions(T ... options) {
        Object[] reversed = ArrayUtils.clone(options);
        ArrayUtils.reverse(reversed);
        if (RuntimeUtils.isWindows()) {
            return reversed;
        }
        if (RuntimeUtils.isKDEDesktop() && !ThemeManager.isGTKCurrentLaF() && !ThemeManager.isNimbusCurrentLaF()) {
            return reversed;
        }
        if (ThemeManager.isGTKCurrentLaF() && !RuntimeUtils.isKDEDesktop()) {
            return reversed;
        }
        if (ThemeManager.isAquaCurrentLaF()) {
            return reversed;
        }
        if (ThemeManager.isNimbusCurrentLaF() && !RuntimeUtils.isKDEDesktop()) {
            return reversed;
        }
        return options;
    }

    public static <T> T[] sortOptions(T ... options) {
        if (RuntimeUtils.isWindows() || RuntimeUtils.isKDEDesktop()) {
            Object[] reversed = ArrayUtils.clone(options);
            ArrayUtils.reverse(reversed);
            return reversed;
        }
        return options;
    }

    public static void setDocumentModalDialog(JDialog dialog) {
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.getRootPane().putClientProperty("apple.awt.documentModalSheet", Boolean.TRUE);
        IntegrationAdapter.getInstance().registerModalSheet(dialog);
    }

    public static enum OSType {
        LINUX,
        MAC_OS_X,
        WINDOWS,
        OTHER;

    }
}

