/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.networking;

import java.io.IOException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.MessageHandler;
import org.w3c.dom.Element;

public final class DummyConnection
extends Connection {
    private MessageHandler outgoingMessageHandler;
    private DummyConnection otherConnection;

    public DummyConnection(String name, MessageHandler incomingMessageHandler) {
        super(name);
        this.setMessageHandler(incomingMessageHandler);
    }

    private void setOutgoingMessageHandler(MessageHandler mh) {
        this.outgoingMessageHandler = mh;
    }

    public void setConnection(DummyConnection dc) {
        this.otherConnection = dc;
        this.setOutgoingMessageHandler(dc.getMessageHandler());
    }

    public DummyConnection getOtherConnection() {
        return this.otherConnection;
    }

    @Override
    public void close() {
    }

    @Override
    public void send(Element element) throws IOException {
        try {
            this.outgoingMessageHandler.handle(this.getOtherConnection(), element);
            this.log(element, true);
        }
        catch (FreeColException freeColException) {
            // empty catch block
        }
    }

    @Override
    public void sendAndWait(Element element) throws IOException {
        this.send(element);
    }

    @Override
    public Element ask(Element request) throws IOException {
        Element reply;
        try {
            this.log(request, true);
            reply = this.outgoingMessageHandler.handle(this.getOtherConnection(), request);
            this.log(reply, false);
        }
        catch (FreeColException e) {
            reply = null;
        }
        return reply;
    }

    @Override
    public String toString() {
        return "[DummyConnection " + this.getName() + "]";
    }
}

