/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.IdentityObjectIntMap;
import com.esotericsoftware.kryo.util.IntMap;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;

public class DefaultClassResolver
implements ClassResolver {
    public static final byte NAME = -1;
    protected Kryo kryo;
    protected final IntMap<Registration> idToRegistration = new IntMap();
    protected final ObjectMap<Class, Registration> classToRegistration = new ObjectMap();
    protected IdentityObjectIntMap<Class> classToNameId;
    protected IntMap<Class> nameIdToClass;
    protected ObjectMap<String, Class> nameToClass;
    protected int nextNameId;
    private int memoizedClassId = -1;
    private Registration memoizedClassIdValue;

    public void setKryo(Kryo kryo) {
        this.kryo = kryo;
    }

    public Registration register(Registration registration) {
        if (registration == null) {
            throw new IllegalArgumentException("registration cannot be null.");
        }
        if (Log.TRACE) {
            if (registration.getId() == -1) {
                Log.trace((String)"kryo", (String)("Register class name: " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")"));
            } else {
                Log.trace((String)"kryo", (String)("Register class ID " + registration.getId() + ": " + Util.className(registration.getType()) + " (" + registration.getSerializer().getClass().getName() + ")"));
            }
        }
        this.classToRegistration.put(registration.getType(), registration);
        this.idToRegistration.put(registration.getId(), registration);
        if (registration.getType().isPrimitive()) {
            this.classToRegistration.put(Util.getWrapperClass(registration.getType()), registration);
        }
        return registration;
    }

    public Registration registerImplicit(Class type) {
        return this.register(new Registration(type, this.kryo.getDefaultSerializer(type), -1));
    }

    public Registration getRegistration(Class type) {
        return this.classToRegistration.get(type);
    }

    public Registration getRegistration(int classID) {
        return this.idToRegistration.get(classID);
    }

    public Registration writeClass(Output output, Class type) {
        if (type == null) {
            if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                Util.log("Write", null);
            }
            output.writeByte((byte)0);
            return null;
        }
        Registration registration = this.kryo.getRegistration(type);
        if (registration.getId() == -1) {
            this.writeName(output, type, registration);
        } else {
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Write class " + registration.getId() + ": " + Util.className(type)));
            }
            output.writeInt(registration.getId() + 2, true);
        }
        return registration;
    }

    protected void writeName(Output output, Class type, Registration registration) {
        int nameId;
        output.writeByte(1);
        if (this.classToNameId != null && (nameId = this.classToNameId.get(type, -1)) != -1) {
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Write class name reference " + nameId + ": " + Util.className(type)));
            }
            output.writeInt(nameId, true);
            return;
        }
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Write class name: " + Util.className(type)));
        }
        nameId = this.nextNameId++;
        if (this.classToNameId == null) {
            this.classToNameId = new IdentityObjectIntMap();
        }
        this.classToNameId.put(type, nameId);
        output.write(nameId);
        output.writeString(type.getName());
    }

    public Registration readClass(Input input) {
        int classID = input.readInt(true);
        switch (classID) {
            case 0: {
                if (Log.TRACE || Log.DEBUG && this.kryo.getDepth() == 1) {
                    Util.log("Read", null);
                }
                return null;
            }
            case 1: {
                return this.readName(input);
            }
        }
        if (classID == this.memoizedClassId) {
            return this.memoizedClassIdValue;
        }
        Registration registration = this.idToRegistration.get(classID - 2);
        if (registration == null) {
            throw new KryoException("Encountered unregistered class ID: " + (classID - 2));
        }
        if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Read class " + (classID - 2) + ": " + Util.className(registration.getType())));
        }
        this.memoizedClassId = classID;
        this.memoizedClassIdValue = registration;
        return registration;
    }

    protected Registration readName(Input input) {
        Class<?> type;
        int nameId = input.readInt(true);
        if (this.nameIdToClass == null) {
            this.nameIdToClass = new IntMap();
        }
        if ((type = this.nameIdToClass.get(nameId)) == null) {
            String className = input.readString();
            if (this.nameToClass != null) {
                type = this.nameToClass.get(className);
            }
            if (type == null) {
                try {
                    type = Class.forName(className, false, this.kryo.getClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    throw new KryoException("Unable to find class: " + className, ex);
                }
                if (this.nameToClass == null) {
                    this.nameToClass = new ObjectMap();
                }
                this.nameToClass.put(className, type);
            }
            this.nameIdToClass.put(nameId, type);
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)("Read class name: " + className));
            }
        } else if (Log.TRACE) {
            Log.trace((String)"kryo", (String)("Read class name reference " + nameId + ": " + Util.className(type)));
        }
        return this.kryo.getRegistration(type);
    }

    public void reset() {
        if (!this.kryo.isRegistrationRequired()) {
            if (this.classToNameId != null) {
                this.classToNameId.clear();
            }
            if (this.nameIdToClass != null) {
                this.nameIdToClass.clear();
            }
            this.nextNameId = 0;
        }
    }
}

