/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.external.javadoc.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.OptionLessJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.BooleanJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.EnumJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.FileJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.JavadocOptionFileWriter;
import org.gradle.external.javadoc.internal.MultilineStringsJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.OptionLessStringsJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.PathJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.StringJavadocOptionFileOption;
import org.gradle.external.javadoc.internal.StringsJavadocOptionFileOption;

public class JavadocOptionFile {
    private final Map<String, JavadocOptionFileOption<?>> options = new HashMap();
    private final OptionLessJavadocOptionFileOption<List<String>> sourceNames = new OptionLessStringsJavadocOptionFileOption();

    public OptionLessJavadocOptionFileOption<List<String>> getSourceNames() {
        return this.sourceNames;
    }

    Map<String, JavadocOptionFileOption<?>> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public <T> JavadocOptionFileOption<T> addOption(JavadocOptionFileOption<T> option) {
        if (option == null) {
            throw new IllegalArgumentException("option == null!");
        }
        this.options.put(option.getOption(), option);
        return option;
    }

    public JavadocOptionFileOption<String> addStringOption(String option) {
        return this.addStringOption(option, null);
    }

    public JavadocOptionFileOption<String> addStringOption(String option, String value) {
        return this.addOption(new StringJavadocOptionFileOption(option, value));
    }

    public <T> JavadocOptionFileOption<T> addEnumOption(String option) {
        return this.addEnumOption(option, null);
    }

    public <T> JavadocOptionFileOption<T> addEnumOption(String option, T value) {
        return this.addOption(new EnumJavadocOptionFileOption<T>(option, value));
    }

    public JavadocOptionFileOption<List<File>> addPathOption(String option) {
        return this.addPathOption(option, System.getProperty("path.separator"));
    }

    public JavadocOptionFileOption<List<File>> addPathOption(String option, String joinBy) {
        return this.addOption(new PathJavadocOptionFileOption(option, joinBy));
    }

    public JavadocOptionFileOption<List<String>> addStringsOption(String option) {
        return this.addStringsOption(option, System.getProperty("path.separator"));
    }

    public JavadocOptionFileOption<List<String>> addStringsOption(String option, String joinBy) {
        return this.addOption(new StringsJavadocOptionFileOption(option, (List<String>)new ArrayList<String>(), joinBy));
    }

    public JavadocOptionFileOption<List<String>> addMultilineStringsOption(String option) {
        return this.addOption(new MultilineStringsJavadocOptionFileOption(option, (List<String>)new ArrayList<String>()));
    }

    public JavadocOptionFileOption<Boolean> addBooleanOption(String option) {
        return this.addBooleanOption(option, false);
    }

    public JavadocOptionFileOption<Boolean> addBooleanOption(String option, boolean value) {
        return this.addOption(new BooleanJavadocOptionFileOption(option, value));
    }

    public JavadocOptionFileOption<File> addFileOption(String option) {
        return this.addFileOption(option, null);
    }

    public JavadocOptionFileOption<File> addFileOption(String option, File value) {
        return this.addOption(new FileJavadocOptionFileOption(option, value));
    }

    public void write(File optionFile) throws IOException {
        if (optionFile == null) {
            throw new IllegalArgumentException("optionFile == null!");
        }
        JavadocOptionFileWriter optionFileWriter = new JavadocOptionFileWriter(this);
        optionFileWriter.write(optionFile);
    }
}

