// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_ALLOCATOR_H
#define _GSTREAMERMM_ALLOCATOR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2014 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/memory.h>
#include <gstreamermm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _GstAllocationParams GstAllocationParams; }
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstAllocator GstAllocator;
typedef struct _GstAllocatorClass GstAllocatorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Allocator_Class; } // namespace Gst
namespace Gst
{

class AllocationParams
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AllocationParams CppObjectType;
  typedef GstAllocationParams BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit AllocationParams(GstAllocationParams* gobject, bool make_a_copy = true);

  AllocationParams(const AllocationParams& other);
  AllocationParams& operator=(const AllocationParams& other);

  ~AllocationParams();

  void swap(AllocationParams& other);

  ///Provides access to the underlying C instance.
  GstAllocationParams*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const GstAllocationParams* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GstAllocationParams* gobj_copy() const;

protected:
  GstAllocationParams* gobject_;

private:


public:
  

  AllocationParams();

  
  /** Initialize @a params to its default values
   * 
   */
  void init();

   MemoryFlags get_flags() const;
    void set_flags(const MemoryFlags& value);
 
   gsize get_align() const;
    void set_align(const gsize& value);
 
   gsize get_prefix() const;
    void set_prefix(const gsize& value);
 
   gsize get_padding() const;
    void set_padding(const gsize& value);
 

};


class Allocator : public Gst::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Allocator CppObjectType;
  typedef Allocator_Class CppClassType;
  typedef GstAllocator BaseObjectType;
  typedef GstAllocatorClass BaseClassType;

private:  friend class Allocator_Class;
  static CppClassType allocator_class_;

private:
  // noncopyable
  Allocator(const Allocator&);
  Allocator& operator=(const Allocator&);

protected:
  explicit Allocator(const Glib::ConstructParams& construct_params);
  explicit Allocator(GstAllocator* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Allocator();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAllocator*       gobj()       { return reinterpret_cast<GstAllocator*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAllocator* gobj() const { return reinterpret_cast<GstAllocator*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAllocator* gobj_copy();

private:


public:
  /**
   * Find a previously registered allocator with @name.
   *
   * @name: the name of the allocator
   *
   * @return: a #Glib::RefPtr<Gst::Allocator>.
   */
  static Glib::RefPtr<Gst::Allocator> find(const Glib::ustring& name);
  

  /**
   * Registers the memory @allocator with @name.
   *
   * @name: the name of the allocator
   * @allocator: (transfer full): #GstAllocator
   */
  void register_allocator(const Glib::ustring& name);
  

  /**
   * Set the default allocator.
   */
  void set_default();
  

  /**
   * Find default allocator.
   *
   * @return: default allocator.
   */
  static Glib::RefPtr<Gst::Allocator> get_default_allocator();

  /** Free @a memory that was previously allocated with alloc().
   * @param memory The memory to free.
   */
  void free(Glib::RefPtr<Gst::Memory>& memory);
  

  /** Use @a allocator to allocate a new memory block with memory that is at least
   *  @a size big.
   * 
   * The optional @a params can specify the prefix and padding for the memory. If
   * <tt>0</tt> is passed, no flags, no extra prefix/padding and a default alignment is
   * used.
   * 
   * The prefix/padding will be filled with 0 if flags contains
   * Gst::MEMORY_FLAG_ZERO_PREFIXED and Gst::MEMORY_FLAG_ZERO_PADDED respectively.
   * 
   * When @a allocator is <tt>0</tt>, the default allocator will be used.
   * 
   * The alignment in @a params is given as a bitmask so that @a align + 1 equals
   * the amount of bytes to align to. For example, to align to 8 bytes,
   * use an alignment of 7.
   * 
   * @param size Size of the visible memory area.
   * @param params Optional parameters.
   * @return A new Gst::Memory.
   */
  Glib::RefPtr<Gst::Memory> alloc(gsize size, AllocationParams params);
    virtual Glib::RefPtr<Gst::Memory> alloc_vfunc(gsize size, AllocationParams params);


  // This vfunc is hand-coded because it takes reference to a memory.
  // In generally, arguments are passed to a function by copy, so
  // custom wrapper is necessary.
  virtual void free_vfunc(Glib::RefPtr<Gst::Memory>& memory);

protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};
}


namespace Gst
{

/** @relates Gst::AllocationParams
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(AllocationParams& lhs, AllocationParams& rhs)
  { lhs.swap(rhs); }

} // namespace Gst

namespace Glib
{

/** A Glib::wrap() method for this object.
 * 
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gst::AllocationParams
 */
Gst::AllocationParams wrap(GstAllocationParams* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gst::AllocationParams> : public Glib::Value_Boxed<Gst::AllocationParams>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Allocator
   */
  Glib::RefPtr<Gst::Allocator> wrap(GstAllocator* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_ALLOCATOR_H */

