/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.io.MaxChangesetSizeExceededPolicy;
import org.openstreetmap.josm.gui.io.UploadStrategy;
import org.openstreetmap.josm.gui.io.UploadStrategySpecification;
import org.openstreetmap.josm.gui.io.UploadedObjectsSummaryPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;

public class UploadStrategySelectionPanel
extends JPanel
implements PropertyChangeListener {
    public static final String UPLOAD_STRATEGY_SPECIFICATION_PROP = UploadStrategySelectionPanel.class.getName() + ".uploadStrategySpecification";
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    private transient Map<UploadStrategy, JRadioButton> rbStrategy;
    private transient Map<UploadStrategy, JLabel> lblNumRequests;
    private transient Map<UploadStrategy, JMultilineLabel> lblStrategies;
    private final JosmTextField tfChunkSize = new JosmTextField(4);
    private final JPanel pnlMultiChangesetPolicyPanel = new JPanel(new GridBagLayout());
    private final JRadioButton rbFillOneChangeset = new JRadioButton(I18n.tr("Fill up one changeset and return to the Upload Dialog", new Object[0]));
    private final JRadioButton rbUseMultipleChangesets = new JRadioButton(I18n.tr("Open and use as many new changesets as necessary", new Object[0]));
    private JMultilineLabel lblMultiChangesetPoliciesHeader;
    private long numUploadedObjects;

    public UploadStrategySelectionPanel() {
        this.build();
    }

    protected JPanel buildUploadStrategyPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rbStrategy = new EnumMap<UploadStrategy, JRadioButton>(UploadStrategy.class);
        this.lblStrategies = new EnumMap<UploadStrategy, JMultilineLabel>(UploadStrategy.class);
        this.lblNumRequests = new EnumMap<UploadStrategy, JLabel>(UploadStrategy.class);
        for (UploadStrategy uploadStrategy : UploadStrategy.values()) {
            this.rbStrategy.put(uploadStrategy, new JRadioButton());
            this.lblNumRequests.put(uploadStrategy, new JLabel());
            this.lblStrategies.put(uploadStrategy, new JMultilineLabel(""));
            buttonGroup.add(this.rbStrategy.get((Object)uploadStrategy));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)new JMultilineLabel(I18n.tr("Please select the upload strategy:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        JMultilineLabel jMultilineLabel = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
        jMultilineLabel.setText(I18n.tr("Upload data in one request", new Object[0]));
        jPanel.add((Component)jMultilineLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.rbStrategy.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jMultilineLabel = this.lblStrategies.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY);
        jMultilineLabel.setText(I18n.tr("Upload data in chunks of objects. Chunk size: ", new Object[0]));
        jPanel.add((Component)jMultilineLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.tfChunkSize, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this.rbStrategy.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        jMultilineLabel = this.lblStrategies.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY);
        jMultilineLabel.setText(I18n.tr("Upload each object individually", new Object[0]));
        jPanel.add((Component)jMultilineLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY), gridBagConstraints);
        this.tfChunkSize.addFocusListener(new TextFieldFocusHandler());
        this.tfChunkSize.getDocument().addDocumentListener(new ChunkSizeInputVerifier());
        StrategyChangeListener strategyChangeListener = new StrategyChangeListener();
        this.tfChunkSize.addFocusListener(strategyChangeListener);
        this.tfChunkSize.addActionListener(strategyChangeListener);
        for (UploadStrategy uploadStrategy : UploadStrategy.values()) {
            this.rbStrategy.get((Object)uploadStrategy).addItemListener(strategyChangeListener);
        }
        return jPanel;
    }

    protected JPanel buildMultiChangesetPolicyPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        this.lblMultiChangesetPoliciesHeader = new JMultilineLabel(I18n.tr("<html>There are <strong>multiple changesets</strong> necessary in order to upload {0} objects. Which strategy do you want to use?</html>", this.numUploadedObjects));
        this.pnlMultiChangesetPolicyPanel.add((Component)this.lblMultiChangesetPoliciesHeader, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.pnlMultiChangesetPolicyPanel.add((Component)this.rbFillOneChangeset, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.pnlMultiChangesetPolicyPanel.add((Component)this.rbUseMultipleChangesets, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbFillOneChangeset);
        buttonGroup.add(this.rbUseMultipleChangesets);
        return this.pnlMultiChangesetPolicyPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.buildUploadStrategyPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add((Component)this.buildMultiChangesetPolicyPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JPanel(), gridBagConstraints);
        Capabilities capabilities = OsmApi.getOsmApi().getCapabilities();
        int n = capabilities != null ? capabilities.getMaxChangesetSize() : -1;
        this.pnlMultiChangesetPolicyPanel.setVisible(n > 0 && this.numUploadedObjects > (long)n);
    }

    public void setNumUploadedObjects(int n) {
        this.numUploadedObjects = Math.max(n, 0);
        this.updateNumRequestsLabels();
    }

    public void setUploadStrategySpecification(UploadStrategySpecification uploadStrategySpecification) {
        if (uploadStrategySpecification == null) {
            return;
        }
        this.rbStrategy.get((Object)uploadStrategySpecification.getStrategy()).setSelected(true);
        this.tfChunkSize.setEnabled(uploadStrategySpecification.getStrategy() == UploadStrategy.CHUNKED_DATASET_STRATEGY);
        if (uploadStrategySpecification.getStrategy().equals((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY)) {
            if (uploadStrategySpecification.getChunkSize() != -1) {
                this.tfChunkSize.setText(Integer.toString(uploadStrategySpecification.getChunkSize()));
            } else {
                this.tfChunkSize.setText("1");
            }
        }
    }

    public UploadStrategySpecification getUploadStrategySpecification() {
        UploadStrategy uploadStrategy = this.getUploadStrategy();
        UploadStrategySpecification uploadStrategySpecification = new UploadStrategySpecification();
        if (uploadStrategy != null) {
            switch (uploadStrategy) {
                case CHUNKED_DATASET_STRATEGY: {
                    uploadStrategySpecification.setStrategy(uploadStrategy).setChunkSize(this.getChunkSize());
                    break;
                }
                default: {
                    uploadStrategySpecification.setStrategy(uploadStrategy);
                }
            }
        }
        if (this.pnlMultiChangesetPolicyPanel.isVisible()) {
            if (this.rbFillOneChangeset.isSelected()) {
                uploadStrategySpecification.setPolicy(MaxChangesetSizeExceededPolicy.FILL_ONE_CHANGESET_AND_RETURN_TO_UPLOAD_DIALOG);
            } else if (this.rbUseMultipleChangesets.isSelected()) {
                uploadStrategySpecification.setPolicy(MaxChangesetSizeExceededPolicy.AUTOMATICALLY_OPEN_NEW_CHANGESETS);
            } else {
                uploadStrategySpecification.setPolicy(null);
            }
        } else {
            uploadStrategySpecification.setPolicy(null);
        }
        return uploadStrategySpecification;
    }

    protected UploadStrategy getUploadStrategy() {
        UploadStrategy uploadStrategy = null;
        for (Map.Entry<UploadStrategy, JRadioButton> entry : this.rbStrategy.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            uploadStrategy = entry.getKey();
            break;
        }
        return uploadStrategy;
    }

    protected int getChunkSize() {
        try {
            return Integer.parseInt(this.tfChunkSize.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void initFromPreferences() {
        UploadStrategy uploadStrategy = UploadStrategy.getFromPreferences();
        this.rbStrategy.get((Object)uploadStrategy).setSelected(true);
        int n = Main.pref.getInteger("osm-server.upload-strategy.chunk-size", 1);
        this.tfChunkSize.setText(Integer.toString(n));
        this.updateNumRequestsLabels();
    }

    public void rememberUserInput() {
        UploadStrategy uploadStrategy = this.getUploadStrategy();
        UploadStrategy.saveToPreferences(uploadStrategy);
        try {
            int n = Integer.parseInt(this.tfChunkSize.getText().trim());
            Main.pref.putInteger("osm-server.upload-strategy.chunk-size", n);
        }
        catch (NumberFormatException numberFormatException) {
            Main.trace(numberFormatException);
        }
    }

    protected void updateNumRequestsLabels() {
        JMultilineLabel jMultilineLabel;
        int n = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
        if (n > 0 && this.numUploadedObjects > (long)n) {
            this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setEnabled(false);
            jMultilineLabel = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
            jMultilineLabel.setText(I18n.tr("Upload in one request not possible (too many objects to upload)", new Object[0]));
            jMultilineLabel.setToolTipText(I18n.tr("<html>Cannot upload {0} objects in one request because the<br>max. changeset size {1} on server ''{2}'' is exceeded.</html>", this.numUploadedObjects, n, OsmApi.getOsmApi().getBaseUrl()));
            this.rbStrategy.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setSelected(true);
            this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setVisible(false);
            this.lblMultiChangesetPoliciesHeader.setText(I18n.tr("<html>There are <strong>multiple changesets</strong> necessary in order to upload {0} objects. Which strategy do you want to use?</html>", this.numUploadedObjects));
            if (!this.rbFillOneChangeset.isSelected() && !this.rbUseMultipleChangesets.isSelected()) {
                this.rbUseMultipleChangesets.setSelected(true);
            }
            this.pnlMultiChangesetPolicyPanel.setVisible(true);
        } else {
            this.rbStrategy.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setEnabled(true);
            jMultilineLabel = this.lblStrategies.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY);
            jMultilineLabel.setText(I18n.tr("Upload data in one request", new Object[0]));
            jMultilineLabel.setToolTipText(null);
            this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setVisible(true);
            this.pnlMultiChangesetPolicyPanel.setVisible(false);
        }
        this.lblNumRequests.get((Object)UploadStrategy.SINGLE_REQUEST_STRATEGY).setText(I18n.tr("(1 request)", new Object[0]));
        if (this.numUploadedObjects == 0L) {
            this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY).setText(I18n.tr("(# requests unknown)", new Object[0]));
            this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)", new Object[0]));
        } else {
            this.lblNumRequests.get((Object)UploadStrategy.INDIVIDUAL_OBJECTS_STRATEGY).setText(I18n.trn("({0} request)", "({0} requests)", this.numUploadedObjects, this.numUploadedObjects));
            this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)", new Object[0]));
            int n2 = this.getChunkSize();
            if (n2 == -1) {
                this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.tr("(# requests unknown)", new Object[0]));
            } else {
                int n3 = (int)Math.ceil((double)this.numUploadedObjects / (double)n2);
                this.lblNumRequests.get((Object)UploadStrategy.CHUNKED_DATASET_STRATEGY).setText(I18n.trn("({0} request)", "({0} requests)", n3, n3));
            }
        }
    }

    public void initEditingOfChunkSize() {
        this.tfChunkSize.requestFocusInWindow();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(UploadedObjectsSummaryPanel.NUM_OBJECTS_TO_UPLOAD_PROP)) {
            this.setNumUploadedObjects((Integer)propertyChangeEvent.getNewValue());
        }
    }

    class StrategyChangeListener
    extends FocusAdapter
    implements ItemListener,
    ActionListener {
        StrategyChangeListener() {
        }

        protected void notifyStrategy() {
            UploadStrategySelectionPanel.this.firePropertyChange(UPLOAD_STRATEGY_SPECIFICATION_PROP, null, UploadStrategySelectionPanel.this.getUploadStrategySpecification());
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            UploadStrategy uploadStrategy = UploadStrategySelectionPanel.this.getUploadStrategy();
            if (uploadStrategy == null) {
                return;
            }
            switch (uploadStrategy) {
                case CHUNKED_DATASET_STRATEGY: {
                    UploadStrategySelectionPanel.this.tfChunkSize.setEnabled(true);
                    UploadStrategySelectionPanel.this.tfChunkSize.requestFocusInWindow();
                    break;
                }
                default: {
                    UploadStrategySelectionPanel.this.tfChunkSize.setEnabled(false);
                }
            }
            this.notifyStrategy();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.notifyStrategy();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.notifyStrategy();
        }
    }

    class ChunkSizeInputVerifier
    implements DocumentListener,
    PropertyChangeListener {
        ChunkSizeInputVerifier() {
        }

        protected void setErrorFeedback(JosmTextField josmTextField, String string) {
            josmTextField.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
            josmTextField.setToolTipText(string);
            josmTextField.setBackground(BG_COLOR_ERROR);
        }

        protected void clearErrorFeedback(JosmTextField josmTextField, String string) {
            josmTextField.setBorder(UIManager.getBorder("TextField.border"));
            josmTextField.setToolTipText(string);
            josmTextField.setBackground(UIManager.getColor("TextField.background"));
        }

        protected void validateChunkSize() {
            try {
                int n = Integer.parseInt(UploadStrategySelectionPanel.this.tfChunkSize.getText().trim());
                int n2 = OsmApi.getOsmApi().getCapabilities().getMaxChangesetSize();
                if (n <= 0) {
                    this.setErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Illegal chunk size <= 0. Please enter an integer > 1", new Object[0]));
                } else if (n2 > 0 && n > n2) {
                    this.setErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Chunk size {0} exceeds max. changeset size {1} for server ''{2}''", n, n2, OsmApi.getOsmApi().getBaseUrl()));
                } else {
                    this.clearErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Please enter an integer > 1", new Object[0]));
                }
                if (n2 > 0 && n > n2) {
                    this.setErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Chunk size {0} exceeds max. changeset size {1} for server ''{2}''", n, n2, OsmApi.getOsmApi().getBaseUrl()));
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorFeedback(UploadStrategySelectionPanel.this.tfChunkSize, I18n.tr("Value ''{0}'' is not a number. Please enter an integer > 1", UploadStrategySelectionPanel.this.tfChunkSize.getText().trim()));
            }
            finally {
                UploadStrategySelectionPanel.this.updateNumRequestsLabels();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.validateChunkSize();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.validateChunkSize();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.validateChunkSize();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == UploadStrategySelectionPanel.this.tfChunkSize && "enabled".equals(propertyChangeEvent.getPropertyName()) && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                this.validateChunkSize();
            }
        }
    }

    static class TextFieldFocusHandler
    extends FocusAdapter {
        TextFieldFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component instanceof JosmTextField) {
                JosmTextField josmTextField = (JosmTextField)component;
                josmTextField.selectAll();
            }
        }
    }
}

