/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.NodeInterface;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

final class NodeClassImpl
extends NodeClass {
    private static final NodeFieldAccessor[] EMPTY_NODE_FIELD_ARRAY = new NodeFieldAccessor[0];
    private final NodeFieldAccessor[] fields;
    private final NodeFieldAccessor parentField;
    private final NodeFieldAccessor nodeClassField;
    private final Class<? extends Node> clazz;

    NodeClassImpl(Class<? extends Node> clazz) {
        super(clazz);
        if (!Node.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        ArrayList<NodeFieldAccessor> fieldsList = new ArrayList<NodeFieldAccessor>();
        NodeFieldAccessor parentFieldTmp = null;
        NodeFieldAccessor nodeClassFieldTmp = null;
        try {
            Field field = Node.class.getDeclaredField("parent");
            assert (Node.class.isAssignableFrom(field.getType()));
            parentFieldTmp = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.PARENT, field);
            field = Node.class.getDeclaredField("nodeClass");
            assert (NodeClass.class.isAssignableFrom(field.getType()));
            nodeClassFieldTmp = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.NODE_CLASS, field);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError("Node field not found", e);
        }
        NodeClassImpl.collectInstanceFields(clazz, fieldsList);
        Collections.sort(fieldsList, new Comparator<NodeFieldAccessor>(){

            @Override
            public int compare(NodeFieldAccessor o1, NodeFieldAccessor o2) {
                return Integer.compare(this.order(o1), this.order(o2));
            }

            private int order(NodeFieldAccessor nodeField) {
                return NodeClassImpl.this.isChildField(nodeField) ? 0 : (NodeClassImpl.this.isChildrenField(nodeField) ? 1 : (NodeClassImpl.this.isCloneableField(nodeField) ? 2 : 3));
            }
        });
        this.fields = fieldsList.toArray(EMPTY_NODE_FIELD_ARRAY);
        this.nodeClassField = nodeClassFieldTmp;
        this.parentField = parentFieldTmp;
        this.clazz = clazz;
    }

    private static void collectInstanceFields(Class<? extends Object> clazz, List<NodeFieldAccessor> fieldsList) {
        Field[] declaredFields;
        if (clazz.getSuperclass() != null) {
            NodeClassImpl.collectInstanceFields(clazz.getSuperclass(), fieldsList);
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            NodeFieldAccessor nodeField;
            if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic() || field.getDeclaringClass() == Node.class && (field.getName().equals("parent") || field.getName().equals("nodeClass"))) continue;
            if (field.getAnnotation(Node.Child.class) != null) {
                NodeClassImpl.checkChildField(field);
                nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.CHILD, field);
            } else if (field.getAnnotation(Node.Children.class) != null) {
                NodeClassImpl.checkChildrenField(field);
                nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.CHILDREN, field);
            } else {
                nodeField = NodeFieldAccessor.create(NodeFieldAccessor.NodeFieldKind.DATA, field);
            }
            fieldsList.add(nodeField);
        }
    }

    @Override
    public NodeFieldAccessor getNodeClassField() {
        return this.nodeClassField;
    }

    private static boolean isNodeType(Class<?> clazz) {
        return Node.class.isAssignableFrom(clazz) || clazz.isInterface() && NodeInterface.class.isAssignableFrom(clazz);
    }

    private static void checkChildField(Field field) {
        if (!NodeClassImpl.isNodeType(field.getType())) {
            throw new AssertionError((Object)("@Child field type must be a subclass of Node or an interface extending NodeInterface (" + field + ")"));
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new AssertionError((Object)("@Child field must not be final (" + field + ")"));
        }
    }

    private static void checkChildrenField(Field field) {
        if (!field.getType().isArray() || !NodeClassImpl.isNodeType(field.getType().getComponentType())) {
            throw new AssertionError((Object)("@Children field type must be an array of a subclass of Node or an interface extending NodeInterface (" + field + ")"));
        }
        if (!Modifier.isFinal(field.getModifiers())) {
            throw new AssertionError((Object)("@Children field must be final (" + field + ")"));
        }
    }

    @Override
    public NodeFieldAccessor getParentField() {
        return this.parentField;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeClassImpl) {
            NodeClassImpl other = (NodeClassImpl)obj;
            return this.clazz.equals(other.clazz);
        }
        return false;
    }

    @Override
    public Iterator<Node> makeIterator(Node node) {
        assert (this.clazz.isInstance(node));
        return new NodeIterator(this, node);
    }

    @Override
    public Class<? extends Node> getType() {
        return this.clazz;
    }

    protected Iterable<NodeFieldAccessor> getNodeFields() {
        return this.getNodeFields(null);
    }

    private Iterable<NodeFieldAccessor> getNodeFields(final NodeFieldFilter filter) {
        return new Iterable<NodeFieldAccessor>(){

            @Override
            public Iterator<NodeFieldAccessor> iterator() {
                return new Iterator<NodeFieldAccessor>(){
                    private int cursor = -1;
                    {
                        this.forward();
                    }

                    private void forward() {
                        for (int i = this.cursor + 1; i < NodeClassImpl.this.fields.length; ++i) {
                            NodeFieldAccessor field = NodeClassImpl.this.fields[i];
                            if (filter != null && !filter.test(field)) continue;
                            this.cursor = i;
                            return;
                        }
                        this.cursor = NodeClassImpl.this.fields.length;
                    }

                    @Override
                    public boolean hasNext() {
                        assert (this.cursor >= 0);
                        return this.cursor < NodeClassImpl.this.fields.length;
                    }

                    @Override
                    public NodeFieldAccessor next() {
                        if (this.hasNext()) {
                            NodeFieldAccessor next = NodeClassImpl.this.fields[this.cursor];
                            this.forward();
                            return next;
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public NodeFieldAccessor[] getFields() {
        return NodeClassImpl.iterableToArray(this.getNodeFields());
    }

    @Override
    public NodeFieldAccessor[] getChildFields() {
        return NodeClassImpl.iterableToArray(this.getNodeFields(new NodeFieldFilter(){

            @Override
            public boolean test(NodeFieldAccessor field) {
                return NodeClassImpl.this.isChildField(field);
            }
        }));
    }

    @Override
    public NodeFieldAccessor[] getChildrenFields() {
        return NodeClassImpl.iterableToArray(this.getNodeFields(new NodeFieldFilter(){

            @Override
            public boolean test(NodeFieldAccessor field) {
                return NodeClassImpl.this.isChildrenField(field);
            }
        }));
    }

    @Override
    public NodeFieldAccessor[] getCloneableFields() {
        return NodeClassImpl.iterableToArray(this.getNodeFields(new NodeFieldFilter(){

            @Override
            public boolean test(NodeFieldAccessor field) {
                return NodeClassImpl.this.isCloneableField(field);
            }
        }));
    }

    private static NodeFieldAccessor[] iterableToArray(Iterable<NodeFieldAccessor> fields) {
        ArrayList<NodeFieldAccessor> fieldList = new ArrayList<NodeFieldAccessor>();
        for (NodeFieldAccessor field : fields) {
            fieldList.add(field);
        }
        return fieldList.toArray(new NodeFieldAccessor[0]);
    }

    @Override
    protected void putFieldObject(Object field, Node receiver, Object value) {
        ((NodeFieldAccessor)field).putObject(receiver, value);
    }

    @Override
    protected Object getFieldObject(Object field, Node receiver) {
        return ((NodeFieldAccessor)field).getObject(receiver);
    }

    @Override
    protected Object getFieldValue(Object field, Node receiver) {
        return ((NodeFieldAccessor)field).loadValue(receiver);
    }

    @Override
    protected Class<?> getFieldType(Object field) {
        return ((NodeFieldAccessor)field).getType();
    }

    @Override
    protected String getFieldName(Object field) {
        return ((NodeFieldAccessor)field).getName();
    }

    @Override
    protected boolean isChildField(Object field) {
        return ((NodeFieldAccessor)field).getKind() == NodeFieldAccessor.NodeFieldKind.CHILD;
    }

    @Override
    protected boolean isChildrenField(Object field) {
        return ((NodeFieldAccessor)field).getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN;
    }

    @Override
    protected boolean isCloneableField(Object field) {
        return ((NodeFieldAccessor)field).getKind() == NodeFieldAccessor.NodeFieldKind.DATA && NodeCloneable.class.isAssignableFrom(((NodeFieldAccessor)field).getType());
    }

    @Override
    boolean nodeFieldsOrderedByKind() {
        return true;
    }

    private static final class NodeIterator
    implements Iterator<Node> {
        private final NodeClassImpl nodeClass;
        private final NodeFieldAccessor[] fields;
        private final Node node;
        private int fieldIndex;
        private Node next;
        private int childrenIndex;
        private Object[] children;

        protected NodeIterator(NodeClassImpl nodeClass, Node node) {
            this.nodeClass = nodeClass;
            this.fields = nodeClass.fields;
            this.node = node;
            this.advance();
        }

        private void advance() {
            if (this.advanceChildren()) {
                return;
            }
            while (this.fieldIndex < this.fields.length) {
                NodeFieldAccessor field = this.fields[this.fieldIndex];
                ++this.fieldIndex;
                if (this.nodeClass.isChildField(field)) {
                    this.next = (Node)this.nodeClass.getFieldObject(field, this.node);
                    return;
                }
                if (this.nodeClass.isChildrenField(field)) {
                    this.children = (Object[])this.nodeClass.getFieldObject(field, this.node);
                    this.childrenIndex = 0;
                    if (!this.advanceChildren()) continue;
                    return;
                }
                if (!this.nodeClass.nodeFieldsOrderedByKind()) continue;
                break;
            }
            this.next = null;
        }

        private boolean advanceChildren() {
            if (this.children == null) {
                return false;
            }
            if (this.childrenIndex < this.children.length) {
                this.next = (Node)this.children[this.childrenIndex];
                ++this.childrenIndex;
                return true;
            }
            this.children = null;
            this.childrenIndex = 0;
            return false;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node next() {
            Node result = this.next;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface NodeFieldFilter {
        public boolean test(NodeFieldAccessor var1);
    }
}

