/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class WhenParseNode
extends ParseNode {
    protected final ParseNode expressionNodes;
    protected final ParseNode bodyNode;
    private final ParseNode nextCase;

    public WhenParseNode(ISourcePosition position, ParseNode expressionNodes, ParseNode bodyNode, ParseNode nextCase) {
        super(position, expressionNodes != null && expressionNodes.containsVariableAssignment() || bodyNode != null && bodyNode.containsVariableAssignment() || nextCase != null && nextCase.containsVariableAssignment());
        this.expressionNodes = expressionNodes;
        this.bodyNode = bodyNode;
        this.nextCase = nextCase;
        assert (bodyNode != null) : "bodyNode is not null";
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHENNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitWhenNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public ParseNode getNextCase() {
        return this.nextCase;
    }

    public ParseNode getExpressionNodes() {
        return this.expressionNodes;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.expressionNodes, this.bodyNode, this.nextCase);
    }
}

