/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class ColorButton
extends JButton {
    public static final String COLOR_PROPERTY = "color";
    public static final String COLOR_DIALOG_TITLE_PROPERTY = "colorDialogTitle";
    private static JColorChooser colorChooser;
    private static Locale colorChooserLocale;
    private Integer color;
    private String colorDialogTitle;

    public ColorButton() {
        this((UserPreferences)null);
    }

    public ColorButton(final UserPreferences userPreferences) {
        JLabel jLabel = new JLabel("Color");
        Dimension dimension = jLabel.getPreferredSize();
        final int n = dimension.width;
        final int n2 = dimension.height;
        this.setIcon(new Icon(){

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n2;
            }

            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                if (ColorButton.this.color != null) {
                    graphics.setColor(new Color(ColorButton.this.color));
                    graphics.fillRect(n3 + 2, n22 + 2, n - 4, n2 - 4);
                }
                graphics.setColor(ColorButton.this.getForeground());
                graphics.drawRect(n3 + 2, n22 + 2, n - 5, n2 - 5);
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractColorChooserPanel abstractColorChooserPanel;
                if (colorChooser == null || !Locale.getDefault().equals(colorChooserLocale)) {
                    colorChooser = ColorButton.this.createColorChooser(userPreferences);
                    colorChooserLocale = Locale.getDefault();
                }
                colorChooser.setColor(ColorButton.this.color != null ? new Color(ColorButton.this.color) : ColorButton.this.getBackground());
                JDialog jDialog = JColorChooser.createDialog(ColorButton.this.getParent(), ColorButton.this.colorDialogTitle, true, colorChooser, new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Integer n = colorChooser.getColor().getRGB();
                        ColorButton.this.setColor(n);
                        ArrayList<Integer> arrayList = new ArrayList<Integer>(userPreferences.getRecentColors());
                        int n2 = arrayList.indexOf(n);
                        if (n2 != 0) {
                            if (n2 > 0) {
                                arrayList.remove(n2);
                            } else {
                                while (arrayList.size() > RecentColorsPanel.MAX_COLORS) {
                                    arrayList.remove(arrayList.size() - 1);
                                }
                            }
                            arrayList.add(0, n);
                            userPreferences.setRecentColors(arrayList);
                        }
                    }
                }, null);
                if (userPreferences != null && (abstractColorChooserPanel = colorChooser.getChooserPanels()[0]) instanceof PalettesColorChooserPanel) {
                    ((PalettesColorChooserPanel)abstractColorChooserPanel).setInitialColor(colorChooser.getColor());
                    colorChooser.getPreviewPanel().getParent().setVisible(!userPreferences.getRecentColors().isEmpty());
                    jDialog.pack();
                }
                jDialog.setVisible(true);
            }
        });
    }

    private JColorChooser createColorChooser(UserPreferences userPreferences) {
        JColorChooser jColorChooser;
        if (userPreferences != null) {
            UIManager.put("ColorChooser.previewText", userPreferences.getLocalizedString(ColorButton.class, "recentPanel.title", new Object[0]));
            DefaultColorSelectionModel defaultColorSelectionModel = new DefaultColorSelectionModel();
            final RecentColorsPanel recentColorsPanel = new RecentColorsPanel(defaultColorSelectionModel, userPreferences);
            final PalettesColorChooserPanel palettesColorChooserPanel = new PalettesColorChooserPanel(userPreferences);
            palettesColorChooserPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            jColorChooser = new JColorChooser(defaultColorSelectionModel){

                public void updateUI() {
                    super.updateUI();
                    ArrayList<AbstractColorChooserPanel> arrayList = new ArrayList<AbstractColorChooserPanel>(Arrays.asList(this.getChooserPanels()));
                    if (((AbstractColorChooserPanel)arrayList.get(0)).getClass().getName().equals("javax.swing.colorchooser.DefaultSwatchChooserPanel")) {
                        arrayList.remove(0);
                    }
                    for (AbstractColorChooserPanel abstractColorChooserPanel : arrayList) {
                        Container container;
                        Component component;
                        if (!abstractColorChooserPanel.getClass().getName().equals("javax.swing.colorchooser.ColorChooserPanel") || !(component = abstractColorChooserPanel.getComponent(0)).getClass().getName().equals("javax.swing.colorchooser.ColorPanel") || !(component instanceof Container) || (container = (Container)component).getComponentCount() != 15) continue;
                        int n = container.getComponent(4) instanceof JLabel && ((JLabel)container.getComponent(4)).getText().length() == 0 ? 3 : 4;
                        container.remove(n + 10);
                        container.remove(n + 5);
                        container.remove(n);
                    }
                    arrayList.add(0, palettesColorChooserPanel);
                    this.setChooserPanels(arrayList.toArray(new AbstractColorChooserPanel[arrayList.size()]));
                    this.setPreviewPanel(recentColorsPanel);
                    ColorButton.this.addAutoSelectionOnTextFields(this);
                }
            };
        } else {
            jColorChooser = new JColorChooser();
        }
        jColorChooser.getActionMap().put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Window)SwingUtilities.getRoot(jColorChooser)).dispose();
            }
        });
        jColorChooser.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        return jColorChooser;
    }

    private void addAutoSelectionOnTextFields(JComponent jComponent) {
        JComponent jComponent2;
        if (jComponent instanceof JTextComponent) {
            SwingTools.addAutoSelectionOnFocusGain((JTextComponent)jComponent);
        } else if (jComponent instanceof JSpinner && (jComponent2 = ((JSpinner)jComponent).getEditor()) instanceof JSpinner.DefaultEditor) {
            SwingTools.addAutoSelectionOnFocusGain(((JSpinner.DefaultEditor)jComponent2).getTextField());
        }
        int n = jComponent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JComponent)) continue;
            this.addAutoSelectionOnTextFields((JComponent)component);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setColor(Integer n) {
        if (n != this.color || n != null && !n.equals(this.color)) {
            Integer n2 = this.color;
            this.color = n;
            this.firePropertyChange(COLOR_PROPERTY, n2, n);
            this.repaint();
        }
    }

    public String getColorDialogTitle() {
        return this.colorDialogTitle;
    }

    public void setColorDialogTitle(String string) {
        if (string != this.colorDialogTitle || string != null && !string.equals(this.colorDialogTitle)) {
            String string2 = this.colorDialogTitle;
            this.colorDialogTitle = string;
            this.firePropertyChange(COLOR_DIALOG_TITLE_PROPERTY, string2, string);
            this.repaint();
        }
    }

    private static class RecentColorsPanel
    extends JPanel {
        public static final int MAX_COLORS = OperatingSystem.isJavaVersionGreaterOrEqual("1.7") ? 25 : 20;
        private Cursor pipetteCursor = SwingTools.createCustomCursor(OperatingSystem.isMacOSX() ? ColorButton.class.getResource("resources/cursors/pipette16x16-macosx.png") : ColorButton.class.getResource("resources/cursors/pipette16x16.png"), ColorButton.class.getResource("resources/cursors/pipette32x32.png"), 0.0f, 1.0f, "Pipette", Cursor.getPredefinedCursor(1));

        private RecentColorsPanel(final ColorSelectionModel colorSelectionModel, final UserPreferences userPreferences) {
            super(new GridBagLayout());
            userPreferences.addPropertyChangeListener(UserPreferences.Property.RECENT_COLORS, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RecentColorsPanel.this.setRecentColors(colorSelectionModel, userPreferences);
                }
            });
            this.setRecentColors(colorSelectionModel, userPreferences);
            this.setOpaque(false);
        }

        private void setRecentColors(final ColorSelectionModel colorSelectionModel, UserPreferences userPreferences) {
            this.removeAll();
            int n = 0;
            if (UIManager.getLookAndFeel().getID().equals("GTK")) {
                this.add((Component)new JLabel(UIManager.getString("ColorChooser.previewText")), new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            }
            List<Integer> list = userPreferences.getRecentColors();
            final int n2 = Math.round(20.0f * SwingTools.getResolutionScale());
            for (int i = 0; i < list.size() && i < MAX_COLORS; ++i) {
                final Integer n3 = list.get(i);
                JComponent jComponent = new JComponent(){

                    protected void paintComponent(Graphics graphics) {
                        Insets insets = this.getInsets();
                        int n = this.getWidth() - insets.right - insets.left;
                        int n22 = this.getHeight() - insets.bottom - insets.top;
                        graphics.setColor(Color.GRAY);
                        graphics.translate(insets.left, insets.top);
                        graphics.drawRect(0, 0, n - 1, n22 - 1);
                        graphics.setColor(new Color(n3));
                        graphics.fillRect(1, 1, n - 2, n22 - 2);
                    }

                    public Dimension getPreferredSize() {
                        return new Dimension(n2, n2);
                    }
                };
                jComponent.addMouseListener(new MouseAdapter(){

                    public void mousePressed(MouseEvent mouseEvent) {
                        JRootPane jRootPane;
                        colorSelectionModel.setSelectedColor(new Color(n3));
                        if (mouseEvent.getClickCount() == 2 && (jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, RecentColorsPanel.this)) != null) {
                            for (JButton jButton : SwingTools.findChildren(jRootPane, JButton.class)) {
                                if (!"OK".equals(jButton.getActionCommand())) continue;
                                jButton.doClick();
                            }
                        }
                    }
                });
                jComponent.setCursor(this.pipetteCursor);
                this.add((Component)jComponent, new GridBagConstraints(n++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
            }
        }

        public Insets getInsets() {
            if (OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                Insets insets = super.getInsets();
                if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                    insets.top += 10;
                }
                return insets;
            }
            if (UIManager.getLookAndFeel().getID().equals("GTK")) {
                return new Insets(5, 5, 5, 5);
            }
            return new Insets(1, 0, 0, 0);
        }
    }

    private static final class ColorCode {
        private final String id;
        private final int rgb;
        public static final ColorCode[] RAL_COLORS = new ColorCode[]{new ColorCode("1000", 12500351), new ColorCode("1001", 12759160), new ColorCode("1002", 13018724), new ColorCode("1003", 15056385), new ColorCode("1004", 13476916), new ColorCode("1005", 11109127), new ColorCode("1006", 14983184), new ColorCode("1007", 14458112), new ColorCode("1011", 9070146), new ColorCode("1012", 13087814), new ColorCode("1013", 15394506), new ColorCode("1014", 14797903), new ColorCode("1015", 15128208), new ColorCode("1016", 15597345), new ColorCode("1017", 16109619), new ColorCode("1018", 16315179), new ColorCode("1019", 10393444), new ColorCode("1020", 0x999950), new ColorCode("1021", 15981067), new ColorCode("1023", 16437761), new ColorCode("1024", 11444299), new ColorCode("1026", 0xFFFF00), new ColorCode("1027", 10326273), new ColorCode("1028", 16034048), new ColorCode("1032", 14069249), new ColorCode("1033", 15967493), new ColorCode("1034", 15706442), new ColorCode("1035", 6970701), new ColorCode("1036", 7361333), new ColorCode("1037", 15965976), new ColorCode("2000", 15562254), new ColorCode("2001", 13188128), new ColorCode("2002", 13314081), new ColorCode("2003", 16741652), new ColorCode("2004", 16008721), new ColorCode("2005", 16720641), new ColorCode("2007", 16753696), new ColorCode("2008", 16211493), new ColorCode("2009", 16072737), new ColorCode("2010", 14175008), new ColorCode("2011", 15498278), new ColorCode("2012", 15028535), new ColorCode("2013", 12802097), new ColorCode("3000", 11479838), new ColorCode("3001", 10821657), new ColorCode("3002", 10625821), new ColorCode("3003", 10162462), new ColorCode("3004", 7673118), new ColorCode("3005", 6168873), new ColorCode("3007", 4268583), new ColorCode("3009", 0x642424), new ColorCode("3011", 7872281), new ColorCode("3012", 12683115), new ColorCode("3013", 10560274), new ColorCode("3014", 13856368), new ColorCode("3015", 15370650), new ColorCode("3016", 11741217), new ColorCode("3017", 15086148), new ColorCode("3018", 13971506), new ColorCode("3020", 13370885), new ColorCode("3022", 14241840), new ColorCode("3024", 0xF80000), new ColorCode("3026", 0xFE0000), new ColorCode("3027", 12918068), new ColorCode("3031", 11740200), new ColorCode("3032", 7476258), new ColorCode("3033", 11816003), new ColorCode("4001", 7159643), new ColorCode("4002", 9579326), new ColorCode("4003", 14568586), new ColorCode("4004", 6560820), new ColorCode("4005", 7095925), new ColorCode("4006", 10499186), new ColorCode("4007", 4856108), new ColorCode("4008", 9588349), new ColorCode("4009", 10585492), new ColorCode("4010", 13579382), new ColorCode("4011", 8811425), new ColorCode("4012", 7104628), new ColorCode("5000", 3493235), new ColorCode("5001", 2044984), new ColorCode("5002", 2105679), new ColorCode("5003", 1908275), new ColorCode("5004", 1578780), new ColorCode("5005", 1975392), new ColorCode("5007", 4087690), new ColorCode("5008", 2499885), new ColorCode("5009", 153193), new ColorCode("5010", 928075), new ColorCode("5011", 2300452), new ColorCode("5012", 3900349), new ColorCode("5013", 1974589), new ColorCode("5014", 6319756), new ColorCode("5015", 2257331), new ColorCode("5017", 407921), new ColorCode("5018", 0x3F888F), new ColorCode("5019", 1791363), new ColorCode("5020", 1913674), new ColorCode("5021", 2452859), new ColorCode("5022", 2435152), new ColorCode("5023", 4810637), new ColorCode("5024", 6134683), new ColorCode("5025", 2778232), new ColorCode("5026", 1059924), new ColorCode("6000", 3237456), new ColorCode("6001", 2650675), new ColorCode("6002", 2971436), new ColorCode("6003", 4343346), new ColorCode("6004", 2046525), new ColorCode("6005", 3097912), new ColorCode("6006", 4078386), new ColorCode("6007", 3423017), new ColorCode("6008", 3749162), new ColorCode("6009", 3225387), new ColorCode("6010", 3500077), new ColorCode("6011", 5796422), new ColorCode("6012", 3423808), new ColorCode("6013", 7106902), new ColorCode("6014", 4669486), new ColorCode("6015", 3882038), new ColorCode("6016", 1988933), new ColorCode("6017", 5017921), new ColorCode("6018", 5744185), new ColorCode("6019", 12446902), new ColorCode("6020", 3029539), new ColorCode("6021", 9022582), new ColorCode("6022", 2433563), new ColorCode("6024", 3179590), new ColorCode("6025", 4023341), new ColorCode("6026", 89426), new ColorCode("6027", 8700862), new ColorCode("6028", 2905413), new ColorCode("6029", 2121789), new ColorCode("6032", 3243843), new ColorCode("6033", 4816502), new ColorCode("6034", 8369589), new ColorCode("6035", 1856557), new ColorCode("6036", 1652535), new ColorCode("7000", 7898507), new ColorCode("7001", 9082263), new ColorCode("7002", 8289106), new ColorCode("7003", 7106649), new ColorCode("7004", 0x969992), new ColorCode("7005", 6581091), new ColorCode("7006", 7169362), new ColorCode("7008", 6971185), new ColorCode("7009", 5068357), new ColorCode("7010", 5001546), new ColorCode("7011", 4410189), new ColorCode("7012", 5134164), new ColorCode("7013", 4605233), new ColorCode("7015", 4409168), new ColorCode("7016", 2699571), new ColorCode("7021", 2304043), new ColorCode("7022", 3354412), new ColorCode("7023", 6843486), new ColorCode("7024", 4672081), new ColorCode("7026", 3093819), new ColorCode("7030", 9145466), new ColorCode("7031", 4672334), new ColorCode("7032", 12105625), new ColorCode("7033", 8225905), new ColorCode("7034", 9407334), new ColorCode("7035", 0xD7D7D7), new ColorCode("7036", 8353401), new ColorCode("7037", 0x7D7F7D), new ColorCode("7038", 11909297), new ColorCode("7039", 7104864), new ColorCode("7040", 10330538), new ColorCode("7042", 9278605), new ColorCode("7043", 5133394), new ColorCode("7044", 13288624), new ColorCode("7045", 0x909090), new ColorCode("7046", 8554895), new ColorCode("7047", 0xD0D0D0), new ColorCode("7048", 9011574), new ColorCode("8000", 8547380), new ColorCode("8001", 9789216), new ColorCode("8002", 7093034), new ColorCode("8003", 7553570), new ColorCode("8004", 9322538), new ColorCode("8007", 5846303), new ColorCode("8008", 7294760), new ColorCode("8011", 5978665), new ColorCode("8012", 5841697), new ColorCode("8014", 3681310), new ColorCode("8015", 6502964), new ColorCode("8016", 4992807), new ColorCode("8017", 4534830), new ColorCode("8019", 4209210), new ColorCode("8022", 0x212121), new ColorCode("8023", 10903086), new ColorCode("8024", 7951677), new ColorCode("8025", 7691336), new ColorCode("8028", 5126961), new ColorCode("8029", 7748648), new ColorCode("9001", 16643299), new ColorCode("9002", 15199194), new ColorCode("9003", 0xF4F4F4), new ColorCode("9004", 0x282828), new ColorCode("9005", 657930), new ColorCode("9006", 0xA5A5A5), new ColorCode("9007", 0x8F8F8F), new ColorCode("9010", 0xFFFFFF), new ColorCode("9011", 0x1C1C1C), new ColorCode("9016", 0xF6F6F6), new ColorCode("9017", 0x1E1E1E), new ColorCode("9018", 0xD7D7D7), new ColorCode("9022", 0x9C9C9C), new ColorCode("9023", 0x828282)};
        public static final ColorCode[] CREATIVE_COMMONS_COLORS = new ColorCode[]{new ColorCode("Magenta 1", 16233164), new ColorCode("Magenta 2", 11938670), new ColorCode("Magenta 3", 8067923), new ColorCode("Magenta 4", 5181493), new ColorCode("Purple 1", 14070998), new ColorCode("Purple 2", 9840838), new ColorCode("Purple 3", 6695288), new ColorCode("Purple 4", 4331855), new ColorCode("Blue 1", 12570346), new ColorCode("Blue 2", 4420791), new ColorCode("Blue 3", 2179460), new ColorCode("Blue 4", 1058120), new ColorCode("CC Green 1", 14738657), new ColorCode("CC Green 2", 11253935), new ColorCode("CC Green 3", 4413770), new ColorCode("CC Green 4", 2766639), new ColorCode("Green 1", 15002528), new ColorCode("Green 2", 10012679), new ColorCode("Green 3", 6454543), new ColorCode("Green 4", 4018212), new ColorCode("Sand 1", 15458482), new ColorCode("Sand 2", 11641418), new ColorCode("Sand 3", 7168280), new ColorCode("Sand 4", 0x44411F), new ColorCode("NC Yellow 1", 16774050), new ColorCode("NC Yellow 1", 15587346), new ColorCode("NC Yellow 2", 11573777), new ColorCode("NC Yellow 3", 5130519), new ColorCode("Orange 1", 16767134), new ColorCode("Orange 2", 15701025), new ColorCode("Orange 3", 10774544), new ColorCode("Orange 4", 5520643), new ColorCode("Red 1", 16430233), new ColorCode("Red 2", 13711380), new ColorCode("Red 3", 9513744), new ColorCode("Red 4", 5905422), new ColorCode("Grey 1", 0xEDEDEE), new ColorCode("Grey 2", 0xDCDDDE), new ColorCode("Grey 3", 10987948), new ColorCode("Grey 4", 0x636466), new ColorCode("Grey 5", 0x393839), new ColorCode("Grey 5", 1185043)};

        public ColorCode(String string, int n) {
            this.id = string;
            this.rgb = n;
        }

        public String getId() {
            return this.id;
        }

        public int getRGB() {
            return this.rgb;
        }
    }

    private static class PaletteComboBox
    extends JComboBox {
        private PaletteComboBox(ColorCode[] colorCodeArray) {
            super(colorCodeArray);
            PopupMenuListener popupMenuListener = new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    JComboBox jComboBox = (JComboBox)popupMenuEvent.getSource();
                    Accessible accessible = jComboBox.getUI().getAccessibleChild(jComboBox, 0);
                    if (!(accessible instanceof JPopupMenu)) {
                        return;
                    }
                    JComponent jComponent = (JComponent)((JPopupMenu)accessible).getComponent(0);
                    Dimension dimension = new Dimension();
                    dimension.width = jComboBox.getPreferredSize().width - 10;
                    dimension.height = jComponent.getPreferredSize().height;
                    jComponent.setPreferredSize(dimension);
                    jComponent.setMaximumSize(dimension);
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }
            };
            if (!OperatingSystem.isMacOSX()) {
                this.addPopupMenuListener(popupMenuListener);
            }
            final int n = Math.round(16.0f * SwingTools.getResolutionScale());
            this.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(final JList jList, Object object, int n2, boolean bl, boolean bl2) {
                    final ColorCode colorCode = (ColorCode)object;
                    object = colorCode == null ? " " : colorCode.getId();
                    Component component = super.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
                    if (colorCode != null) {
                        this.setIcon(new Icon(){

                            public int getIconWidth() {
                                return n * 2;
                            }

                            public int getIconHeight() {
                                return n;
                            }

                            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                                graphics.setColor(new Color(colorCode.getRGB()));
                                graphics.fillRect(n + 1, n2 + 1, this.getIconWidth() - 3, this.getIconHeight() - 2);
                                graphics.setColor(jList.getForeground());
                                graphics.drawRect(n, n2, this.getIconWidth() - 2, this.getIconHeight() - 1);
                            }
                        });
                    }
                    return component;
                }
            });
        }

        public ColorCode getColorCode(Color color) {
            if (color != null) {
                int n = this.getModel().getSize();
                for (int i = 1; i < n; ++i) {
                    ColorCode colorCode = (ColorCode)this.getModel().getElementAt(i);
                    if (colorCode.getRGB() != (color.getRGB() & 0xFFFFFF)) continue;
                    return colorCode;
                }
            }
            return null;
        }
    }

    private static final class ColorChart
    extends JComponent {
        private ColorChart() {
        }

        protected void paintComponent(Graphics graphics) {
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.right;
            for (int i = insets.left; i < n; ++i) {
                int n2 = this.getHeight() - insets.bottom;
                for (int j = insets.top; j < n2; ++j) {
                    graphics.setColor(this.getColorAt(i, j));
                    graphics.fillRect(i, j, 1, 1);
                }
            }
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(Math.round(256.0f * SwingTools.getResolutionScale()) + insets.right + insets.left, Math.round(128.0f * SwingTools.getResolutionScale()) + insets.bottom + insets.top);
        }

        public Color getColorAt(int n, int n2) {
            Insets insets = this.getInsets();
            n = Math.min(Math.max(0, n - insets.left), this.getWidth() - insets.right - 1);
            n2 = Math.min(Math.max(0, n2 - insets.top), this.getHeight() - insets.bottom - 1);
            int n3 = this.getWidth() - insets.right - insets.left;
            int n4 = this.getHeight() - insets.bottom - insets.top;
            if (n2 < n4 / 2) {
                return Color.getHSBColor((float)n / (float)(n3 - 1), 1.0f, (float)n2 / (float)(n4 - 1) * 2.0f);
            }
            return Color.getHSBColor((float)n / (float)(n3 - 1), (float)(n4 - 1 - n2) / (float)(n4 - 1) * 2.0f, 1.0f);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = String.format("#%6X", this.getColorAt(mouseEvent.getX(), mouseEvent.getY()).getRGB() & 0xFFFFFF).replace(' ', '0');
            return "<html><table><td width='50' height='50' bgcolor='" + string + "'></td></tr>" + "<tr><td align='center'>" + string + "</td></tr>";
        }
    }

    private static final class GrayColorChart
    extends JComponent {
        private GrayColorChart() {
        }

        protected void paintComponent(Graphics graphics) {
            Insets insets = this.getInsets();
            graphics.translate(insets.left, 0);
            int n = this.getWidth() - insets.right - insets.left;
            int n2 = this.getHeight() - insets.bottom;
            for (int i = insets.top; i < n2; ++i) {
                graphics.setColor(this.getColorAt(i));
                graphics.fillRect(0, i, n, 1);
            }
            graphics.translate(-insets.left, 0);
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(Math.round(15.0f * SwingTools.getResolutionScale()) + insets.right + insets.left, Math.round(128.0f * SwingTools.getResolutionScale()) + insets.bottom + insets.top);
        }

        public Color getColorAt(int n) {
            Insets insets = this.getInsets();
            float f = (float)(Math.min(Math.max(insets.top, n), this.getHeight() - insets.bottom - 1) - insets.top) / (float)(this.getHeight() - insets.bottom - insets.top - 1);
            return new Color(f, f, f);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = String.format("#%6X", this.getColorAt(mouseEvent.getY()).getRGB() & 0xFFFFFF).replace(' ', '0');
            return "<html><table><tr><td width='50' height='50' bgcolor='" + string + "'></td></tr>" + "<tr><td align='center'>" + string + "</td></tr>";
        }
    }

    private static class PalettesColorChooserPanel
    extends AbstractColorChooserPanel {
        private final UserPreferences preferences;
        private GrayColorChart grayColorChart;
        private ColorChart colorChart;
        private JComponent colorComponent;
        private JFormattedTextField rgbTextField;
        private PaletteComboBox ralComboBox;
        private PaletteComboBox creativeCommonsComboBox;
        private Color initialColor;

        public PalettesColorChooserPanel(UserPreferences userPreferences) {
            this.setOpaque(false);
            this.preferences = userPreferences;
            this.addAncestorListener(new AncestorListener(){
                private int initialDelay;

                public void ancestorAdded(AncestorEvent ancestorEvent) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    this.initialDelay = toolTipManager.getInitialDelay();
                    toolTipManager.setInitialDelay(Math.min(this.initialDelay, 100));
                }

                public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    ToolTipManager.sharedInstance().setInitialDelay(this.initialDelay);
                }

                public void ancestorMoved(AncestorEvent ancestorEvent) {
                }
            });
        }

        public void setInitialColor(Color color) {
            this.initialColor = color;
            if (this.colorComponent != null) {
                this.colorComponent.repaint();
            }
        }

        public void updateChooser() {
            Color color = this.getColorFromModel();
            this.colorComponent.repaint();
            if (!color.equals(this.rgbTextField.getValue())) {
                this.rgbTextField.setValue(color);
            }
            this.ralComboBox.setSelectedItem(this.ralComboBox.getColorCode(color));
            this.creativeCommonsComboBox.setSelectedItem(this.creativeCommonsComboBox.getColorCode(color));
        }

        protected void buildChooser() {
            this.removeAll();
            this.grayColorChart = new GrayColorChart();
            this.grayColorChart.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            final Cursor cursor = SwingTools.createCustomCursor(OperatingSystem.isMacOSX() ? ColorButton.class.getResource("resources/cursors/pipette16x16-macosx.png") : ColorButton.class.getResource("resources/cursors/pipette16x16.png"), ColorButton.class.getResource("resources/cursors/pipette32x32.png"), 0.0f, 1.0f, "Pipette", Cursor.getPredefinedCursor(1));
            this.grayColorChart.setCursor(cursor);
            ToolTipManager.sharedInstance().registerComponent(this.grayColorChart);
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    PalettesColorChooserPanel.this.getColorSelectionModel().setSelectedColor(PalettesColorChooserPanel.this.grayColorChart.getColorAt(mouseEvent.getY()));
                    if (mouseEvent.getClickCount() == 2) {
                        PalettesColorChooserPanel.this.clickOnOk();
                    }
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mousePressed(mouseEvent);
                }
            };
            this.grayColorChart.addMouseListener(mouseInputAdapter);
            this.grayColorChart.addMouseMotionListener(mouseInputAdapter);
            this.colorChart = new ColorChart();
            this.colorChart.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.colorChart.setCursor(cursor);
            ToolTipManager.sharedInstance().registerComponent(this.colorChart);
            MouseInputAdapter mouseInputAdapter2 = new MouseInputAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    PalettesColorChooserPanel.this.getColorSelectionModel().setSelectedColor(PalettesColorChooserPanel.this.colorChart.getColorAt(mouseEvent.getX(), mouseEvent.getY()));
                    if (mouseEvent.getClickCount() == 2) {
                        PalettesColorChooserPanel.this.clickOnOk();
                    }
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mousePressed(mouseEvent);
                }
            };
            this.colorChart.addMouseListener(mouseInputAdapter2);
            this.colorChart.addMouseMotionListener(mouseInputAdapter2);
            JLabel jLabel = new JLabel(this.preferences.getLocalizedString(ColorButton.class, "colorLabel.text", new Object[0]));
            this.colorComponent = new JComponent(){

                protected void paintComponent(Graphics graphics) {
                    Insets insets = this.getInsets();
                    int n = this.getWidth() - insets.right - insets.left;
                    int n2 = this.getHeight() - insets.bottom - insets.top;
                    graphics.setColor(Color.GRAY);
                    graphics.translate(insets.left, insets.top);
                    graphics.drawRect(0, 0, n / 2 - 1, n2 - 1);
                    graphics.drawRect(n / 2, 0, n / 2 - 1, n2 - 1);
                    graphics.setColor(PalettesColorChooserPanel.this.initialColor);
                    graphics.fillRect(1, 1, n / 2 - 2, n2 - 2);
                    graphics.setColor(PalettesColorChooserPanel.this.getColorSelectionModel().getSelectedColor());
                    graphics.fillRect(n / 2 + 1, 1, n / 2 - 2, n2 - 2);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(60, 30);
                }
            };
            this.colorComponent.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getX() < mouseEvent.getComponent().getWidth() / 2) {
                        PalettesColorChooserPanel.this.getColorSelectionModel().setSelectedColor(PalettesColorChooserPanel.this.initialColor);
                    }
                }
            });
            this.colorComponent.setCursor(cursor);
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Serializable serializable;
                    Window window = SwingUtilities.getWindowAncestor(PalettesColorChooserPanel.this.getParent());
                    if (!(window instanceof Frame)) {
                        window = JOptionPane.getRootFrame();
                    }
                    final JDialog jDialog = new JDialog((Frame)window);
                    jDialog.setUndecorated(true);
                    jDialog.setModal(true);
                    jDialog.setSize(3, 3);
                    try {
                        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                            Window.class.getMethod("setOpacity", Float.TYPE).invoke((Object)jDialog, Float.valueOf(0.05f));
                            jDialog.setSize(10, 10);
                        } else if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
                            serializable = Class.forName("com.sun.awt.AWTUtilities");
                            ((Class)serializable).getMethod("setWindowOpacity", Window.class, Float.TYPE).invoke(null, jDialog, Float.valueOf(0.05f));
                            jDialog.setSize(10, 10);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    serializable = MouseInfo.getPointerInfo().getLocation();
                    jDialog.setLocation(((Point)serializable).x - jDialog.getWidth() / 2, ((Point)serializable).y - jDialog.getHeight() / 2);
                    ((Point)serializable).setLocation(-1, -1);
                    jDialog.setCursor(cursor);
                    final Timer timer = new Timer(10, new ActionListener((Point)serializable, jDialog){
                        final /* synthetic */ Point val$mouseLocation;
                        final /* synthetic */ JDialog val$pipetteWindow;
                        {
                            this.val$mouseLocation = point;
                            this.val$pipetteWindow = jDialog;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            Point point = MouseInfo.getPointerInfo().getLocation();
                            if (!this.val$mouseLocation.equals(point)) {
                                this.val$mouseLocation.setLocation(point);
                                this.val$pipetteWindow.setLocation(this.val$mouseLocation.x - this.val$pipetteWindow.getWidth() / 2, this.val$mouseLocation.y - this.val$pipetteWindow.getHeight() / 2);
                                this.val$pipetteWindow.setCursor(cursor);
                            }
                        }
                    });
                    timer.start();
                    jDialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "Close");
                    final AbstractAction abstractAction = new AbstractAction(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            timer.stop();
                            jDialog.dispose();
                        }
                    };
                    jDialog.getRootPane().getActionMap().put("Close", abstractAction);
                    jDialog.addWindowFocusListener(new WindowFocusListener(){

                        public void windowLostFocus(WindowEvent windowEvent) {
                            abstractAction.actionPerformed(null);
                        }

                        public void windowGainedFocus(WindowEvent windowEvent) {
                        }
                    });
                    jDialog.addMouseListener(new MouseAdapter(){

                        public void mousePressed(MouseEvent mouseEvent) {
                            try {
                                abstractAction.actionPerformed(null);
                                PalettesColorChooserPanel.this.getColorSelectionModel().setSelectedColor(this.getColorAtMouseLocation());
                            }
                            catch (AWTException aWTException) {
                                aWTException.printStackTrace();
                            }
                        }
                    });
                    jDialog.setVisible(true);
                }

                private Color getColorAtMouseLocation() throws AWTException {
                    BufferedImage bufferedImage = new Robot().createScreenCapture(new Rectangle(MouseInfo.getPointerInfo().getLocation(), new Dimension(1, 1)));
                    int[] nArray = bufferedImage.getRGB(0, 0, 1, 1, null, 0, 1);
                    return new Color(nArray[0]);
                }
            };
            abstractAction.putValue("SmallIcon", new ImageIcon(OperatingSystem.isMacOSX() ? ColorButton.class.getResource("resources/cursors/pipette16x16-macosx.png") : ColorButton.class.getResource("resources/cursors/pipette16x16.png")));
            JButton jButton = new JButton(abstractAction);
            jButton.setFocusable(false);
            jButton.setPreferredSize(new Dimension(30, 30));
            JLabel jLabel2 = new JLabel(SwingTools.getLocalizedLabelText(this.preferences, ColorButton.class, "rgbLabel.text", new Object[0]));
            this.rgbTextField = new JFormattedTextField(new Format(){

                public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
                    stringBuffer.append(String.format("#%6X", ((Color)object).getRGB() & 0xFFFFFF).replace(' ', '0'));
                    fieldPosition.setEndIndex(fieldPosition.getEndIndex() + 7);
                    return stringBuffer;
                }

                public Object parseObject(String string, ParsePosition parsePosition) {
                    if (string.length() == 7 && string.charAt(0) == '#') {
                        try {
                            Color color = Color.decode(string);
                            parsePosition.setIndex(parsePosition.getIndex() + 7);
                            return color;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            });
            this.rgbTextField.setColumns(5);
            this.rgbTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    try {
                        PalettesColorChooserPanel.this.rgbTextField.commitEdit();
                        PalettesColorChooserPanel.this.getColorSelectionModel().setSelectedColor((Color)PalettesColorChooserPanel.this.rgbTextField.getValue());
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            });
            JLabel jLabel3 = new JLabel(SwingTools.getLocalizedLabelText(this.preferences, ColorButton.class, "ralLabel.text", new Object[0]));
            this.ralComboBox = new PaletteComboBox(ColorCode.RAL_COLORS);
            ItemListener itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    ColorCode colorCode = (ColorCode)((JComboBox)itemEvent.getSource()).getSelectedItem();
                    if (colorCode != null) {
                        PalettesColorChooserPanel.this.getColorSelectionModel().setSelectedColor(new Color(colorCode.getRGB()));
                    }
                }
            };
            this.ralComboBox.addItemListener(itemListener);
            JLabel jLabel4 = new JLabel(SwingTools.getLocalizedLabelText(this.preferences, ColorButton.class, "creativeCommonsLabel.text", new Object[0]));
            this.creativeCommonsComboBox = new PaletteComboBox(ColorCode.CREATIVE_COMMONS_COLORS);
            this.creativeCommonsComboBox.addItemListener(itemListener);
            if (!OperatingSystem.isMacOSX()) {
                jLabel2.setDisplayedMnemonic(KeyStroke.getKeyStroke(this.preferences.getLocalizedString(ColorButton.class, "rgbLabel.mnemonic", new Object[0])).getKeyCode());
                jLabel2.setLabelFor(this.rgbTextField);
                jLabel3.setDisplayedMnemonic(KeyStroke.getKeyStroke(this.preferences.getLocalizedString(ColorButton.class, "ralLabel.mnemonic", new Object[0])).getKeyCode());
                jLabel3.setLabelFor(this.ralComboBox);
                jLabel4.setDisplayedMnemonic(KeyStroke.getKeyStroke(this.preferences.getLocalizedString(ColorButton.class, "creativeCommonsLabel.mnemonic", new Object[0])).getKeyCode());
                jLabel4.setLabelFor(this.creativeCommonsComboBox);
            }
            this.setLayout(new GridBagLayout());
            int n = 21;
            this.add((Component)this.grayColorChart, new GridBagConstraints(0, 0, 1, 7, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.colorChart, new GridBagConstraints(1, 0, 1, 7, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.add((Component)jLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 8, 5), 0, 0));
            this.add((Component)this.colorComponent, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 8, 0), 0, 0));
            this.add((Component)jButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 8, 0), 0, 0));
            this.add((Component)jLabel2, new GridBagConstraints(2, 1, 3, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 2, 0), 0, 0));
            this.add((Component)this.rgbTextField, new GridBagConstraints(2, 2, 3, 1, 0.0, 0.0, 21, 2, OperatingSystem.isMacOSX() ? new Insets(0, 1, 5, 1) : new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)jLabel3, new GridBagConstraints(2, 3, 3, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 2, 0), 0, 0));
            this.add((Component)this.ralComboBox, new GridBagConstraints(2, 4, 3, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)jLabel4, new GridBagConstraints(2, 5, 3, 1, 0.0, 0.0, n, 0, new Insets(0, 0, 2, 0), 0, 0));
            this.add((Component)this.creativeCommonsComboBox, new GridBagConstraints(2, 6, 3, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.getColorSelectionModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    PalettesColorChooserPanel.this.updateChooser();
                }
            });
        }

        private void clickOnOk() {
            JRootPane jRootPane = (JRootPane)SwingUtilities.getAncestorOfClass(JRootPane.class, this);
            if (jRootPane != null) {
                for (JButton jButton : SwingTools.findChildren(jRootPane, JButton.class)) {
                    if (!"OK".equals(jButton.getActionCommand())) continue;
                    jButton.doClick();
                }
            }
        }

        public String getDisplayName() {
            return this.preferences.getLocalizedString(ColorButton.class, "chooserPanel.title", new Object[0]);
        }

        public Icon getSmallDisplayIcon() {
            return null;
        }

        public Icon getLargeDisplayIcon() {
            return null;
        }
    }
}

