/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.state;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import org.apache.commons.httpclient.HttpState;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionState
extends ExtensionAdaptor
implements SessionChangedListener {
    private JCheckBoxMenuItem menuSessionTrackingEnable = null;
    private ZapMenuItem menuResetSessionState = null;

    public ExtensionState() {
        this.initialize();
    }

    public ExtensionState(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionState");
        this.setOrder(12);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addEditMenuItem(extensionHook.getHookMenu().getMenuSeparator());
            extensionHook.getHookMenu().addEditMenuItem(this.getMenuSessionTrackingEnable());
            extensionHook.getHookMenu().addEditMenuItem(this.getMenuResetSessionState());
        }
    }

    private JCheckBoxMenuItem getMenuSessionTrackingEnable() {
        if (this.menuSessionTrackingEnable == null) {
            this.menuSessionTrackingEnable = new JCheckBoxMenuItem();
            this.menuSessionTrackingEnable.setText(Constant.messages.getString("menu.edit.enableTracking"));
            this.getMenuResetSessionState().setEnabled(this.menuSessionTrackingEnable.isSelected());
            this.menuSessionTrackingEnable.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ExtensionState.this.getModel().getOptionsParam().getConnectionParam().setHttpStateEnabled(ExtensionState.this.menuSessionTrackingEnable.isEnabled());
                    ExtensionState.this.getMenuResetSessionState().setEnabled(ExtensionState.this.menuSessionTrackingEnable.isSelected());
                    ExtensionState.this.resetSessionState();
                }
            });
        }
        return this.menuSessionTrackingEnable;
    }

    private ZapMenuItem getMenuResetSessionState() {
        if (this.menuResetSessionState == null) {
            this.menuResetSessionState = new ZapMenuItem("menu.edit.resetState");
            this.menuResetSessionState.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ExtensionState.this.getView().showConfirmDialog(Constant.messages.getString("state.reset.warning")) == 0) {
                        ExtensionState.this.resetSessionState();
                    }
                }
            });
        }
        return this.menuResetSessionState;
    }

    @Override
    public void sessionChanged(Session session) {
        this.getModel().getOptionsParam().getConnectionParam().setHttpState(new HttpState());
    }

    private void resetSessionState() {
        this.getModel().getOptionsParam().getConnectionParam().setHttpState(new HttpState());
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

