/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.api.ExtensionAPI;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsApiPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JPanel panelMisc = null;
    private JCheckBox chkEnabled = null;
    private JCheckBox chkSecureOnly = null;
    private JCheckBox disableKey = null;
    private JCheckBox incErrorDetails = null;
    private JCheckBox autofillKey = null;
    private JCheckBox enableJSONP = null;
    private ZapTextField keyField = null;
    private JButton generateKeyButton = null;

    public OptionsApiPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("api.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            this.panelMisc.add((Component)this.getChkEnabled(), LayoutHelper.getGBC(0, 0, 1, 0.5));
            this.panelMisc.add((Component)this.getChkSecureOnly(), LayoutHelper.getGBC(0, 1, 1, 0.5));
            this.panelMisc.add((Component)new JLabel(Constant.messages.getString("api.options.label.apiKey")), LayoutHelper.getGBC(0, 2, 1, 0.5));
            this.panelMisc.add((Component)this.getKeyField(), LayoutHelper.getGBC(1, 2, 1, 0.5));
            this.panelMisc.add((Component)this.getGenerateKeyButton(), LayoutHelper.getGBC(1, 3, 1, 0.5));
            JLabel jLabel = new JLabel(Constant.messages.getString("api.options.label.testingWarning"));
            jLabel.setForeground(Color.RED);
            this.panelMisc.add((Component)jLabel, LayoutHelper.getGBC(0, 4, 2, 0.5));
            this.panelMisc.add((Component)this.getDisableKey(), LayoutHelper.getGBC(0, 5, 1, 0.5));
            this.panelMisc.add((Component)this.getIncErrorDetails(), LayoutHelper.getGBC(0, 6, 1, 0.5));
            this.panelMisc.add((Component)this.getAutofillKey(), LayoutHelper.getGBC(0, 7, 1, 0.5));
            this.panelMisc.add((Component)this.getEnableJSONP(), LayoutHelper.getGBC(0, 8, 1, 0.5));
            this.panelMisc.add((Component)new JLabel(), LayoutHelper.getGBC(0, 10, 1, 0.5, 1.0));
        }
        return this.panelMisc;
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText(Constant.messages.getString("api.options.enabled"));
            this.chkEnabled.setVerticalAlignment(1);
            this.chkEnabled.setVerticalTextPosition(1);
        }
        return this.chkEnabled;
    }

    private JCheckBox getChkSecureOnly() {
        if (this.chkSecureOnly == null) {
            this.chkSecureOnly = new JCheckBox();
            this.chkSecureOnly.setText(Constant.messages.getString("api.options.secure"));
            this.chkSecureOnly.setVerticalAlignment(1);
            this.chkSecureOnly.setVerticalTextPosition(1);
        }
        return this.chkSecureOnly;
    }

    private JCheckBox getDisableKey() {
        if (this.disableKey == null) {
            this.disableKey = new JCheckBox();
            this.disableKey.setText(Constant.messages.getString("api.options.disableKey"));
            this.disableKey.setVerticalAlignment(1);
            this.disableKey.setVerticalTextPosition(1);
            this.disableKey.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsApiPanel.this.getKeyField().setEnabled(!OptionsApiPanel.this.disableKey.isSelected());
                    OptionsApiPanel.this.getGenerateKeyButton().setEnabled(!OptionsApiPanel.this.disableKey.isSelected());
                    if (!OptionsApiPanel.this.disableKey.isSelected()) {
                        OptionsApiPanel.this.getKeyField().setText(Model.getSingleton().getOptionsParam().getApiParam().getRealKey());
                    }
                }
            });
        }
        return this.disableKey;
    }

    private JCheckBox getEnableJSONP() {
        if (this.enableJSONP == null) {
            this.enableJSONP = new JCheckBox();
            this.enableJSONP.setText(Constant.messages.getString("api.options.enableJSONP"));
            this.enableJSONP.setVerticalAlignment(1);
            this.enableJSONP.setVerticalTextPosition(1);
        }
        return this.enableJSONP;
    }

    private JCheckBox getIncErrorDetails() {
        if (this.incErrorDetails == null) {
            this.incErrorDetails = new JCheckBox();
            this.incErrorDetails.setText(Constant.messages.getString("api.options.incErrors"));
            this.incErrorDetails.setVerticalAlignment(1);
            this.incErrorDetails.setVerticalTextPosition(1);
        }
        return this.incErrorDetails;
    }

    private JCheckBox getAutofillKey() {
        if (this.autofillKey == null) {
            this.autofillKey = new JCheckBox();
            this.autofillKey.setText(Constant.messages.getString("api.options.autofillKey"));
            this.autofillKey.setVerticalAlignment(1);
            this.autofillKey.setVerticalTextPosition(1);
        }
        return this.autofillKey;
    }

    private ZapTextField getKeyField() {
        if (this.keyField == null) {
            this.keyField = new ZapTextField();
        }
        return this.keyField;
    }

    private JButton getGenerateKeyButton() {
        if (this.generateKeyButton == null) {
            this.generateKeyButton = new JButton(Constant.messages.getString("api.options.button.generateKey"));
            this.generateKeyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsApiPanel.this.getKeyField().setText(ExtensionAPI.generateApiKey());
                }
            });
        }
        return this.generateKeyButton;
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        this.getChkEnabled().setSelected(optionsParam.getApiParam().isEnabled());
        this.getChkSecureOnly().setSelected(optionsParam.getApiParam().isSecureOnly());
        this.getDisableKey().setSelected(optionsParam.getApiParam().isDisableKey());
        this.getIncErrorDetails().setSelected(optionsParam.getApiParam().isIncErrorDetails());
        this.getAutofillKey().setSelected(optionsParam.getApiParam().isAutofillKey());
        this.getEnableJSONP().setSelected(optionsParam.getApiParam().isEnableJSONP());
        this.getKeyField().setText(optionsParam.getApiParam().getKey());
        this.getKeyField().setEnabled(!this.disableKey.isSelected());
        this.getGenerateKeyButton().setEnabled(!this.disableKey.isSelected());
    }

    @Override
    public void validateParam(Object object) throws Exception {
        if (!this.getDisableKey().isSelected() && this.getKeyField().getText().length() == 0) {
            throw new Exception(Constant.messages.getString("api.options.nokey.error"));
        }
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        optionsParam.getApiParam().setEnabled(this.getChkEnabled().isSelected());
        optionsParam.getApiParam().setSecureOnly(this.getChkSecureOnly().isSelected());
        optionsParam.getApiParam().setDisableKey(this.getDisableKey().isSelected());
        optionsParam.getApiParam().setIncErrorDetails(this.getIncErrorDetails().isSelected());
        optionsParam.getApiParam().setAutofillKey(this.getAutofillKey().isSelected());
        optionsParam.getApiParam().setEnableJSONP(this.getEnableJSONP().isSelected());
        if (!this.getDisableKey().isSelected()) {
            optionsParam.getApiParam().setKey(this.getKeyField().getText());
        }
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.api";
    }
}

